/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PlainView
extends View
implements TabExpander {
    Color selectedColor;
    Color unselectedColor;
    Color disabledColor;
    Font font;
    float maxLineLength;
    Element longestLine;
    protected FontMetrics metrics;
    private transient Segment lineBuffer;

    protected void updateMetrics() {
        Container component = this.getContainer();
        Font font = component.getFont();
        if (this.font != font) {
            this.font = font;
            this.metrics = component.getFontMetrics(font);
        }
    }

    protected Rectangle lineToRect(Shape a, int line) {
        this.updateMetrics();
        Rectangle rect = a.getBounds();
        int fontHeight = this.metrics.getHeight();
        return new Rectangle(rect.x, rect.y + line * fontHeight, rect.width, fontHeight);
    }

    public Shape modelToView(int position, Shape a, Position.Bias b) throws BadLocationException {
        this.updateMetrics();
        Document document = this.getDocument();
        int lineIndex = this.getElement().getElementIndex(position);
        Rectangle rect = this.lineToRect(a, lineIndex);
        Element line = this.getElement().getElement(lineIndex);
        int lineStart = line.getStartOffset();
        Segment segment = this.getLineBuffer();
        document.getText(lineStart, position - lineStart, segment);
        int xoffset = Utilities.getTabbedTextWidth(segment, this.metrics, rect.x, this, lineStart);
        rect.x += xoffset;
        rect.width = 1;
        rect.height = this.metrics.getHeight();
        return rect;
    }

    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        try {
            this.metrics = g.getFontMetrics();
            Element line = this.getElement().getElement(lineIndex);
            this.drawUnselectedText(g, x, y, line.getStartOffset(), line.getEndOffset());
        }
        catch (BadLocationException e) {
            AssertionError ae = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        g.setColor(this.selectedColor);
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(p0, p1 - p0, segment);
        return Utilities.drawTabbedText(segment, x, y, g, this, 0);
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        JTextComponent textComponent = (JTextComponent)this.getContainer();
        if (textComponent.isEnabled()) {
            g.setColor(this.unselectedColor);
        } else {
            g.setColor(this.disabledColor);
        }
        Segment segment = this.getLineBuffer();
        this.getDocument().getText(p0, p1 - p0, segment);
        return Utilities.drawTabbedText(segment, x, y, g, this, segment.offset);
    }

    public void paint(Graphics g, Shape s) {
        this.updateMetrics();
        JTextComponent textComponent = (JTextComponent)this.getContainer();
        g.setFont(textComponent.getFont());
        this.selectedColor = textComponent.getSelectedTextColor();
        this.unselectedColor = textComponent.getForeground();
        this.disabledColor = textComponent.getDisabledTextColor();
        Rectangle rect = s.getBounds();
        Document document = textComponent.getDocument();
        Element root = document.getDefaultRootElement();
        int y = rect.y;
        int i = 0;
        while (i < root.getElementCount()) {
            this.drawLine(i, g, rect.x, y);
            y += this.metrics.getHeight();
            ++i;
        }
    }

    protected int getTabSize() {
        Object tabSize = this.getDocument().getProperty("tabSize");
        if (tabSize == null) {
            return 8;
        }
        return (Integer)tabSize;
    }

    public float nextTabStop(float x, int tabStop) {
        float tabSizePixels = this.getTabSize() * this.metrics.charWidth('m');
        return (float)(Math.floor(x / tabSizePixels) + 1.0) * tabSizePixels;
    }

    float determineMaxLineLength() {
        if (this.maxLineLength != -1.0f) {
            return this.maxLineLength;
        }
        Element el = this.getElement();
        Segment seg = this.getLineBuffer();
        float span = 0.0f;
        int i = 0;
        while (i < el.getElementCount()) {
            int width;
            Element child = el.getElement(i);
            int start = child.getStartOffset();
            int end = child.getEndOffset();
            try {
                el.getDocument().getText(start, end - start, seg);
            }
            catch (BadLocationException ex) {
                AssertionError ae = new AssertionError((Object)"Unexpected bad location");
                ((Throwable)((Object)ae)).initCause(ex);
                throw ae;
            }
            if (seg != null && seg.array != null && seg.count != 0 && (float)(width = this.metrics.charsWidth(seg.array, seg.offset, seg.count)) > span) {
                this.longestLine = child;
                span = width;
            }
            ++i;
        }
        this.maxLineLength = span;
        return this.maxLineLength;
    }

    public float getPreferredSpan(int axis) {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException();
        }
        this.updateMetrics();
        float span = 0.0f;
        Element el = this.getElement();
        switch (axis) {
            case 0: {
                span = this.determineMaxLineLength();
            }
        }
        span = this.metrics.getHeight() * el.getElementCount();
        return span;
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
        Rectangle rec = a.getBounds();
        Document doc = this.getDocument();
        Element root = doc.getDefaultRootElement();
        int lineClicked = (int)(y - (float)rec.y) / this.metrics.getHeight();
        if (lineClicked >= root.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element line = root.getElement(lineClicked);
        Segment s = this.getLineBuffer();
        int start = line.getStartOffset();
        int end = line.getEndOffset();
        try {
            doc.getText(start, end - start, s);
        }
        catch (BadLocationException ble) {
            AssertionError ae = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)ae)).initCause(ble);
            throw ae;
        }
        int pos = Utilities.getTabbedTextOffset(s, this.metrics, rec.x, (int)x, this, start);
        return Math.max(0, pos);
    }

    protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f) {
        Element el = this.getElement();
        DocumentEvent.ElementChange ec = changes.getChange(el);
        if (ec == null) {
            int line = this.getElement().getElementIndex(changes.getOffset());
            this.damageLineRange(line, line, a, this.getContainer());
            return;
        }
        Element[] removed = ec.getChildrenRemoved();
        Element[] newElements = ec.getChildrenAdded();
        if (removed == null && newElements == null) {
            int line = this.getElement().getElementIndex(changes.getOffset());
            this.damageLineRange(line, line, a, this.getContainer());
            return;
        }
        if (removed != null) {
            int i = 0;
            while (i < removed.length) {
                if (removed[i].equals(this.longestLine)) {
                    this.maxLineLength = -1.0f;
                    this.determineMaxLineLength();
                    ((JTextComponent)this.getContainer()).repaint();
                    return;
                }
                ++i;
            }
        }
        if (newElements == null) {
            ((JTextComponent)this.getContainer()).repaint();
            return;
        }
        this.updateMetrics();
        Segment seg = this.getLineBuffer();
        float longestNewLength = 0.0f;
        Element longestNewLine = null;
        int i = 0;
        while (i < newElements.length) {
            int width;
            Element child = newElements[i];
            int start = child.getStartOffset();
            int end = child.getEndOffset();
            try {
                el.getDocument().getText(start, end - start, seg);
            }
            catch (BadLocationException ex) {
                AssertionError ae = new AssertionError((Object)"Unexpected bad location");
                ((Throwable)((Object)ae)).initCause(ex);
                throw ae;
            }
            if (seg != null && seg.array != null && seg.count != 0 && (float)(width = this.metrics.charsWidth(seg.array, seg.offset, seg.count)) > longestNewLength) {
                longestNewLine = child;
                longestNewLength = width;
            }
            ++i;
        }
        if (longestNewLength > this.maxLineLength) {
            this.maxLineLength = longestNewLength;
            this.longestLine = longestNewLine;
        }
        ((JTextComponent)this.getContainer()).repaint();
    }

    public void insertUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    public void removeUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    public void changedUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    protected void damageLineRange(int line0, int line1, Shape a, Component host) {
        if (a == null) {
            return;
        }
        Rectangle rec0 = this.lineToRect(a, line0);
        Rectangle rec1 = this.lineToRect(a, line1);
        if (rec0 == null || rec1 == null) {
            host.repaint();
        } else {
            Rectangle repaintRec = rec0.union(rec1);
            host.repaint();
        }
    }

    protected Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    private final /* synthetic */ void this() {
        this.maxLineLength = -1.0f;
        this.longestLine = null;
    }

    public PlainView(Element elem) {
        super(elem);
        this.this();
    }
}

