/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.jsp.logic;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Logger;
import org.igoweb.igoweb.Config;
import org.igoweb.igoweb.jsp.logic.Invoice;
import org.igoweb.igoweb.jsp.logic.InvoiceManager;
import org.igoweb.igoweb.jsp.logic.Product;
import org.igoweb.igoweb.shared.PUser;
import org.igoweb.util.DbConn;
import org.igoweb.util.DbConnFactory;
import org.igoweb.util.jsp.AbstractPayPalIpnServlet;
import org.igoweb.util.jsp.PaymentMethod;

public class PayPalIpnServlet
extends AbstractPayPalIpnServlet<Invoice, PUser, Product, InvoiceManager> {
    public static final String INVOICE_MANAGER_KEY = PayPalIpnServlet.class.getName() + ":im";
    public static final String DB_MASTER_CONN_FACTORY_KEY = "masterFactory";
    private static final HashSet<String> MY_EMAILS = new HashSet();

    @Override
    public void init() {
        this.setDbConnFactory((DbConnFactory)this.getServletContext().getAttribute(DB_MASTER_CONN_FACTORY_KEY));
        this.setInvoiceManager((InvoiceManager)this.getServletContext().getAttribute(INVOICE_MANAGER_KEY));
        super.init();
    }

    @Override
    protected String getPayPalHost() {
        return Config.get("payPalHost");
    }

    @Override
    protected String getCurrencyNeeded() {
        return "USD";
    }

    @Override
    protected Logger getLogger() {
        return ((InvoiceManager)this.getInvoiceManager()).getLogger();
    }

    @Override
    protected PUser getUser(String payerEmail, String custom) {
        try (DbConn db = this.getDbConn();){
            PUser pUser = PUser.load(db, custom);
            return pUser;
        }
    }

    @Override
    protected boolean isDestValid(String destEmail) {
        return MY_EMAILS.contains(destEmail.toLowerCase(Locale.US));
    }

    @Override
    protected boolean isPurchaseValid(PUser user, Product product, double payment) throws SQLException {
        return product.getCost() > 0.0 && product.getCost() == payment && product.isPurchaseable(user.getAuthLevel(), user.id, this.getDbConnFactory());
    }

    @Override
    protected Invoice createInvoice(PUser user, Product product, double cost, double fee, String notes) {
        return ((InvoiceManager)this.getInvoiceManager()).createInvoice(user, product, cost, -1, PaymentMethod.PAYPAL, product.getDuration(), product.getDurationUnits(), notes);
    }

    static {
        MY_EMAILS.add("wms@igoweb.org");
        MY_EMAILS.add("admin@igoweb.org");
        MY_EMAILS.add(Config.get("adminEmail"));
    }
}

