/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.transforms;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.classanalysis.AsmConstants;
import org.gradle.internal.classloader.TransformReplacer;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.classpath.transforms.BaseClasspathElementTransform;
import org.gradle.internal.classpath.transforms.ClassTransform;
import org.gradle.internal.classpath.types.InstrumentationTypeRegistry;
import org.gradle.util.internal.JarUtil;

class ClasspathElementTransformForAgent
extends BaseClasspathElementTransform {
    private static final Logger LOGGER = Logging.getLogger(ClasspathElementTransformForAgent.class);
    private int lowestUnsupportedVersionInJar = Integer.MAX_VALUE;
    private boolean isMultiReleaseJar;

    ClasspathElementTransformForAgent(File source, ClasspathBuilder classpathBuilder, ClasspathWalker classpathWalker, InstrumentationTypeRegistry typeRegistry, ClassTransform transform) {
        super(source, classpathBuilder, classpathWalker, typeRegistry, transform);
    }

    @Override
    protected void processClassFile(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry classEntry) throws IOException {
        int version = JarUtil.getVersionedDirectoryMajorVersion(classEntry.getName()).orElse(1);
        if (AsmConstants.isSupportedVersion((int)version)) {
            super.processClassFile(builder, classEntry);
        } else if (this.lowestUnsupportedVersionInJar > version) {
            this.lowestUnsupportedVersionInJar = version;
        }
    }

    @Override
    protected void processManifest(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry manifestEntry) throws IOException {
        try {
            Manifest parsedManifest = JarUtil.readManifest(manifestEntry.getContent());
            if (!JarUtil.isMultiReleaseJarManifest(parsedManifest)) {
                return;
            }
            this.isMultiReleaseJar = true;
            Manifest processedManifest = new Manifest();
            this.copyManifestMainAttribute(parsedManifest, processedManifest, Attributes.Name.MANIFEST_VERSION);
            this.setManifestMainAttribute(processedManifest, "Multi-Release", "true");
            builder.put(manifestEntry.getName(), this.toByteArray(processedManifest), manifestEntry.getCompressionMethod());
        }
        catch (IOException e) {
            LOGGER.debug("Failed to parse Manifest from JAR " + this.source);
            throw e;
        }
    }

    @Override
    protected void processResource(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry resourceEntry) {
    }

    @Override
    protected void finishProcessing(ClasspathBuilder.EntryBuilder builder) throws IOException {
        if (this.isMultiReleaseJar) {
            builder.put(TransformReplacer.MarkerResource.RESOURCE_NAME, TransformReplacer.MarkerResource.TRANSFORMED.asBytes());
            if (this.hasUnsupportedVersionInJar()) {
                builder.put(JarUtil.toVersionedPath(this.lowestUnsupportedVersionInJar, TransformReplacer.MarkerResource.RESOURCE_NAME), TransformReplacer.MarkerResource.NOT_TRANSFORMED.asBytes());
            }
        }
    }

    private boolean hasUnsupportedVersionInJar() {
        return this.lowestUnsupportedVersionInJar < Integer.MAX_VALUE;
    }

    private void copyManifestMainAttribute(Manifest source, Manifest destination, Attributes.Name name) {
        destination.getMainAttributes().put(name, source.getMainAttributes().getValue(name));
    }

    private void setManifestMainAttribute(Manifest manifest, String name, String value) {
        manifest.getMainAttributes().putValue(name, value);
    }

    private byte[] toByteArray(Manifest manifest) throws IOException {
        ByteArrayOutputStream manifestOutput = new ByteArrayOutputStream(512);
        manifest.write(manifestOutput);
        return manifestOutput.toByteArray();
    }
}

