/*
 * Decompiled with CFR 0.152.
 */
package free.jin.console;

import free.jin.I18n;
import free.jin.Preferences;
import free.jin.console.Command;
import free.jin.console.Console;
import free.util.PlatformUtils;
import free.workarounds.FixUtils;
import free.workarounds.FixedJTextField;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class ConsoleTextField
extends FixedJTextField {
    protected final Console console;
    private KeyStroke tellLastTellerKeyStroke;
    private KeyStroke tellNextTellerKeyStroke;
    private final Vector history = new Vector();
    private int currentHistoryIndex = -1;
    private String typedInString = "";
    private int tellerIndex = -1;
    private JPopupMenu popup;
    private JMenuItem cut;
    private JMenuItem copy;
    private JMenuItem paste;

    public ConsoleTextField(Console console) {
        this.console = console;
        this.enableEvents(28L);
        this.initFromProperties();
        Font font = this.getFont();
        this.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
    }

    protected void initFromProperties() {
        if (this.tellLastTellerKeyStroke != null) {
            this.unregisterKeyboardAction(this.tellLastTellerKeyStroke);
        }
        if (this.tellNextTellerKeyStroke != null) {
            this.unregisterKeyboardAction(this.tellNextTellerKeyStroke);
        }
        Preferences preferences = this.console.getPrefs();
        String string = "." + PlatformUtils.getOSName();
        String string2 = (String)preferences.lookup("tell-last-teller-keystroke" + string, null);
        String string3 = preferences.getString("tell-next-teller-keystroke" + string, null);
        if (string2 != null) {
            this.tellLastTellerKeyStroke = KeyStroke.getKeyStroke(string2);
            this.registerKeyboardAction(new TellLastTellerAction(), this.tellLastTellerKeyStroke, 0);
        }
        if (string3 != null) {
            this.tellNextTellerKeyStroke = KeyStroke.getKeyStroke(string3);
            this.registerKeyboardAction(new TellNextTellerAction(), this.tellNextTellerKeyStroke, 0);
        }
    }

    public void refreshFromProperties() {
        this.initFromProperties();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.isShiftDown();
        boolean bl2 = keyEvent.isMetaDown();
        if (keyEvent.getID() == 401 && (n == 155 && bl || n == 86 && bl2)) {
            this.paste();
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent);
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
        super.processComponentKeyEvent(keyEvent);
        boolean bl = keyEvent.isControlDown();
        boolean bl2 = keyEvent.isShiftDown();
        if (keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    String string = this.getText();
                    long l = 0L;
                    if (bl2) {
                        l |= 2L;
                    }
                    if (bl) {
                        l |= 1L;
                    }
                    if ((l & 2L) == 0L) {
                        this.history.removeElement(string);
                        this.history.insertElementAt(string, 0);
                    }
                    this.typedInString = "";
                    this.setText(this.typedInString);
                    this.currentHistoryIndex = -1;
                    this.console.issueCommand(new Command(string, l));
                    break;
                }
                case 27: {
                    if (keyEvent.getModifiers() != 0) break;
                    this.typedInString = "";
                    this.setText("");
                    this.currentHistoryIndex = -1;
                    break;
                }
                case 38: {
                    if (keyEvent.getModifiers() != 0) break;
                    if (this.currentHistoryIndex == -1) {
                        this.typedInString = this.getText();
                    }
                    int n = this.currentHistoryIndex;
                    while (++n < this.history.size()) {
                        String string = (String)this.history.elementAt(n);
                        if (!string.startsWith(this.typedInString)) continue;
                        this.currentHistoryIndex = n;
                        break;
                    }
                    if (n == this.history.size()) {
                        this.getToolkit().beep();
                        break;
                    }
                    this.setText((String)this.history.elementAt(this.currentHistoryIndex));
                    break;
                }
                case 40: {
                    if (keyEvent.getModifiers() != 0) break;
                    if (this.currentHistoryIndex == -1) {
                        this.getToolkit().beep();
                        break;
                    }
                    int n = this.currentHistoryIndex;
                    while (--n >= 0) {
                        String string = (String)this.history.elementAt(n);
                        if (!string.startsWith(this.typedInString)) continue;
                        this.currentHistoryIndex = n;
                        break;
                    }
                    if (n == -1) {
                        this.setText(this.typedInString);
                        this.currentHistoryIndex = -1;
                        break;
                    }
                    this.setText((String)this.history.elementAt(this.currentHistoryIndex));
                    break;
                }
                case 82: {
                    if (!bl) break;
                    String string = this.getText();
                    String string2 = this.getSelectedText();
                    if (string2 == null) break;
                    String string3 = new StringBuffer(string2).reverse().toString();
                    int n = this.getSelectionStart();
                    int n2 = this.getSelectionEnd();
                    this.setText(string.substring(0, n) + string3 + string.substring(n2));
                    this.setSelectionStart(n);
                    this.setSelectionEnd(n2);
                }
            }
            if (keyEvent.getKeyChar() != FixUtils.CHAR_UNDEFINED) {
                this.tellerIndex = -1;
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004) {
            this.setSelectionStart(n);
            this.setSelectionEnd(n2);
        }
    }

    protected void setTellPersonState(String string) {
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            if (this.popup == null) {
                this.popup = this.createPopup();
            }
            this.configurePopup();
            this.popup.setSize(this.popup.getPreferredSize());
            this.popup.show((Component)((Object)this), mouseEvent.getX(), Math.min(mouseEvent.getY(), this.getHeight() - this.popup.getHeight()));
        }
    }

    protected JPopupMenu createPopup() {
        I18n i18n = I18n.get((Class)ConsoleTextField.class);
        this.cut = new JMenuItem(i18n.getString("cutMenuItemLabel"));
        this.copy = new JMenuItem(i18n.getString("copyMenuItemLabel"));
        this.paste = new JMenuItem(i18n.getString("pasteMenuItemLabel"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == ConsoleTextField.this.cut) {
                    ConsoleTextField.this.cut();
                } else if (object == ConsoleTextField.this.copy) {
                    ConsoleTextField.this.copy();
                } else if (object == ConsoleTextField.this.paste) {
                    ConsoleTextField.this.paste();
                }
            }
        };
        this.cut.addActionListener(actionListener);
        this.copy.addActionListener(actionListener);
        this.paste.addActionListener(actionListener);
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.cut);
        jPopupMenu.add(this.copy);
        jPopupMenu.add(this.paste);
        return jPopupMenu;
    }

    protected void configurePopup() {
        boolean bl = this.getSelectedText() != null && !"".equals(this.getSelectedText());
        this.cut.setEnabled(bl);
        this.copy.setEnabled(bl);
        this.paste.setEnabled(true);
    }

    private class TellNextTellerAction
    implements ActionListener {
        private TellNextTellerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            int n = ConsoleTextField.this.console.getTellerRingSize();
            ConsoleTextField.this.tellerIndex--;
            if (ConsoleTextField.this.tellerIndex < 0) {
                ConsoleTextField.this.tellerIndex = Math.min(n, ConsoleTextField.this.console.getTellerCount()) - 1;
            }
            if ((string = ConsoleTextField.this.console.getTeller(ConsoleTextField.this.tellerIndex)) != null) {
                ConsoleTextField.this.setTellPersonState(string);
            }
        }
    }

    private class TellLastTellerAction
    implements ActionListener {
        private TellLastTellerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            int n = ConsoleTextField.this.console.getTellerRingSize();
            ConsoleTextField.this.tellerIndex++;
            if (ConsoleTextField.this.tellerIndex == ConsoleTextField.this.console.getTellerCount() || ConsoleTextField.this.tellerIndex == n) {
                ConsoleTextField.this.tellerIndex = 0;
            }
            if ((string = ConsoleTextField.this.console.getTeller(ConsoleTextField.this.tellerIndex)) != null) {
                ConsoleTextField.this.setTellPersonState(string);
            }
        }
    }
}

