/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.Chess;
import free.chess.ChessPiece;
import free.chess.Move;
import free.chess.Player;
import free.chess.Position;
import free.chess.Square;

public class ChessMove
extends Move {
    private final boolean isEnPassant;
    private final boolean isShortCastling;
    private final boolean isLongCastling;
    private final ChessPiece capturedPiece;
    private final ChessPiece promotionTarget;
    private final int doublePawnPushFile;

    public ChessMove(Square square, Square square2, Player player, boolean bl, boolean bl2, boolean bl3, ChessPiece chessPiece, int n, ChessPiece chessPiece2, String string) {
        super(square, square2, player, string);
        if (square == null) {
            throw new IllegalArgumentException("Starting square may not be null");
        }
        if (square2 == null) {
            throw new IllegalArgumentException("Ending square may not be null");
        }
        this.promotionTarget = chessPiece2;
        this.isEnPassant = bl;
        this.isShortCastling = bl2;
        this.isLongCastling = bl3;
        this.capturedPiece = chessPiece;
        this.doublePawnPushFile = n;
    }

    public ChessMove(Position position, Square square, Square square2, ChessPiece chessPiece, String string) {
        super(square, square2, position.getCurrentPlayer(), string);
        if (square == null) {
            throw new IllegalArgumentException("The starting square may not be null");
        }
        if (square2 == null) {
            throw new IllegalArgumentException("The ending square may not be null");
        }
        if (position.getPieceAt(square) == null) {
            throw new IllegalArgumentException("The moving piece may not be null");
        }
        Chess chess = Chess.getInstance();
        this.promotionTarget = chessPiece;
        this.isEnPassant = chess.isEnPassant(position, square, square2, chessPiece);
        this.isShortCastling = chess.isShortCastling(position, square, square2, chessPiece);
        this.isLongCastling = chess.isLongCastling(position, square, square2, chessPiece);
        this.capturedPiece = chess.getCapturedPiece(position, square, square2, chessPiece, this.isEnPassant);
        this.doublePawnPushFile = chess.getDoublePawnPushFile(position, square, square2);
    }

    public String getWarrenSmithString() {
        ChessPiece chessPiece;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startingSquare.toString());
        stringBuffer.append(this.endingSquare.toString());
        if (this.isEnPassant()) {
            stringBuffer.append('E');
        } else if (this.isShortCastling()) {
            stringBuffer.append('c');
        } else if (this.isLongCastling()) {
            stringBuffer.append('C');
        } else if (this.isCapture()) {
            chessPiece = this.getCapturedPiece();
            if (chessPiece.isPawn()) {
                stringBuffer.append('p');
            } else if (chessPiece.isKnight()) {
                stringBuffer.append('n');
            } else if (chessPiece.isBishop()) {
                stringBuffer.append('b');
            } else if (chessPiece.isRook()) {
                stringBuffer.append('r');
            } else if (chessPiece.isQueen()) {
                stringBuffer.append('q');
            } else if (chessPiece.isKing()) {
                stringBuffer.append('k');
            }
        }
        if (this.isPromotion()) {
            chessPiece = this.getPromotionTarget();
            if (chessPiece.isKnight()) {
                stringBuffer.append('N');
            } else if (chessPiece.isBishop()) {
                stringBuffer.append('B');
            } else if (chessPiece.isRook()) {
                stringBuffer.append('R');
            } else if (chessPiece.isQueen()) {
                stringBuffer.append('Q');
            }
        }
        return stringBuffer.toString();
    }

    public String getSAN() {
        return this.getStringRepresentation();
    }

    public boolean isCapture() {
        return this.capturedPiece != null;
    }

    public ChessPiece getCapturedPiece() {
        return this.capturedPiece;
    }

    public boolean isCastling() {
        return this.isShortCastling || this.isLongCastling;
    }

    public boolean isShortCastling() {
        return this.isShortCastling;
    }

    public boolean isLongCastling() {
        return this.isLongCastling;
    }

    public boolean isEnPassant() {
        return this.isEnPassant;
    }

    public boolean isPromotion() {
        return this.promotionTarget != null;
    }

    public ChessPiece getPromotionTarget() {
        return this.promotionTarget;
    }

    public int getDoublePawnPushFile() {
        return this.doublePawnPushFile;
    }

    public String getMoveString() {
        if (this.isShortCastling()) {
            return "O-O";
        }
        if (this.isLongCastling()) {
            return "O-O-O";
        }
        String string = this.getStartingSquare().toString() + this.getEndingSquare().toString();
        if (this.isPromotion()) {
            return string + "=" + this.getPromotionTarget().toShortString();
        }
        return string;
    }
}

