/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.ftp;

import gnu.java.net.protocol.ftp.DTP;
import gnu.java.net.protocol.ftp.DTPOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class CompressedOutputStream
extends DTPOutputStream {
    static final byte RECORD = -128;
    static final byte EOF = 64;

    public void write(int n) throws IOException {
        if (this.transferComplete) {
            return;
        }
        byte[] byArray = new byte[5];
        byArray[0] = -128;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = (byte)n;
        byte[] byArray2 = byArray;
        this.out.write(byArray2, 0, 5);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.transferComplete) {
            return;
        }
        byte[] byArray2 = this.compress(byArray, n, n2);
        n2 = byArray2.length;
        byArray2[0] = -128;
        byArray2[1] = (byte)((n2 & 0xFF) >> 8);
        byArray2[2] = (byte)(n2 & 0xFF00);
        this.out.write(byArray2, 0, n2);
    }

    byte[] compress(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        byte by = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        int n6 = n;
        while (n6 < n2) {
            byte by2 = byArray[n6];
            if (n6 > n && by2 == by) {
                if (n4 > 0) {
                    if (n3 + (n4 + 1) > byArray2.length) {
                        byArray2 = this.realloc(byArray2, n2);
                    }
                    n3 = this.flush_raw(byArray2, n3, byArray, n6 - n4 - 1, n4);
                    n4 = 0;
                }
                ++n5;
            } else {
                if (n5 > 1) {
                    if (n3 + 2 > byArray2.length) {
                        byArray2 = this.realloc(byArray2, n2);
                    }
                    n3 = this.flush_compressed(byArray2, n3, n5, by);
                    n5 = 1;
                }
                ++n4;
            }
            if (n5 == 127) {
                if (n3 + 2 > byArray2.length) {
                    byArray2 = this.realloc(byArray2, n2);
                }
                n3 = this.flush_compressed(byArray2, n3, n5, by);
                n5 = 1;
            }
            if (n4 == 127) {
                if (n3 + (n4 + 1) > byArray2.length) {
                    byArray2 = this.realloc(byArray2, n2);
                }
                n3 = this.flush_raw(byArray2, n3, byArray, n6 - n4, n4);
                n4 = 0;
            }
            by = by2;
            ++n6;
        }
        if (n5 > 1) {
            if (n3 + 2 > byArray2.length) {
                byArray2 = this.realloc(byArray2, n2);
            }
            n3 = this.flush_compressed(byArray2, n3, n5, by);
            n5 = 1;
        }
        if (n4 > 0) {
            if (n3 + (n4 + 1) > byArray2.length) {
                byArray2 = this.realloc(byArray2, n2);
            }
            n3 = this.flush_raw(byArray2, n3, byArray, n2 - n4, n4);
            n4 = 0;
        }
        byte[] byArray3 = new byte[n3 + 3];
        System.arraycopy(byArray2, 0, byArray3, 3, n3);
        return byArray3;
    }

    int flush_compressed(byte[] byArray, int n, int n2, byte by) {
        byArray[n++] = (byte)(0x80 | n2);
        byArray[n++] = by;
        return n;
    }

    int flush_raw(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        byArray[n++] = (byte)n3;
        System.arraycopy(byArray2, n2, byArray, n, n3);
        return n + n3;
    }

    byte[] realloc(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length + n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public void close() throws IOException {
        byte[] byArray = new byte[3];
        byArray[0] = 64;
        byte[] byArray2 = byArray;
        this.out.write(byArray2, 0, 3);
        this.out.close();
    }

    CompressedOutputStream(DTP dTP, OutputStream outputStream) {
        super(dTP, outputStream);
    }
}

