/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.GnuPKIExtension;
import gnu.java.security.x509.Util;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class X509CRLEntry
extends java.security.cert.X509CRLEntry
implements GnuPKIExtension {
    private static final boolean DEBUG = false;
    private byte[] encoded;
    private BigInteger serialNo;
    private Date revocationDate;
    private HashMap extensions = new HashMap();

    private static final void debug(String msg) {
    }

    public boolean equals(Object o) {
        if (!(o instanceof X509CRLEntry)) {
            return false;
        }
        boolean bl = false;
        if (((X509CRLEntry)o).getSerialNumber().equals(this.serialNo) && ((X509CRLEntry)o).getRevocationDate().equals(this.revocationDate)) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.serialNo.hashCode();
    }

    public byte[] getEncoded() throws CRLException {
        return (byte[])this.encoded.clone();
    }

    public BigInteger getSerialNumber() {
        return this.serialNo;
    }

    public Date getRevocationDate() {
        return (Date)this.revocationDate.clone();
    }

    public boolean hasExtensions() {
        return this.extensions.isEmpty() ^ true;
    }

    public String toString() {
        return "X509CRLEntry serial=" + this.serialNo + " revocation date=" + this.revocationDate + " ext=" + this.extensions;
    }

    public boolean hasUnsupportedCriticalExtension() {
        Iterator it = this.extensions.values().iterator();
        while (it.hasNext()) {
            Extension e = (Extension)it.next();
            if (!e.isCritical() || e.isSupported()) continue;
            return true;
        }
        return false;
    }

    public Set getCriticalExtensionOIDs() {
        HashSet s = new HashSet();
        Iterator it = this.extensions.values().iterator();
        while (it.hasNext()) {
            Extension e = (Extension)it.next();
            if (!e.isCritical()) continue;
            s.add(e.getOid().toString());
        }
        return Collections.unmodifiableSet(s);
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet s = new HashSet();
        Iterator it = this.extensions.values().iterator();
        while (it.hasNext()) {
            Extension e = (Extension)it.next();
            if (e.isCritical()) continue;
            s.add(e.getOid().toString());
        }
        return Collections.unmodifiableSet(s);
    }

    public byte[] getExtensionValue(String oid) {
        Extension e = this.getExtension(new OID(oid));
        if (e != null) {
            return e.getValue().getEncoded();
        }
        return null;
    }

    public Extension getExtension(OID oid) {
        return (Extension)this.extensions.get(oid);
    }

    public Collection getExtensions() {
        return this.extensions.values();
    }

    private final void parse(int version, DERReader der) throws Exception {
        DERValue entry = der.read();
        X509CRLEntry.debug("start CRL entry   len == " + entry.getLength());
        if (!entry.isConstructed()) {
            throw new IOException("malformed revokedCertificate");
        }
        this.encoded = entry.getEncoded();
        int len = 0;
        X509CRLEntry.debug("encoded entry:\n" + Util.hexDump(this.encoded, ">>>> "));
        DERValue val = der.read();
        this.serialNo = (BigInteger)val.getValue();
        X509CRLEntry.debug("userCertificate == " + this.serialNo + "  current count == " + (len += val.getEncodedLength()));
        val = der.read();
        this.revocationDate = (Date)val.getValue();
        X509CRLEntry.debug("revocationDate == " + this.revocationDate + "  current count == " + (len += val.getEncodedLength()));
        if (len < entry.getLength()) {
            if (version < 2) {
                throw new IOException("extra data in CRL entry");
            }
            DERValue exts = der.read();
            if (!exts.isConstructed()) {
                throw new IOException("malformed Extensions");
            }
            X509CRLEntry.debug("start Extensions  len == " + exts.getLength());
            len = 0;
            while (len < exts.getLength()) {
                val = der.read();
                if (!val.isConstructed()) {
                    throw new IOException("malformed Extension");
                }
                X509CRLEntry.debug("start Extension  len == " + val.getLength());
                Extension e = new Extension(val.getEncoded());
                this.extensions.put(e.getOid(), e);
                der.skip(val.getLength());
                X509CRLEntry.debug("current count == " + (len += val.getEncodedLength()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    X509CRLEntry(int version, DERReader encoded) throws CRLException, IOException {
        try {
            this.parse(version, encoded);
        }
        catch (IOException ioe) {
            void x;
            throw x;
        }
        catch (Exception x) {
            throw new CRLException(x.toString());
        }
    }
}

