/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.GradientPaintContext;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class GradientPaint
implements Paint {
    private final float x1;
    private final float y1;
    private final Color c1;
    private final float x2;
    private final float y2;
    private final Color c2;
    private final boolean cyclic;

    public Point2D getPoint1() {
        return new Point2D.Float(this.x1, this.y1);
    }

    public Color getColor1() {
        return this.c1;
    }

    public Point2D getPoint2() {
        return new Point2D.Float(this.x2, this.y2);
    }

    public Color getColor2() {
        return this.c2;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        Point2D xp1 = xform.transform(this.getPoint1(), null);
        Point2D xp2 = xform.transform(this.getPoint2(), null);
        return new GradientPaintContext((float)xp1.getX(), (float)xp1.getY(), this.c1, (float)xp2.getX(), (float)xp2.getY(), this.c2, this.cyclic);
    }

    public int getTransparency() {
        if (this.c1.getAlpha() == 255 && this.c2.getAlpha() == 255) {
            return 1;
        }
        return 3;
    }

    public GradientPaint(float x1, float y1, Color c1, float x2, float y2, Color c2) {
        this(x1, y1, c1, x2, y2, c2, false);
    }

    public GradientPaint(Point2D p1, Color c1, Point2D p2, Color c2) {
        this((float)p1.getX(), (float)p1.getY(), c1, (float)p2.getX(), (float)p2.getY(), c2, false);
    }

    public GradientPaint(float x1, float y1, Color c1, float x2, float y2, Color c2, boolean cyclic) {
        if (c1 == null || c2 == null) {
            throw new NullPointerException();
        }
        this.x1 = x1;
        this.y1 = y1;
        this.c1 = c1;
        this.x2 = x2;
        this.y2 = y2;
        this.c2 = c2;
        this.cyclic = cyclic;
    }

    public GradientPaint(Point2D p1, Color c1, Point2D p2, Color c2, boolean cyclic) {
        this((float)p1.getX(), (float)p1.getY(), c1, (float)p2.getX(), (float)p2.getY(), c2, cyclic);
    }
}

