/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Polygon
implements Shape,
Serializable {
    private static final long serialVersionUID = -6460061437900069969L;
    private static final double BIG_VALUE = 1.7976931348623158E307;
    public int npoints;
    public int[] xpoints;
    public int[] ypoints;
    protected Rectangle bounds;

    public void reset() {
        this.npoints = 0;
        this.invalidate();
    }

    public void invalidate() {
        this.bounds = null;
    }

    public void translate(int dx, int dy) {
        int i = this.npoints;
        while (--i >= 0) {
            int n = i;
            this.xpoints[n] = this.xpoints[n] + dx;
            int n2 = i;
            this.ypoints[n2] = this.ypoints[n2] + dy;
        }
        if (this.bounds != null) {
            this.bounds.x += dx;
            this.bounds.y += dy;
        }
    }

    public void addPoint(int x, int y) {
        if (this.npoints + 1 > this.xpoints.length) {
            int[] newx = new int[this.npoints + 1];
            System.arraycopy(this.xpoints, 0, newx, 0, this.npoints);
            this.xpoints = newx;
        }
        if (this.npoints + 1 > this.ypoints.length) {
            int[] newy = new int[this.npoints + 1];
            System.arraycopy(this.ypoints, 0, newy, 0, this.npoints);
            this.ypoints = newy;
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        if (this.bounds != null) {
            if (this.npoints == 1) {
                this.bounds.x = x;
                this.bounds.y = y;
            } else {
                if (x < this.bounds.x) {
                    this.bounds.width += this.bounds.x - x;
                    this.bounds.x = x;
                } else if (x > this.bounds.x + this.bounds.width) {
                    this.bounds.width = x - this.bounds.x;
                }
                if (y < this.bounds.y) {
                    this.bounds.height += this.bounds.y - y;
                    this.bounds.y = y;
                } else if (y > this.bounds.y + this.bounds.height) {
                    this.bounds.height = y - this.bounds.y;
                }
            }
        }
    }

    public Rectangle getBounds() {
        return this.getBoundingBox();
    }

    public Rectangle getBoundingBox() {
        if (this.bounds == null) {
            int miny;
            int minx;
            if (this.npoints == 0) {
                this.bounds = new Rectangle();
                return this.bounds;
            }
            int i = this.npoints - 1;
            int maxx = minx = this.xpoints[i];
            int maxy = miny = this.ypoints[i];
            while (--i >= 0) {
                int x = this.xpoints[i];
                int y = this.ypoints[i];
                if (x < minx) {
                    minx = x;
                } else if (x > maxx) {
                    maxx = x;
                }
                if (y < miny) {
                    miny = y;
                    continue;
                }
                if (y <= maxy) continue;
                maxy = y;
            }
            this.bounds = new Rectangle(minx, miny, maxx - minx, maxy - miny);
        }
        return this.bounds;
    }

    public boolean contains(Point p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public boolean inside(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    public boolean contains(double x, double y) {
        boolean bl = false;
        if ((this.evaluateCrossings(x, y, false, 1.7976931348623158E307) & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(double x, double y, double w, double h) {
        if (this.evaluateCrossings(x, y, false, w) != 0 || this.evaluateCrossings(x, y + h, false, w) != 0 || this.evaluateCrossings(x + w, y, true, h) != 0 || this.evaluateCrossings(x, y, true, h) != 0) {
            return true;
        }
        return (this.evaluateCrossings(x, y, false, 1.7976931348623158E307) & 1) != 0;
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double w, double h) {
        if (!this.getBounds2D().intersects(x, y, w, h)) {
            return false;
        }
        if (this.evaluateCrossings(x, y, false, w) != 0 || this.evaluateCrossings(x, y + h, false, w) != 0 || this.evaluateCrossings(x + w, y, true, h) != 0 || this.evaluateCrossings(x, y, true, h) != 0) {
            return false;
        }
        return (this.evaluateCrossings(x, y, false, 1.7976931348623158E307) & 1) != 0;
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public PathIterator getPathIterator(final AffineTransform transform) {
        return new PathIterator(){
            private int vertex;

            public final int getWindingRule() {
                return 0;
            }

            public final boolean isDone() {
                boolean bl = false;
                if (this.vertex > Polygon.this.npoints) {
                    bl = true;
                }
                return bl;
            }

            public final void next() {
                ++this.vertex;
            }

            public final int currentSegment(float[] coords) {
                if (this.vertex >= Polygon.this.npoints) {
                    return 4;
                }
                coords[0] = Polygon.this.xpoints[this.vertex];
                coords[1] = Polygon.this.ypoints[this.vertex];
                if (transform != null) {
                    transform.transform(coords, 0, coords, 0, 1);
                }
                int n = 0;
                if (this.vertex == 0) {
                    n = 1;
                }
                return 1 - n;
            }

            public final int currentSegment(double[] coords) {
                if (this.vertex >= Polygon.this.npoints) {
                    return 4;
                }
                coords[0] = Polygon.this.xpoints[this.vertex];
                coords[1] = Polygon.this.ypoints[this.vertex];
                if (transform != null) {
                    transform.transform(coords, 0, coords, 0, 1);
                }
                int n = 0;
                if (this.vertex == 0) {
                    n = 1;
                }
                return 1 - n;
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform transform, double flatness) {
        return this.getPathIterator(transform);
    }

    private final int evaluateCrossings(double x, double y, boolean useYaxis, double distance) {
        double y1;
        double x1;
        int[] yp;
        int[] xp;
        double epsilon = 0.0;
        int crossings = 0;
        if (useYaxis) {
            xp = this.ypoints;
            yp = this.xpoints;
            double swap = y;
            y = x;
            x = swap;
        } else {
            xp = this.xpoints;
            yp = this.ypoints;
        }
        epsilon = 1.0E-7;
        double x0 = (double)xp[0] - x;
        double y0 = (double)yp[0] - y;
        int i = 1;
        while (i < this.npoints) {
            x1 = (double)xp[i] - x;
            y1 = (double)yp[i] - y;
            if (y0 == 0.0) {
                y0 -= epsilon;
            }
            if (y1 == 0.0) {
                y1 -= epsilon;
            }
            if (y0 * y1 < 0.0 && Line2D.linesIntersect(x0, y0, x1, y1, epsilon, 0.0, distance, 0.0)) {
                ++crossings;
            }
            x0 = (double)xp[i] - x;
            y0 = (double)yp[i] - y;
            ++i;
        }
        x1 = (double)xp[0] - x;
        y1 = (double)yp[0] - y;
        if (y0 == 0.0) {
            y0 -= epsilon;
        }
        if (y1 == 0.0) {
            y1 -= epsilon;
        }
        if (y0 * y1 < 0.0 && Line2D.linesIntersect(x0, y0, x1, y1, epsilon, 0.0, distance, 0.0)) {
            ++crossings;
        }
        return crossings;
    }

    public Polygon() {
        this.xpoints = new int[4];
        this.ypoints = new int[4];
    }

    public Polygon(int[] xpoints, int[] ypoints, int npoints) {
        this.xpoints = new int[npoints];
        this.ypoints = new int[npoints];
        System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
        System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
        this.npoints = npoints;
    }
}

