/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class URI
implements Comparable,
Serializable {
    static final long serialVersionUID = -6052424284110960213L;
    private static final String URI_REGEXP = "^(([^:/?#]+):)?((//([^/?#]*))?([^?#]*)(\\?([^#]*))?)?(#(.*))?";
    private static final String AUTHORITY_REGEXP = "(([^?#]*)@)?([^?#:]*)(:([0-9]*))?";
    private static final String RFC2396_DIGIT = "0123456789";
    private static final String RFC2396_LOWALPHA = "abcdefghijklmnopqrstuvwxyz";
    private static final String RFC2396_UPALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String RFC2396_ALPHA = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String RFC2396_ALPHANUM = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String RFC3986_UNRESERVED = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~";
    private static final String RFC3986_SUBDELIMS = "!$&'()*+,;=";
    private static final String RFC3986_REG_NAME = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=%";
    private static final String RFC3986_PCHAR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=:@%";
    private static final String RFC3986_SEGMENT = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=:@%";
    private static final String RFC3986_PATH_SEGMENTS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=:@%/";
    private static final String RFC3986_SSP = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=:@%?/";
    private static final String RFC3986_HOST = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=%[]";
    private static final String RFC3986_USERINFO = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=%:";
    private static final int SCHEME_GROUP = 2;
    private static final int SCHEME_SPEC_PART_GROUP = 3;
    private static final int AUTHORITY_GROUP = 5;
    private static final int PATH_GROUP = 6;
    private static final int QUERY_GROUP = 8;
    private static final int FRAGMENT_GROUP = 10;
    private static final int AUTHORITY_USERINFO_GROUP = 2;
    private static final int AUTHORITY_HOST_GROUP = 3;
    private static final int AUTHORITY_PORT_GROUP = 5;
    private static final Pattern URI_PATTERN = Pattern.compile("^(([^:/?#]+):)?((//([^/?#]*))?([^?#]*)(\\?([^#]*))?)?(#(.*))?");
    private static final Pattern AUTHORITY_PATTERN = Pattern.compile("(([^?#]*)@)?([^?#:]*)(:([0-9]*))?");
    private static final String HEX = "0123456789ABCDEF";
    private transient String scheme;
    private transient String rawSchemeSpecificPart;
    private transient String schemeSpecificPart;
    private transient String rawAuthority;
    private transient String authority;
    private transient String rawUserInfo;
    private transient String userInfo;
    private transient String rawHost;
    private transient String host;
    private transient int port;
    private transient String rawPath;
    private transient String path;
    private transient String rawQuery;
    private transient String query;
    private transient String rawFragment;
    private transient String fragment;
    private String string;

    private final void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        this.string = (String)is.readObject();
        try {
            this.parseURI(this.string);
        }
        catch (URISyntaxException x) {
            throw new RuntimeException(x);
        }
    }

    private final void writeObject(ObjectOutputStream os) throws IOException {
        if (this.string == null) {
            this.string = this.toString();
        }
        os.writeObject(this.string);
    }

    private static final String getURIGroup(Matcher match, int group) {
        String matched = match.group(group);
        return matched.length() == 0 ? (match.group(group - 1).length() == 0 ? null : "") : matched;
    }

    private final void parseURI(String str) throws URISyntaxException {
        Matcher matcher = URI_PATTERN.matcher(str);
        if (matcher.matches()) {
            this.scheme = URI.getURIGroup(matcher, 2);
            this.rawSchemeSpecificPart = matcher.group(3);
            this.schemeSpecificPart = URI.unquote(this.rawSchemeSpecificPart);
            if (!this.isOpaque()) {
                this.rawAuthority = URI.getURIGroup(matcher, 5);
                this.rawPath = matcher.group(6);
                this.rawQuery = URI.getURIGroup(matcher, 8);
            }
        } else {
            throw new URISyntaxException(str, "doesn't match URI regular expression");
        }
        this.rawFragment = URI.getURIGroup(matcher, 10);
        this.parseServerAuthority();
        this.authority = URI.unquote(this.rawAuthority);
        this.userInfo = URI.unquote(this.rawUserInfo);
        this.host = URI.unquote(this.rawHost);
        this.path = URI.unquote(this.rawPath);
        this.query = URI.unquote(this.rawQuery);
        this.fragment = URI.unquote(this.rawFragment);
    }

    private static final String unquote(String str) throws URISyntaxException {
        if (str == null) {
            return null;
        }
        byte[] buf = new byte[str.length()];
        int pos = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '%') {
                int lo;
                if (i + 2 >= str.length()) {
                    throw new URISyntaxException(str, "Invalid quoted character");
                }
                int hi = Character.digit(str.charAt(++i), 16);
                if ((lo = Character.digit(str.charAt(++i), 16)) < 0 || hi < 0) {
                    throw new URISyntaxException(str, "Invalid quoted character");
                }
                buf[pos++] = (byte)(hi * 16 + lo);
            } else {
                buf[pos++] = (byte)c;
            }
            ++i;
        }
        try {
            return new String(buf, 0, pos, "utf-8");
        }
        catch (UnsupportedEncodingException x2) {
            throw (Error)new InternalError().initCause(x2);
        }
    }

    private static final String quote(String str) {
        return URI.quote(str, RFC3986_SSP);
    }

    private static final String quoteAuthority(String str) {
        return URI.quote(str, RFC3986_REG_NAME);
    }

    private static final String quote(String str, String legalCharacters) {
        StringBuffer sb = new StringBuffer(str.length());
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (legalCharacters.indexOf(c) == -1) {
                if (c <= '\u007f') {
                    sb.append('%');
                    sb.append(HEX.charAt(c / 16));
                    sb.append(HEX.charAt(c % 16));
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private static final String quoteHost(String str) {
        return URI.quote(str, RFC3986_HOST);
    }

    private static final String quotePath(String str) {
        return URI.quote(str, RFC3986_PATH_SEGMENTS);
    }

    private static final String quoteUserInfo(String str) {
        return URI.quote(str, RFC3986_USERINFO);
    }

    public static final URI create(String str) {
        try {
            return new URI(str);
        }
        catch (URISyntaxException e) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
        }
    }

    public final URI parseServerAuthority() throws URISyntaxException {
        if (this.rawAuthority != null) {
            Matcher matcher = AUTHORITY_PATTERN.matcher(this.rawAuthority);
            if (matcher.matches()) {
                this.rawUserInfo = URI.getURIGroup(matcher, 2);
                this.rawHost = URI.getURIGroup(matcher, 3);
                String portStr = URI.getURIGroup(matcher, 5);
                if (portStr != null) {
                    try {
                        this.port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        URISyntaxException use = new URISyntaxException(this.string, "doesn't match URI regular expression");
                        use.initCause(e);
                        throw use;
                    }
                }
            } else {
                throw new URISyntaxException(this.string, "doesn't match URI regular expression");
            }
        }
        return this;
    }

    public final URI normalize() {
        if (this.isOpaque() || this.path.indexOf("/./") == -1 && this.path.indexOf("/../") == -1) {
            return this;
        }
        try {
            return new URI(this.scheme, this.authority, this.normalizePath(this.path), this.query, this.fragment);
        }
        catch (URISyntaxException e) {
            throw (Error)new InternalError("Normalized URI variant could not be constructed").initCause(e);
        }
    }

    private final String normalizePath(String relativePath) {
        StringBuffer input = new StringBuffer(relativePath);
        StringBuffer output = new StringBuffer();
        int start = 0;
        while (start < input.length()) {
            if (input.indexOf("../", start) == start) {
                start += 3;
                continue;
            }
            if (input.indexOf("./", start) == start) {
                start += 2;
                continue;
            }
            if (input.indexOf("/./", start) == start) {
                start += 2;
                continue;
            }
            if (input.indexOf("/.", start) == start && input.charAt(start + 2) != '.') {
                input.setCharAt(++start, '/');
                continue;
            }
            if (input.indexOf("/../", start) == start) {
                start += 3;
                this.removeLastSegment(output);
                continue;
            }
            if (input.indexOf("/..", start) == start) {
                input.setCharAt(start += 2, '/');
                this.removeLastSegment(output);
                continue;
            }
            if (start == input.length() - 1 && input.indexOf(".", start) == start) {
                input.delete(0, 1);
                continue;
            }
            if (start == input.length() - 2 && input.indexOf("..", start) == start) {
                input.delete(0, 2);
                continue;
            }
            int indexOfSlash = input.indexOf("/", start);
            while (indexOfSlash == start) {
                output.append("/");
                indexOfSlash = input.indexOf("/", ++start);
            }
            if (indexOfSlash == -1) {
                indexOfSlash = input.length();
            }
            output.append(input.substring(start, indexOfSlash));
            start = indexOfSlash;
        }
        return output.toString();
    }

    private final void removeLastSegment(StringBuffer buffer) {
        int lastSlash = buffer.lastIndexOf("/");
        if (lastSlash == -1) {
            buffer.setLength(0);
        } else {
            buffer.setLength(lastSlash);
        }
    }

    public final URI resolve(URI uri) {
        if (uri.isAbsolute()) {
            return uri;
        }
        if (uri.isOpaque()) {
            return uri;
        }
        String scheme = uri.getScheme();
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        String authority = uri.getAuthority();
        String path = uri.getPath();
        String query = uri.getQuery();
        String fragment = uri.getFragment();
        try {
            if (fragment != null && path != null && path.equals("") && scheme == null && authority == null && query == null) {
                return new URI(this.scheme, this.schemeSpecificPart, fragment);
            }
            if (authority == null) {
                authority = this.authority;
                if (path == null) {
                    path = "";
                }
                if (!path.startsWith("/")) {
                    StringBuffer basepath = new StringBuffer(this.path);
                    int i = this.path.lastIndexOf(47);
                    if (i >= 0) {
                        basepath.delete(i + 1, basepath.length());
                    }
                    basepath.append(path);
                    path = this.normalizePath(basepath.toString());
                }
            }
            return new URI(this.scheme, authority, path, query, fragment);
        }
        catch (URISyntaxException e) {
            throw (Error)new InternalError("Resolved URI variant could not be constructed").initCause(e);
        }
    }

    public final URI resolve(String str) throws IllegalArgumentException {
        return this.resolve(URI.create(str));
    }

    public final URI relativize(URI uri) {
        if (this.isOpaque() || uri.isOpaque()) {
            return uri;
        }
        if (this.scheme == null && uri.getScheme() != null) {
            return uri;
        }
        if (this.scheme != null && !this.scheme.equals(uri.getScheme())) {
            return uri;
        }
        if (this.rawAuthority == null && uri.getRawAuthority() != null) {
            return uri;
        }
        if (this.rawAuthority != null && !this.rawAuthority.equals(uri.getRawAuthority())) {
            return uri;
        }
        if (!uri.getRawPath().startsWith(this.rawPath)) {
            return uri;
        }
        try {
            return new URI(null, null, uri.getRawPath().substring(this.rawPath.length()), uri.getRawQuery(), uri.getRawFragment());
        }
        catch (URISyntaxException e) {
            throw (Error)new InternalError("Relativized URI variant could not be constructed").initCause(e);
        }
    }

    public final URL toURL() throws IllegalArgumentException, MalformedURLException {
        if (this.isAbsolute()) {
            return new URL(this.toString());
        }
        throw new IllegalArgumentException("not absolute");
    }

    public final String getScheme() {
        return this.scheme;
    }

    public final boolean isAbsolute() {
        boolean bl = false;
        if (this.scheme != null) {
            bl = true;
        }
        return bl;
    }

    public final boolean isOpaque() {
        boolean bl = false;
        if (this.scheme != null && !this.schemeSpecificPart.startsWith("/")) {
            bl = true;
        }
        return bl;
    }

    public final String getRawSchemeSpecificPart() {
        return this.rawSchemeSpecificPart;
    }

    public final String getSchemeSpecificPart() {
        return this.schemeSpecificPart;
    }

    public final String getRawAuthority() {
        return this.rawAuthority;
    }

    public final String getAuthority() {
        return this.authority;
    }

    public final String getRawUserInfo() {
        return this.rawUserInfo;
    }

    public final String getUserInfo() {
        return this.userInfo;
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public final String getRawPath() {
        return this.rawPath;
    }

    public final String getPath() {
        return this.path;
    }

    public final String getRawQuery() {
        return this.rawQuery;
    }

    public final String getQuery() {
        return this.query;
    }

    public final String getRawFragment() {
        return this.rawFragment;
    }

    public final String getFragment() {
        return this.fragment;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof URI)) {
            return false;
        }
        URI uriObj = (URI)obj;
        if (this.scheme == null ? uriObj.getScheme() != null : !this.scheme.equalsIgnoreCase(uriObj.getScheme())) {
            return false;
        }
        if (this.rawFragment == null ? uriObj.getRawFragment() != null : !this.rawFragment.equalsIgnoreCase(uriObj.getRawFragment())) {
            return false;
        }
        boolean opaqueThis = this.isOpaque();
        boolean opaqueObj = uriObj.isOpaque();
        if (opaqueThis && opaqueObj) {
            return this.rawSchemeSpecificPart.equals(uriObj.getRawSchemeSpecificPart());
        }
        if (!opaqueThis && !opaqueObj) {
            boolean common;
            boolean bl = false;
            if (this.rawPath.equalsIgnoreCase(uriObj.getRawPath()) && (this.rawQuery == null && uriObj.getRawQuery() == null || this.rawQuery.equalsIgnoreCase(uriObj.getRawQuery()))) {
                bl = common = true;
            }
            if (this.rawAuthority == null && uriObj.getRawAuthority() == null) {
                return common;
            }
            if (this.host == null) {
                boolean bl2 = false;
                if (common && this.rawAuthority.equalsIgnoreCase(uriObj.getRawAuthority())) {
                    bl2 = true;
                }
                return bl2;
            }
            boolean bl3 = false;
            if (common && this.host.equalsIgnoreCase(uriObj.getHost()) && this.port == uriObj.getPort() && (this.rawUserInfo == null ? uriObj.getRawUserInfo() == null : this.rawUserInfo.equalsIgnoreCase(uriObj.getRawUserInfo()))) {
                bl3 = true;
            }
            return bl3;
        }
        return false;
    }

    public final int hashCode() {
        int n = 0;
        if (this.getScheme() != null) {
            n = 13 * this.getScheme().hashCode();
        }
        int n2 = n + 17 * this.getRawSchemeSpecificPart().hashCode();
        int n3 = 0;
        if (this.getRawFragment() != null) {
            n3 = 21 + this.getRawFragment().hashCode();
        }
        return n2 + n3;
    }

    public final int compareTo(Object obj) throws ClassCastException {
        int qCompare;
        int pCompare;
        int aCompare;
        int n;
        URI uri = (URI)obj;
        if (this.scheme == null && uri.getScheme() != null) {
            return -1;
        }
        if (this.scheme != null && (n = this.scheme.compareToIgnoreCase(uri.getScheme())) != 0) {
            return n;
        }
        boolean bl = this.isOpaque();
        boolean opaqueObj = uri.isOpaque();
        if (bl && !opaqueObj) {
            return 1;
        }
        if (!bl && opaqueObj) {
            return -1;
        }
        if (bl) {
            int ssCompare = this.rawSchemeSpecificPart.compareTo(uri.getRawSchemeSpecificPart());
            if (ssCompare == 0) {
                return this.compareFragments(uri);
            }
            return ssCompare;
        }
        if (this.rawAuthority == null && uri.getRawAuthority() != null) {
            return -1;
        }
        if (this.rawAuthority != null && (aCompare = this.rawAuthority.compareTo(uri.getRawAuthority())) != 0) {
            if (this.host == null) {
                return aCompare;
            }
            if (this.rawUserInfo == null && uri.getRawUserInfo() != null) {
                return -1;
            }
            int uCompare = this.rawUserInfo.compareTo(uri.getRawUserInfo());
            if (uCompare != 0) {
                return uCompare;
            }
            if (this.host == null && uri.getHost() != null) {
                return -1;
            }
            int hCompare = this.host.compareTo(uri.getHost());
            if (hCompare != 0) {
                return hCompare;
            }
            return new Integer(this.port).compareTo(new Integer(uri.getPort()));
        }
        if (this.rawPath == null && uri.getRawPath() != null) {
            return -1;
        }
        if (this.rawPath != null && (pCompare = this.rawPath.compareTo(uri.getRawPath())) != 0) {
            return pCompare;
        }
        if (this.rawQuery == null && uri.getRawQuery() != null) {
            return -1;
        }
        if (this.rawQuery != null && (qCompare = this.rawQuery.compareTo(uri.getRawQuery())) != 0) {
            return qCompare;
        }
        return this.compareFragments(uri);
    }

    private final int compareFragments(URI uri) {
        if (this.rawFragment == null && uri.getRawFragment() != null) {
            return -1;
        }
        if (this.rawFragment == null) {
            return 0;
        }
        return this.rawFragment.compareTo(uri.getRawFragment());
    }

    public final String toString() {
        return (this.scheme == null ? "" : this.scheme + ':') + this.rawSchemeSpecificPart + (this.rawFragment == null ? "" : "#" + this.rawFragment);
    }

    public final String toASCIIString() {
        String strRep = this.toString();
        boolean inNonAsciiBlock = false;
        StringBuffer buffer = new StringBuffer();
        StringBuffer encBuffer = null;
        int i = 0;
        while (i < strRep.length()) {
            char c = strRep.charAt(i);
            if (c <= '\u007f') {
                if (inNonAsciiBlock) {
                    buffer.append(URI.escapeCharacters(encBuffer.toString()));
                    inNonAsciiBlock = false;
                }
                buffer.append(c);
            } else {
                if (!inNonAsciiBlock) {
                    encBuffer = new StringBuffer();
                    inNonAsciiBlock = true;
                }
                encBuffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    private static final String escapeCharacters(String str) {
        try {
            StringBuffer sb = new StringBuffer();
            byte[] utf8 = str.getBytes("utf-8");
            int j = 0;
            while (j < utf8.length) {
                sb.append('%');
                sb.append(HEX.charAt((utf8[j] & 0xFF) / 16));
                sb.append(HEX.charAt((utf8[j] & 0xFF) % 16));
                ++j;
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException x) {
            throw (Error)new InternalError("Escaping error").initCause(x);
        }
    }

    private final /* synthetic */ void this() {
        this.port = -1;
    }

    public URI(String str) throws URISyntaxException {
        this.this();
        this.string = str;
        this.parseURI(str);
    }

    public URI(String scheme, String userInfo, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        this((scheme == null ? "" : scheme + ':') + (userInfo == null && host == null && port == -1 ? "" : "//") + (userInfo == null ? "" : URI.quoteUserInfo(userInfo) + '@') + (host == null ? "" : URI.quoteHost(host)) + (port == -1 ? "" : ":" + String.valueOf(port)) + (path == null ? "" : URI.quotePath(path)) + (query == null ? "" : "?" + URI.quote(query)) + (fragment == null ? "" : "#" + URI.quote(fragment)));
    }

    public URI(String scheme, String authority, String path, String query, String fragment) throws URISyntaxException {
        this((scheme == null ? "" : scheme + ':') + (authority == null ? "" : "//" + URI.quoteAuthority(authority)) + (path == null ? "" : URI.quotePath(path)) + (query == null ? "" : "?" + URI.quote(query)) + (fragment == null ? "" : "#" + URI.quote(fragment)));
    }

    public URI(String scheme, String host, String path, String fragment) throws URISyntaxException {
        this(scheme, null, host, -1, path, null, fragment);
    }

    public URI(String scheme, String ssp, String fragment) throws URISyntaxException {
        this((scheme == null ? "" : scheme + ':') + (ssp == null ? "" : URI.quote(ssp)) + (fragment == null ? "" : "#" + URI.quote(fragment)));
    }
}

