/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.java.net.URLParseError;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class URL
implements Serializable {
    private static final String DEFAULT_SEARCH_PATH = "gnu.java.net.protocol|gnu.inet";
    private static ClassLoader systemClassLoader;
    private static URLStreamHandlerFactory factory;
    private static final long serialVersionUID = -7627629688361524110L;
    private static HashMap ph_cache;
    private static boolean cache_handlers;
    private String protocol;
    private String authority;
    private String host;
    private String userInfo;
    private int port;
    private String file;
    private String ref;
    private int hashCode;
    transient URLStreamHandler ph;

    public final boolean equals(Object obj) {
        if (!(obj instanceof URL)) {
            return false;
        }
        return this.ph.equals(this, (URL)obj);
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public final Object getContent(Class[] classes) throws IOException {
        return this.getContent();
    }

    public final String getFile() {
        return this.file == null ? "" : this.file;
    }

    public final String getPath() {
        if (this.file == null) {
            return null;
        }
        int quest = this.file.indexOf(63);
        return quest < 0 ? this.getFile() : this.file.substring(0, quest);
    }

    public final String getAuthority() {
        return this.authority;
    }

    public final String getHost() {
        int at = this.host == null ? -1 : this.host.indexOf(64);
        return at < 0 ? this.host : this.host.substring(at + 1, this.host.length());
    }

    public final int getPort() {
        return this.port;
    }

    public final int getDefaultPort() {
        return this.ph.getDefaultPort();
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final String getRef() {
        return this.ref;
    }

    public final String getUserInfo() {
        if (this.userInfo != null) {
            return this.userInfo;
        }
        int at = this.host == null ? -1 : this.host.indexOf(64);
        return at < 0 ? null : this.host.substring(0, at);
    }

    public final String getQuery() {
        int quest = this.file == null ? -1 : this.file.indexOf(63);
        return quest < 0 ? null : this.file.substring(quest + 1, this.file.length());
    }

    public final int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        return this.ph.hashCode(this);
    }

    public final URLConnection openConnection() throws IOException {
        return this.ph.openConnection(this);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public final boolean sameFile(URL url) {
        return this.ph.sameFile(this, url);
    }

    protected final void set(String protocol, String host, int port, String file, String ref) {
        URLStreamHandler protocolHandler = null;
        if (!this.protocol.equals(protocol = protocol.toLowerCase())) {
            protocolHandler = URL.getURLStreamHandler(protocol);
        }
        if (protocolHandler != null) {
            this.ph = protocolHandler;
            this.protocol = protocol;
        }
        this.authority = "";
        this.port = port;
        this.host = host;
        this.file = file;
        this.ref = ref;
        if (host != null) {
            this.authority = this.authority + host;
        }
        if (port >= 0) {
            this.authority = this.authority + ':' + port;
        }
        this.hashCode = this.hashCode();
    }

    protected final void set(String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        URLStreamHandler protocolHandler = null;
        if (!this.protocol.equals(protocol = protocol.toLowerCase())) {
            protocolHandler = URL.getURLStreamHandler(protocol);
        }
        if (protocolHandler != null) {
            this.ph = protocolHandler;
            this.protocol = protocol;
        }
        this.host = host;
        this.userInfo = userInfo;
        this.port = port;
        this.authority = authority;
        this.file = query == null ? path : path + '?' + query;
        this.ref = ref;
        this.hashCode = this.hashCode();
    }

    public static final synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory fac) {
        if (factory != null) {
            throw new Error("URLStreamHandlerFactory already set");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkSetFactory();
        }
        factory = fac;
    }

    public final String toExternalForm() {
        return this.ph.toExternalForm(this);
    }

    public final String toString() {
        return this.ph.toExternalForm(this);
    }

    private static final synchronized URLStreamHandler getURLStreamHandler(String protocol) {
        URLStreamHandler ph = null;
        if (cache_handlers && (ph = (URLStreamHandler)ph_cache.get(protocol)) != null) {
            return ph;
        }
        if (factory != null) {
            ph = factory.createURLStreamHandler(protocol);
        }
        if (ph == null) {
            String ph_search_path = System.getProperty("java.protocol.handler.pkgs");
            ph_search_path = ph_search_path != null ? ph_search_path + "|gnu.java.net.protocol|gnu.inet" : DEFAULT_SEARCH_PATH;
            StringTokenizer pkgPrefix = new StringTokenizer(ph_search_path, "|");
            if (systemClassLoader == null) {
                systemClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public final Object run() {
                        return ClassLoader.getSystemClassLoader();
                    }
                });
            }
            do {
                try {
                    String clsName = pkgPrefix.nextToken() + '.' + protocol + ".Handler";
                    Class c = Class.forName(clsName, true, systemClassLoader);
                    ph = (URLStreamHandler)c.newInstance();
                }
                catch (ThreadDeath death) {
                    throw death;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            } while (ph == null && pkgPrefix.hasMoreTokens());
        }
        if (ph != null && cache_handlers) {
            ph_cache.put(protocol, ph);
        } else {
            ph = null;
        }
        return ph;
    }

    private final void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.ph = URL.getURLStreamHandler(this.protocol);
        if (this.ph == null) {
            throw new IOException("Handler for protocol " + this.protocol + " not found");
        }
    }

    private final void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    public final URI toURI() throws URISyntaxException {
        return new URI(this.toString());
    }

    private final /* synthetic */ void this() {
        this.port = -1;
    }

    public URL(String protocol, String host, int port, String file) throws MalformedURLException {
        this(protocol, host, port, file, null);
    }

    public URL(String protocol, String host, String file) throws MalformedURLException {
        this(protocol, host, -1, file, null);
    }

    public URL(String protocol, String host, int port, String file, URLStreamHandler ph) throws MalformedURLException {
        int hashAt;
        this.this();
        if (protocol == null) {
            throw new MalformedURLException("null protocol");
        }
        this.protocol = protocol = protocol.toLowerCase();
        if (ph != null) {
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                s.checkPermission(new NetPermission("specifyStreamHandler"));
            }
            this.ph = ph;
        } else {
            this.ph = URL.getURLStreamHandler(protocol);
        }
        if (this.ph == null) {
            throw new MalformedURLException("Protocol handler not found: " + protocol);
        }
        this.host = host;
        this.port = port;
        String string = this.authority = host != null ? host : "";
        if (port >= 0 && host != null) {
            this.authority = this.authority + ':' + port;
        }
        if ((hashAt = file.indexOf(35)) < 0) {
            this.file = file;
            this.ref = null;
        } else {
            this.file = file.substring(0, hashAt);
            this.ref = file.substring(hashAt + 1);
        }
        this.hashCode = this.hashCode();
    }

    public URL(String spec) throws MalformedURLException {
        this((URL)null, spec != null ? spec : "", (URLStreamHandler)null);
    }

    public URL(URL context, String spec) throws MalformedURLException {
        this(context, spec, null);
    }

    public URL(URL context, String spec, URLStreamHandler ph) throws MalformedURLException {
        this.this();
        int slash = spec.indexOf(47);
        int colon = spec.indexOf("://", 1);
        if (!(colon <= 0 || colon >= slash && slash >= 0 || spec.regionMatches(colon, "://:", 0, 4))) {
            context = null;
        }
        if ((colon = spec.indexOf(58)) > 0 && (colon < slash || slash < 0)) {
            this.protocol = spec.substring(0, colon).toLowerCase();
            if (context != null && context.protocol.equals(this.protocol)) {
                this.host = context.host;
                this.port = context.port;
                this.file = context.file;
                this.userInfo = context.userInfo;
                if (this.file == null || this.file.length() == 0) {
                    this.file = "/";
                }
                this.authority = context.authority;
            }
        } else if (context != null) {
            colon = -1;
            this.protocol = context.protocol;
            this.host = context.host;
            this.port = context.port;
            this.file = context.file;
            this.userInfo = context.userInfo;
            if (this.file == null || this.file.length() == 0) {
                this.file = "/";
            }
            this.authority = context.authority;
        } else {
            throw new MalformedURLException("Absolute URL required with null context: " + spec);
        }
        this.protocol = this.protocol.trim();
        if (ph != null) {
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                s.checkPermission(new NetPermission("specifyStreamHandler"));
            }
            this.ph = ph;
        } else {
            this.ph = URL.getURLStreamHandler(this.protocol);
        }
        if (this.ph == null) {
            throw new MalformedURLException("Protocol handler not found: " + this.protocol);
        }
        int hashAt = spec.indexOf(35, colon + 1);
        try {
            this.ph.parseURL(this, spec, colon + 1, hashAt < 0 ? spec.length() : hashAt);
        }
        catch (URLParseError e) {
            throw new MalformedURLException(e.getMessage());
        }
        if (hashAt >= 0) {
            this.ref = spec.substring(hashAt + 1);
        }
        this.hashCode = this.hashCode();
    }

    static {
        ph_cache = new HashMap();
        String s = System.getProperty("gnu.java.net.nocache_protocol_handlers");
        cache_handlers = s == null;
    }
}

