/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class MetalRadioButtonUI
extends BasicRadioButtonUI {
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;

    public static ComponentUI createUI(JComponent component) {
        return new MetalRadioButtonUI();
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.disabledTextColor = defaults.getColor("RadioButton.disabledText");
        this.focusColor = defaults.getColor("RadioButton.focus");
        this.selectColor = defaults.getColor("RadioButton.select");
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.disabledTextColor = null;
        this.focusColor = null;
        this.selectColor = null;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    protected void paintFocus(Graphics g, Rectangle t, Dimension d) {
        g.setColor(this.focusColor);
        g.drawRect(t.x, t.y, t.width - 2, t.height - 2);
    }
}

