/* $MirOS: src/include/tiger.h,v 1.2 2013/10/31 20:06:09 tg Exp $ */

#ifndef _TIGER_H
#define _TIGER_H

#define TIGER_BLOCK_LENGTH		64
#define TIGER_DIGEST_LENGTH		24
#define TIGER_DIGEST_STRING_LENGTH	(TIGER_DIGEST_LENGTH * 2 + 1)

typedef struct {
	uint64_t digest[3];
	uint64_t count;
	uint8_t buffer[TIGER_BLOCK_LENGTH];
} TIGER_CTX;

#include <sys/cdefs.h>

__BEGIN_DECLS
void TIGERInit(TIGER_CTX *);
void TIGERPad(TIGER_CTX *);
void TIGERTransform(uint64_t *, const uint8_t *)
	
	;
void TIGERUpdate(TIGER_CTX *, const uint8_t *, size_t)
	;
void TIGERFinal(uint8_t *, TIGER_CTX *)
	;
char *TIGEREnd(TIGER_CTX *, char *)
	;
char *TIGERFile(const char *, char *)
	;
char *TIGERFileChunk(const char *, char *, off_t, off_t)
	;
char *TIGERData(const uint8_t *, size_t, char *)
	
	;
__END_DECLS

#endif
