/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class ExecuteOn
extends ExecTask {
    protected Vector filesets = new Vector();
    private boolean relative = false;
    private boolean parallel = false;
    protected String type = "file";
    protected Commandline.Marker srcFilePos = null;
    private boolean skipEmpty = false;
    protected Commandline.Marker targetFilePos = null;
    protected Mapper mapperElement = null;
    protected FileNameMapper mapper = null;
    protected File destDir = null;
    protected boolean srcIsFirst = true;

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setType(FileDirBoth type) {
        this.type = type.getValue();
    }

    public void setSkipEmptyFilesets(boolean skip) {
        this.skipEmpty = skip;
    }

    public void setDest(File destDir) {
        this.destDir = destDir;
    }

    public Commandline.Marker createSrcfile() {
        if (this.srcFilePos != null) {
            throw new BuildException(this.taskType + " doesn't support multiple " + "srcfile elements.", this.location);
        }
        this.srcFilePos = this.cmdl.createMarker();
        return this.srcFilePos;
    }

    public Commandline.Marker createTargetfile() {
        if (this.targetFilePos != null) {
            throw new BuildException(this.taskType + " doesn't support multiple " + "targetfile elements.", this.location);
        }
        this.targetFilePos = this.cmdl.createMarker();
        this.srcIsFirst = this.srcFilePos != null;
        return this.targetFilePos;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.location);
        }
        this.mapperElement = new Mapper(this.project);
        return this.mapperElement;
    }

    protected void checkConfiguration() {
        if ("execon".equals(this.taskName)) {
            this.log("!! execon is deprecated. Use apply instead. !!");
        }
        super.checkConfiguration();
        if (this.filesets.size() == 0) {
            throw new BuildException("no filesets specified", this.location);
        }
        if (this.targetFilePos != null || this.mapperElement != null || this.destDir != null) {
            if (this.mapperElement == null) {
                throw new BuildException("no mapper specified", this.location);
            }
            if (this.destDir == null) {
                throw new BuildException("no dest attribute specified", this.location);
            }
            this.mapper = this.mapperElement.getImplementation();
        }
    }

    protected void runExec(Execute exe) throws BuildException {
        try {
            Vector<Object> fileNames = new Vector<Object>();
            Vector<File> baseDirs = new Vector<File>();
            for (int i = 0; i < this.filesets.size(); ++i) {
                int j;
                Object[] s;
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                File base = fs.getDir(this.project);
                DirectoryScanner ds = fs.getDirectoryScanner(this.project);
                if (!"dir".equals(this.type)) {
                    s = this.getFiles(base, ds);
                    for (j = 0; j < s.length; ++j) {
                        fileNames.addElement(s[j]);
                        baseDirs.addElement(base);
                    }
                }
                if (!"file".equals(this.type)) {
                    s = this.getDirs(base, ds);
                    for (j = 0; j < s.length; ++j) {
                        fileNames.addElement(s[j]);
                        baseDirs.addElement(base);
                    }
                }
                if (fileNames.size() == 0 && this.skipEmpty) {
                    this.log("Skipping fileset for directory " + base + ". It is empty.", 2);
                    continue;
                }
                if (this.parallel) continue;
                s = new String[fileNames.size()];
                fileNames.copyInto(s);
                for (j = 0; j < s.length; ++j) {
                    String[] command = this.getCommandline((String)s[j], base);
                    this.log(Commandline.describeCommand(command), 3);
                    exe.setCommandline(command);
                    this.runExecute(exe);
                }
                fileNames.removeAllElements();
                baseDirs.removeAllElements();
            }
            if (this.parallel && (fileNames.size() > 0 || !this.skipEmpty)) {
                Object[] s = new String[fileNames.size()];
                fileNames.copyInto(s);
                Object[] b = new File[baseDirs.size()];
                baseDirs.copyInto(b);
                String[] command = this.getCommandline((String[])s, (File[])b);
                this.log(Commandline.describeCommand(command), 3);
                exe.setCommandline(command);
                this.runExecute(exe);
            }
        }
        catch (IOException e) {
            throw new BuildException("Execute failed: " + e, e, this.location);
        }
        finally {
            this.logFlush();
        }
    }

    protected String[] getCommandline(String[] srcFiles, File[] baseDirs) {
        Vector<String> targets = new Vector<String>();
        if (this.targetFilePos != null) {
            Hashtable<String, String> addedFiles = new Hashtable<String, String>();
            for (int i = 0; i < srcFiles.length; ++i) {
                String[] subTargets = this.mapper.mapFileName(srcFiles[i]);
                if (subTargets == null) continue;
                for (int j = 0; j < subTargets.length; ++j) {
                    String name = null;
                    name = !this.relative ? new File(this.destDir, subTargets[j]).getAbsolutePath() : subTargets[j];
                    if (addedFiles.contains(name)) continue;
                    targets.addElement(name);
                    addedFiles.put(name, name);
                }
            }
        }
        Object[] targetFiles = new String[targets.size()];
        targets.copyInto(targetFiles);
        String[] orig = this.cmdl.getCommandline();
        String[] result = new String[orig.length + srcFiles.length + targetFiles.length];
        int srcIndex = orig.length;
        if (this.srcFilePos != null) {
            srcIndex = this.srcFilePos.getPosition();
        }
        if (this.targetFilePos != null) {
            int targetIndex = this.targetFilePos.getPosition();
            if (srcIndex < targetIndex || srcIndex == targetIndex && this.srcIsFirst) {
                System.arraycopy(orig, 0, result, 0, srcIndex);
                System.arraycopy(orig, srcIndex, result, srcIndex + srcFiles.length, targetIndex - srcIndex);
                System.arraycopy(targetFiles, 0, result, targetIndex + srcFiles.length, targetFiles.length);
                System.arraycopy(orig, targetIndex, result, targetIndex + srcFiles.length + targetFiles.length, orig.length - targetIndex);
            } else {
                System.arraycopy(orig, 0, result, 0, targetIndex);
                System.arraycopy(targetFiles, 0, result, targetIndex, targetFiles.length);
                System.arraycopy(orig, targetIndex, result, targetIndex + targetFiles.length, srcIndex - targetIndex);
                System.arraycopy(orig, srcIndex, result, srcIndex + srcFiles.length + targetFiles.length, orig.length - srcIndex);
                srcIndex += targetFiles.length;
            }
        } else {
            System.arraycopy(orig, 0, result, 0, srcIndex);
            System.arraycopy(orig, srcIndex, result, srcIndex + srcFiles.length, orig.length - srcIndex);
        }
        for (int i = 0; i < srcFiles.length; ++i) {
            result[srcIndex + i] = !this.relative ? new File(baseDirs[i], srcFiles[i]).getAbsolutePath() : srcFiles[i];
        }
        return result;
    }

    protected String[] getCommandline(String srcFile, File baseDir) {
        return this.getCommandline(new String[]{srcFile}, new File[]{baseDir});
    }

    protected String[] getFiles(File baseDir, DirectoryScanner ds) {
        if (this.mapper != null) {
            SourceFileScanner sfs = new SourceFileScanner(this);
            return sfs.restrict(ds.getIncludedFiles(), baseDir, this.destDir, this.mapper);
        }
        return ds.getIncludedFiles();
    }

    protected String[] getDirs(File baseDir, DirectoryScanner ds) {
        if (this.mapper != null) {
            SourceFileScanner sfs = new SourceFileScanner(this);
            return sfs.restrict(ds.getIncludedDirectories(), baseDir, this.destDir, this.mapper);
        }
        return ds.getIncludedDirectories();
    }

    public static class FileDirBoth
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"file", "dir", "both"};
        }
    }
}

