/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.touch.client;

import com.google.gwt.touch.client.Momentum;
import com.google.gwt.touch.client.Point;

public class DefaultMomentum
implements Momentum {
    private static final double DECELERATION_FACTOR = 0.9993;
    private static final double DECELERATION_STOP_VELOCITY = 0.02;
    private static final double MIN_DECELERATION = 5.0E-4;

    @Override
    public Momentum.State createState(Point initialPosition, Point initialVelocity) {
        return new Momentum.State(initialPosition, initialVelocity);
    }

    @Override
    public boolean updateState(Momentum.State state) {
        int ellapsedMillis = state.getElapsedMillis();
        int totalEllapsedMillis = state.getCumulativeElapsedMillis();
        Point initialVelocity = state.getInitialVelocity();
        Point oldVelocity = state.getVelocity();
        double decelFactor = Math.pow(0.9993, totalEllapsedMillis);
        double minDecel = (double)ellapsedMillis * 5.0E-4;
        double newVelocityX = this.calcNewVelocity(initialVelocity.getX(), decelFactor, oldVelocity.getX(), minDecel);
        double newVelocityY = this.calcNewVelocity(initialVelocity.getY(), decelFactor, oldVelocity.getY(), minDecel);
        Point newVelocity = new Point(newVelocityX, newVelocityY);
        state.setVelocity(newVelocity);
        int elapsedMillis = state.getElapsedMillis();
        Point dist = newVelocity.mult(new Point(elapsedMillis, elapsedMillis));
        Point position = state.getPosition();
        state.setPosition(position.plus(dist));
        return !(Math.abs(newVelocity.getX()) < 0.02) || !(Math.abs(newVelocity.getY()) < 0.02);
    }

    private double calcNewVelocity(double initialVelocity, double decelFactor, double oldVelocity, double minDecel) {
        double newVelocity = initialVelocity * decelFactor;
        if (oldVelocity >= 0.0) {
            double maxVelocityX = Math.max(0.0, oldVelocity - minDecel);
            newVelocity = Math.min(newVelocity, maxVelocityX);
        } else {
            double minVelocityX = Math.min(0.0, oldVelocity + minDecel);
            newVelocity = Math.max(newVelocity, minVelocityX);
        }
        return newVelocity;
    }
}

