/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.control;

import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;

public abstract class AbstractControl {
    protected ExtensionLoader loader = null;
    protected Model model = null;
    protected View view = null;

    public AbstractControl(Model model, View view) {
        this.model = model;
        this.view = view;
    }

    public ExtensionLoader getExtensionLoader() {
        if (this.loader == null) {
            this.loader = new ExtensionLoader(this.model, this.view);
        }
        return this.loader;
    }

    protected void loadExtension() {
        this.addCommonExtension();
        this.addExtension();
        this.getExtensionLoader().startLifeCycle();
    }

    protected abstract void addExtension();

    protected void addCommonExtension() {
    }

    public void shutdown(boolean bl) {
        this.getExtensionLoader().destroyAllExtension();
        this.model.getDb().close(bl);
    }
}

