<?php

/**
 * BaseOpenidProvider
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                  $providerId                                                Type: integer, primary key
 * @property string                               $providerName                                              Type: string(40)
 * @property string                               $providerUrl                                               Type: string(250)
 * @property int                                  $status                                                    Type: integer
 * @property Doctrine_Collection|UserIdentitiy[]  $UserIdentitiy                                             
 * @property AuthProviderExtraDetails             $AuthProviderExtraDetails                                  
 *  
 * @method int                                    getProviderid()                                            Type: integer, primary key
 * @method string                                 getProvidername()                                          Type: string(40)
 * @method string                                 getProviderurl()                                           Type: string(250)
 * @method int                                    getStatus()                                                Type: integer
 * @method Doctrine_Collection|UserIdentitiy[]    getUserIdentitiy()                                         
 * @method AuthProviderExtraDetails               getAuthProviderExtraDetails()                              
 *  
 * @method OpenidProvider                         setProviderid(int $val)                                    Type: integer, primary key
 * @method OpenidProvider                         setProvidername(string $val)                               Type: string(40)
 * @method OpenidProvider                         setProviderurl(string $val)                                Type: string(250)
 * @method OpenidProvider                         setStatus(int $val)                                        Type: integer
 * @method OpenidProvider                         setUserIdentitiy(Doctrine_Collection $val)                 
 * @method OpenidProvider                         setAuthProviderExtraDetails(AuthProviderExtraDetails $val) 
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseOpenidProvider extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_openid_provider');
        $this->hasColumn('id as providerId', 'integer', null, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             ));
        $this->hasColumn('provider_name as providerName', 'string', 40, array(
             'type' => 'string',
             'length' => 40,
             ));
        $this->hasColumn('provider_url as providerUrl', 'string', 250, array(
             'type' => 'string',
             'length' => 250,
             ));
        $this->hasColumn('status', 'integer', null, array(
             'type' => 'integer',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('UserIdentitiy', array(
             'local' => 'id',
             'foreign' => 'provider_id'));

        $this->hasOne('AuthProviderExtraDetails', array(
             'local' => 'id',
             'foreign' => 'provider_id'));
    }
}