/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.secure;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcServer;
import org.apache.xmlrpc.secure.SecurityConstants;
import org.apache.xmlrpc.secure.SecurityTool;

public class SecureWebServer
extends WebServer
implements SecurityConstants {
    public SecureWebServer(int n) {
        this(n, null);
    }

    public SecureWebServer(int n, InetAddress inetAddress) {
        super(n, inetAddress);
    }

    public SecureWebServer(int n, InetAddress inetAddress, XmlRpcServer xmlRpcServer) {
        super(n, inetAddress, xmlRpcServer);
    }

    protected ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws Exception {
        SecurityTool.setup();
        SSLContext sSLContext = SSLContext.getInstance((String)SecurityTool.getSecurityProtocol());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)SecurityTool.getKeyManagerType());
        KeyStore keyStore = KeyStore.getInstance(SecurityTool.getKeyStoreType());
        keyStore.load(new FileInputStream(SecurityTool.getKeyStore()), SecurityTool.getKeyStorePassword().toCharArray());
        keyManagerFactory.init(keyStore, SecurityTool.getKeyStorePassword().toCharArray());
        sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
        SSLServerSocketFactory sSLServerSocketFactory = sSLContext.getServerSocketFactory();
        return (SSLServerSocket)sSLServerSocketFactory.createServerSocket(n);
    }

    public static void main(String[] stringArray) {
        int n = SecureWebServer.determinePort(stringArray, 10000);
        XmlRpc.setKeepAlive(true);
        SecureWebServer secureWebServer = new SecureWebServer(n);
        try {
            secureWebServer.addDefaultHandlers();
            secureWebServer.start();
        }
        catch (Exception exception) {
            System.err.println("Error running secure web server");
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

