/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.server;

import com.google.gwt.core.server.LocalizableInstantiator;
import com.google.gwt.core.server.ObjectNew;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.core.shared.GWTBridge;
import com.google.gwt.i18n.server.GwtLocaleFactoryImpl;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.i18n.shared.GwtLocaleFactory;
import com.google.gwt.i18n.shared.Localizable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerGwtBridge
extends GWTBridge {
    private static Object instanceLock = new Object[0];
    private static ServerGwtBridge instance = null;
    private static final GwtLocaleFactory factory = new GwtLocaleFactoryImpl();
    private static final Logger LOGGER = Logger.getLogger(ServerGwtBridge.class.getName());
    private final Node root = new Node(Object.class);
    private final Object instantiatorsLock = new Object[0];
    private final ThreadLocal<PropertiesImpl> threadProperties;
    private final PropertiesImpl globalProperties = new PropertiesImpl();
    private Properties properties = new PropertyLookup();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerGwtBridge getInstance() {
        Object object = instanceLock;
        synchronized (object) {
            if (instance == null) {
                instance = new ServerGwtBridge();
                GWT.setBridge(instance);
            }
            return instance;
        }
    }

    public static GwtLocale getLocale(Properties properties) {
        String propVal = properties.getProperty("locale");
        if (propVal == null) {
            propVal = "default";
        }
        return factory.fromString(propVal);
    }

    ServerGwtBridge() {
        this.threadProperties = new ThreadLocal<PropertiesImpl>(){

            @Override
            protected PropertiesImpl initialValue() {
                return new PropertiesImpl();
            }
        };
        this.register(Object.class, new ObjectNew());
        this.register(Localizable.class, new LocalizableInstantiator());
    }

    @Override
    public <T> T create(Class<?> classLiteral) {
        Object object = this.instantiatorsLock;
        synchronized (object) {
            Node node;
            boolean found;
            Stack<Node> stack = new Stack<Node>();
            stack.push(this.root);
            block3: do {
                found = false;
                node = (Node)stack.peek();
                for (Node child : node.children) {
                    if (!child.type.isAssignableFrom(classLiteral)) continue;
                    found = true;
                    stack.push(child);
                    continue block3;
                }
            } while (found);
            while (!stack.isEmpty()) {
                node = (Node)stack.pop();
                for (ClassInstantiator inst : node.instantiators) {
                    Object obj = inst.create(classLiteral, this.properties);
                    if (obj == null) continue;
                    return obj;
                }
            }
            throw new RuntimeException("No instantiator created " + classLiteral.getCanonicalName());
        }
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    @Override
    public String getVersion() {
        return "unknown";
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void log(String message, Throwable e) {
        LOGGER.log(Level.INFO, message, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class<?> baseClass, ClassInstantiator instantiator) {
        Object object = this.instantiatorsLock;
        synchronized (object) {
            boolean found;
            Node node = this.root;
            do {
                found = false;
                for (Node child : node.children) {
                    if (!child.type.isAssignableFrom(baseClass)) continue;
                    found = true;
                    node = child;
                }
            } while (found);
            Node nodeToAdd = node;
            if (node.type != baseClass) {
                nodeToAdd = new Node(baseClass);
                boolean needsAdd = true;
                for (Node child : node.children) {
                    if (!baseClass.isAssignableFrom(child.type)) continue;
                    nodeToAdd.children.add(child);
                    int childPosition = node.children.indexOf(child);
                    node.children.set(childPosition, nodeToAdd);
                    needsAdd = false;
                    break;
                }
                if (needsAdd) {
                    node.children.add(nodeToAdd);
                }
            }
            nodeToAdd.instantiators.add(0, instantiator);
        }
    }

    public void setGlobalProperty(String property, String value) {
        this.globalProperties.setProperty(property, value);
    }

    public void setThreadProperty(String property, String value) {
        this.threadProperties.get().setProperty(property, value);
    }

    private class PropertyLookup
    implements Properties {
        private PropertyLookup() {
        }

        @Override
        public String getProperty(String name) {
            String val = ((PropertiesImpl)ServerGwtBridge.this.threadProperties.get()).getProperty(name);
            if (val == null) {
                val = ServerGwtBridge.this.globalProperties.getProperty(name);
            }
            return val;
        }
    }

    private static class PropertiesImpl
    implements Properties {
        private final Object lock = new Object[0];
        private final Map<String, String> map = new HashMap<String, String>();

        private PropertiesImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getProperty(String name) {
            Object object = this.lock;
            synchronized (object) {
                return this.map.get(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setProperty(String name, String value) {
            Object object = this.lock;
            synchronized (object) {
                this.map.put(name, value);
            }
        }
    }

    private static class Node {
        public final Class<?> type;
        public final ArrayList<Node> children;
        public final ArrayList<ClassInstantiator> instantiators;

        public Node(Class<?> type) {
            this.type = type;
            this.children = new ArrayList();
            this.instantiators = new ArrayList();
        }
    }

    public static interface Properties {
        public String getProperty(String var1);
    }

    public static abstract class ClassInstantiatorBase
    implements ClassInstantiator {
        protected <T> T tryCreate(Class<T> clazz) {
            try {
                T obj = clazz.newInstance();
                return obj;
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return null;
        }

        protected <T> T tryCreate(String className) {
            try {
                Class<?> clazz = Class.forName(className);
                Object obj = this.tryCreate(clazz);
                return (T)obj;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    public static interface ClassInstantiator {
        public <T> T create(Class<?> var1, Properties var2);
    }
}

