/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.User;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;

public class SessionManager {
    int sessionIdCount = 1;
    private IntKeyHashMap sessionMap = new IntKeyHashMap();
    private Session sysSession;

    public SessionManager(Database database) {
        User user = database.getUserManager().getSysUser();
        this.sysSession = new Session(database, user, false, false, 0);
    }

    public synchronized Session newSession(Database database, User user, boolean bl, boolean bl2) {
        Session session = new Session(database, user, true, bl, this.sessionIdCount);
        session.isProcessingLog = bl2;
        if (!bl2 && this.sessionMap.isEmpty()) {
            HsqlException[] hsqlExceptionArray = this.sysSession.getAndClearWarnings();
            for (int i = 0; i < hsqlExceptionArray.length; ++i) {
                session.addWarning(hsqlExceptionArray[i]);
            }
        }
        this.sessionMap.put(this.sessionIdCount, session);
        ++this.sessionIdCount;
        return session;
    }

    public Session getSysSession(String string, boolean bl) throws HsqlException {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.getSchemaHsqlName(string);
        this.sysSession.isProcessingScript = bl;
        this.sysSession.isProcessingLog = false;
        this.sysSession.setUser(this.sysSession.database.getUserManager().getSysUser());
        return this.sysSession;
    }

    public Session getSysSession() {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.defaultSchemaHsqlName;
        this.sysSession.isProcessingScript = false;
        this.sysSession.isProcessingLog = false;
        this.sysSession.setUser(this.sysSession.database.getUserManager().getSysUser());
        return this.sysSession;
    }

    public Session getSysSession(String string, User user) throws HsqlException {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.getSchemaHsqlName(string);
        this.sysSession.isProcessingScript = false;
        this.sysSession.isProcessingLog = false;
        this.sysSession.setUser(user);
        return this.sysSession;
    }

    public synchronized void closeAllSessions() {
        Session[] sessionArray = this.getAllSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            sessionArray[i].close();
        }
    }

    synchronized void removeSession(Session session) {
        this.sessionMap.remove(session.getId());
    }

    synchronized void clearAll() {
        this.sessionMap.clear();
    }

    synchronized boolean isEmpty() {
        return this.sessionMap.isEmpty();
    }

    synchronized Session[] getVisibleSessions(Session session) {
        Session[] sessionArray;
        if (session.isAdmin()) {
            sessionArray = this.getAllSessions();
        } else {
            Session[] sessionArray2 = new Session[1];
            sessionArray = sessionArray2;
            sessionArray2[0] = session;
        }
        return sessionArray;
    }

    synchronized Session getSession(int n) {
        return (Session)this.sessionMap.get(n);
    }

    public synchronized Session[] getAllSessions() {
        Session[] sessionArray = new Session[this.sessionMap.size()];
        Iterator iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            sessionArray[n] = (Session)iterator.next();
            ++n;
        }
        return sessionArray;
    }

    public synchronized boolean isUserActive(String string) {
        Iterator iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            if (string.equals(session.getUser().getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized void removeSchemaReference(SchemaManager.Schema schema) {
        Iterator iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            if (session.currentSchema == schema.name) {
                session.resetSchema();
            }
            ++n;
        }
    }
}

