# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the vyos_logging_global module
"""


class Logging_globalArgs(object):  # pylint: disable=R0903
    """The arg spec for the vyos_logging_global module"""

    argument_spec = {
        "config": {
            "type": "dict",
            "options": {
                "console": {
                    "type": "dict",
                    "options": {
                        "state": {
                            "type": "str",
                            "choices": ["enabled", "disabled"],
                        },
                        "facilities": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "facility": {
                                    "type": "str",
                                    "choices": [
                                        "all",
                                        "auth",
                                        "authpriv",
                                        "cron",
                                        "daemon",
                                        "kern",
                                        "lpr",
                                        "mail",
                                        "mark",
                                        "news",
                                        "protocols",
                                        "security",
                                        "syslog",
                                        "user",
                                        "uucp",
                                        "local0",
                                        "local1",
                                        "local2",
                                        "local3",
                                        "local4",
                                        "local5",
                                        "local6",
                                        "local7",
                                    ],
                                },
                                "severity": {
                                    "type": "str",
                                    "choices": [
                                        "emerg",
                                        "alert",
                                        "crit",
                                        "err",
                                        "warning",
                                        "notice",
                                        "info",
                                        "debug",
                                        "all",
                                    ],
                                },
                            },
                        },
                    },
                },
                "files": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "path": {"type": "str"},
                        "archive": {
                            "type": "dict",
                            "options": {
                                "state": {
                                    "type": "str",
                                    "choices": ["enabled", "disabled"],
                                },
                                "file_num": {"type": "int"},
                                "size": {"type": "int"},
                            },
                        },
                        "facilities": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "facility": {
                                    "type": "str",
                                    "choices": [
                                        "all",
                                        "auth",
                                        "authpriv",
                                        "cron",
                                        "daemon",
                                        "kern",
                                        "lpr",
                                        "mail",
                                        "mark",
                                        "news",
                                        "protocols",
                                        "security",
                                        "syslog",
                                        "user",
                                        "uucp",
                                        "local0",
                                        "local1",
                                        "local2",
                                        "local3",
                                        "local4",
                                        "local5",
                                        "local6",
                                        "local7",
                                    ],
                                },
                                "severity": {
                                    "type": "str",
                                    "choices": [
                                        "emerg",
                                        "alert",
                                        "crit",
                                        "err",
                                        "warning",
                                        "notice",
                                        "info",
                                        "debug",
                                        "all",
                                    ],
                                },
                            },
                        },
                    },
                },
                "global_params": {
                    "type": "dict",
                    "options": {
                        "state": {
                            "type": "str",
                            "choices": ["enabled", "disabled"],
                        },
                        "archive": {
                            "type": "dict",
                            "options": {
                                "state": {
                                    "type": "str",
                                    "choices": ["enabled", "disabled"],
                                },
                                "file_num": {"type": "int"},
                                "size": {"type": "int"},
                            },
                        },
                        "facilities": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "facility": {
                                    "type": "str",
                                    "choices": [
                                        "all",
                                        "auth",
                                        "authpriv",
                                        "cron",
                                        "daemon",
                                        "kern",
                                        "lpr",
                                        "mail",
                                        "mark",
                                        "news",
                                        "protocols",
                                        "security",
                                        "syslog",
                                        "user",
                                        "uucp",
                                        "local0",
                                        "local1",
                                        "local2",
                                        "local3",
                                        "local4",
                                        "local5",
                                        "local6",
                                        "local7",
                                    ],
                                },
                                "severity": {
                                    "type": "str",
                                    "choices": [
                                        "emerg",
                                        "alert",
                                        "crit",
                                        "err",
                                        "warning",
                                        "notice",
                                        "info",
                                        "debug",
                                        "all",
                                    ],
                                },
                            },
                        },
                        "marker_interval": {"type": "int"},
                        "preserve_fqdn": {"type": "bool"},
                    },
                },
                "hosts": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "port": {"type": "int"},
                        "facilities": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "facility": {
                                    "type": "str",
                                    "choices": [
                                        "all",
                                        "auth",
                                        "authpriv",
                                        "cron",
                                        "daemon",
                                        "kern",
                                        "lpr",
                                        "mail",
                                        "mark",
                                        "news",
                                        "protocols",
                                        "security",
                                        "syslog",
                                        "user",
                                        "uucp",
                                        "local0",
                                        "local1",
                                        "local2",
                                        "local3",
                                        "local4",
                                        "local5",
                                        "local6",
                                        "local7",
                                    ],
                                },
                                "severity": {
                                    "type": "str",
                                    "choices": [
                                        "emerg",
                                        "alert",
                                        "crit",
                                        "err",
                                        "warning",
                                        "notice",
                                        "info",
                                        "debug",
                                        "all",
                                    ],
                                },
                                "protocol": {
                                    "type": "str",
                                    "choices": ["udp", "tcp"],
                                },
                            },
                        },
                        "hostname": {"type": "str"},
                    },
                },
                "syslog": {
                    "type": "dict",
                    "options": {
                        "state": {
                            "type": "str",
                            "choices": ["enabled", "disabled"],
                        },
                    },
                },
                "users": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "username": {"type": "str"},
                        "facilities": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "facility": {
                                    "type": "str",
                                    "choices": [
                                        "all",
                                        "auth",
                                        "authpriv",
                                        "cron",
                                        "daemon",
                                        "kern",
                                        "lpr",
                                        "mail",
                                        "mark",
                                        "news",
                                        "protocols",
                                        "security",
                                        "syslog",
                                        "user",
                                        "uucp",
                                        "local0",
                                        "local1",
                                        "local2",
                                        "local3",
                                        "local4",
                                        "local5",
                                        "local6",
                                        "local7",
                                    ],
                                },
                                "severity": {
                                    "type": "str",
                                    "choices": [
                                        "emerg",
                                        "alert",
                                        "crit",
                                        "err",
                                        "warning",
                                        "notice",
                                        "info",
                                        "debug",
                                        "all",
                                    ],
                                },
                            },
                        },
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "parsed",
                "rendered",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
