<?php
/**
 * This basic interface for a resource owner.
 *
 * PHP version 5
 *
 * @category Kolab
 * @package  Kolab_FreeBusy
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.fsf.org/copyleft/lgpl.html LGPL
 * @link     http://pear.horde.org/index.php?package=Kolab_FreeBusy
 */

/**
 * This basic interface for a resource owner.
 *
 * Copyright 2010 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (LGPL). If you did not
 * receive this file, see
 * http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
 *
 * @category Kolab
 * @package  Kolab_FreeBusy
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.fsf.org/copyleft/lgpl.html LGPL
 * @link     http://pear.horde.org/index.php?package=Kolab_FreeBusy
 */
interface Horde_Kolab_FreeBusy_Owner
{
    /**
     * Return the primary id of the resource owner.
     *
     * @return string The primary id.
     */
    public function getPrimaryId();

    /**
     * Return the mail address of the resource owner.
     *
     * @return string The mail address.
     */
    public function getMail();

    /**
     * Return the name of the resource owner.
     *
     * @return string The name of the owner.
     */
    public function getName();
}