;;;
;;; irchat-pj-specific-emacs20.el
;;; last modify : Thu, 28 Oct 1999 00:04:46 +0900
;;;               by simm@irc.fan.gr.jp / irchat-PJ Project
;;; (date format modification by simm@irc.fan.gr.jp, Sun, 27 Jun 1999)
;;; see file irchat-copyright.el for change log and copyright info
;;;

;;; for irchat-pj-coding-system.el

;; define service / set process

(defsubst irchat-pj-define-service-coding-system (service)
  (modify-coding-system-alist 'network service (cons 'no-conversion 'no-conversion)))

(defsubst irchat-pj-set-process-coding-system (proc)
  (set-process-coding-system proc 'no-conversion 'no-conversion))

;; output functions

(defsubst irchat-pj-string-out-iso-2022-7bit-ss2 (str)
  (encode-coding-string str 'iso-2022-7bit-ss2))

(defsubst irchat-pj-string-out-iso-2022-jp (str)
  (encode-coding-string str 'iso-2022-jp))

(defsubst irchat-pj-string-out-euc-jp (str)
  (encode-coding-string str 'euc-jp))

(defsubst irchat-pj-string-out-sjis (str)
  (encode-coding-string str 'sjis))

;; input functions

(defsubst irchat-pj-string-in-iso-2022-7bit-ss2 (str)
  (decode-coding-string str 'iso-2022-7bit-ss2))

(defsubst irchat-pj-string-in-iso-2022-jp (str)
  (decode-coding-string str 'iso-2022-jp))

(defsubst irchat-pj-string-in-euc-jp-internal (str)
  (decode-coding-string str 'euc-jp))

(defsubst irchat-pj-string-in-sjis-internal (str)
  (decode-coding-string str 'sjis))

;;; for irchat-pj-version-string.el

(defun irchat-pj-set-emacs-version-string ()
  "Set Emacs version string for CTCP VERSION"
  (cond ((and (boundp 'enable-multibyte-characters) enable-multibyte-characters)
	 (concat "MULE "
		 (if (boundp 'rail-ja-mule-version)
		     rail-ja-mule-version
		   mule-version)
		 " GNU Emacs " emacs-version
		 " (" system-configuration ")"
		 (if (featurep 'meadow)
		     (let ((meadow-version
			    (if (boundp 'rail-ja-meadow-version)
				rail-ja-meadow-version
			      (Meadow-version))))
		       (if (string-match "^Meadow-" meadow-version)
			   (concat " Meadow "
				   (substring meadow-version (match-end 0)))
			 ""))
		   "")))
	(t
	 (concat "MULE " mule-version " based on Emacs " emacs-version
		 " (" system-configuration ")"))))

(provide 'irchat-pj-specific-emacs20)

;;;
;;; end
;;;
