# Copyright (C) 2008 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

import gtk

import logging
log = logging.getLogger(__name__)

from kiwi.ui.delegates import SlaveDelegate

from lottanzb.config import GConfigSection
from lottanzb.modes.frontend import Mode as _Mode
from lottanzb.util import gproperty, _

class Config(GConfigSection):
    address = gproperty(type=str, default="localhost")
    port = gproperty(type=int, minimum=1, default=8760)
    password = gproperty(type=str, default="changeme")

class Mode(_Mode):
    title = _("Remote front-end mode")
    short = _("Remote front-end")
    description = _("Monitor a HellaNZB daemon on another computer, which is "
        "already configured and running.")
    icon = gtk.STOCK_NETWORK
    
    def enter(self):
        for key in self.config:
            assert self.config[key]
        
        _Mode.enter(self)
    
    def get_connection_args(self):
        return (
            self.config.address,
            self.config.port,
            self.config.password
        )
    
    def handle_disconnect(self, backend):
        _Mode.handle_disconnect(self, backend,
            hint=_("Please make sure HellaNZB is running and the connection "
            "information are correctly set.")
        )
    
    def get_config_view(self):
        return ConfigView(self)
        
class ConfigView(SlaveDelegate):
    gladefile = "remote_frontend_config_view"
    
    def __init__(self, mode):
        self.mode = mode
        
        SlaveDelegate.__init__(self)
        
        for widget in [self.address, self.port, self.password]:
            widget.mandatory = True
        
        self.add_proxy(self.mode.config,["address", "port", "password"])
