require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_PSTL_CONFIG_H)) {
    eval 'sub _PSTL_CONFIG_H () {1;}' unless defined(&_PSTL_CONFIG_H);
    eval 'sub _PSTL_VERSION () {9000;}' unless defined(&_PSTL_VERSION);
    eval 'sub _PSTL_VERSION_MAJOR () {( &_PSTL_VERSION / 1000);}' unless defined(&_PSTL_VERSION_MAJOR);
    eval 'sub _PSTL_VERSION_MINOR () {(( &_PSTL_VERSION % 1000) / 10);}' unless defined(&_PSTL_VERSION_MINOR);
    eval 'sub _PSTL_VERSION_PATCH () {( &_PSTL_VERSION % 10);}' unless defined(&_PSTL_VERSION_PATCH);
    if(!defined(&_PSTL_PAR_BACKEND_SERIAL)  && !defined(&_PSTL_PAR_BACKEND_TBB)) {
	die("The parallel backend is neither serial nor TBB");
    }
    if(defined(&PSTL_USAGE_WARNINGS)) {
	undef(&_PSTL_USAGE_WARNINGS) if defined(&_PSTL_USAGE_WARNINGS);
	eval 'sub _PSTL_USAGE_WARNINGS () { &PSTL_USAGE_WARNINGS;}' unless defined(&_PSTL_USAGE_WARNINGS);
    }
 elsif(!defined(&_PSTL_USAGE_WARNINGS)) {
	eval 'sub _PSTL_USAGE_WARNINGS () {0;}' unless defined(&_PSTL_USAGE_WARNINGS);
    }
    if(defined(&_MSC_VER)) {
	eval 'sub _PSTL_PRAGMA {
	    my($x) = @_;
    	    eval q( &__pragma($x));
	}' unless defined(&_PSTL_PRAGMA);
    } else {
	eval 'sub _PSTL_PRAGMA {
	    my($x) = @_;
    	    eval q( &_Pragma( $x));
	}' unless defined(&_PSTL_PRAGMA);
    }
    eval 'sub _PSTL_STRING_AUX {
        my($x) = @_;
	    eval q($x);
    }' unless defined(&_PSTL_STRING_AUX);
    eval 'sub _PSTL_STRING {
        my($x) = @_;
	    eval q( &_PSTL_STRING_AUX($x));
    }' unless defined(&_PSTL_STRING);
    eval 'sub _PSTL_STRING_CONCAT {
        my($x, $y) = @_;
	    eval q($x $y);
    }' unless defined(&_PSTL_STRING_CONCAT);
    eval 'sub _PSTL_GCC_VERSION () {( &__GNUC__ * 10000+  &__GNUC_MINOR__ * 100+  &__GNUC_PATCHLEVEL__);}' unless defined(&_PSTL_GCC_VERSION);
    if((defined(&__clang__) ? &__clang__ : undef)) {
	eval 'sub _PSTL_CLANG_VERSION () {( &__clang_major__ * 10000+  &__clang_minor__ * 100+  &__clang_patchlevel__);}' unless defined(&_PSTL_CLANG_VERSION);
    }
    if(((defined(&_OPENMP) ? &_OPENMP : undef) >= 201307) || ((defined(&__INTEL_COMPILER) ? &__INTEL_COMPILER : undef) >= 1600) || (!defined(&__INTEL_COMPILER)  && (defined(&_PSTL_GCC_VERSION) ? &_PSTL_GCC_VERSION : undef) >= 40900)) {
	eval 'sub _PSTL_PRAGMA_SIMD () { &_PSTL_PRAGMA( &omp  &simd);}' unless defined(&_PSTL_PRAGMA_SIMD);
	eval 'sub _PSTL_PRAGMA_DECLARE_SIMD () { &_PSTL_PRAGMA( &omp  &declare  &simd);}' unless defined(&_PSTL_PRAGMA_DECLARE_SIMD);
	eval 'sub _PSTL_PRAGMA_SIMD_REDUCTION {
	    my($PRM) = @_;
    	    eval q( &_PSTL_PRAGMA( &omp  &simd  &reduction($PRM)));
	}' unless defined(&_PSTL_PRAGMA_SIMD_REDUCTION);
    }
 elsif(!defined(&_MSC_VER) ) {
	eval 'sub _PSTL_PRAGMA_SIMD () { &_PSTL_PRAGMA( &simd);}' unless defined(&_PSTL_PRAGMA_SIMD);
	eval 'sub _PSTL_PRAGMA_DECLARE_SIMD () {1;}' unless defined(&_PSTL_PRAGMA_DECLARE_SIMD);
	eval 'sub _PSTL_PRAGMA_SIMD_REDUCTION {
	    my($PRM) = @_;
    	    eval q( &_PSTL_PRAGMA( &simd  &reduction($PRM)));
	}' unless defined(&_PSTL_PRAGMA_SIMD_REDUCTION);
    } else {
	eval 'sub _PSTL_PRAGMA_SIMD () {1;}' unless defined(&_PSTL_PRAGMA_SIMD);
	eval 'sub _PSTL_PRAGMA_DECLARE_SIMD () {1;}' unless defined(&_PSTL_PRAGMA_DECLARE_SIMD);
	eval 'sub _PSTL_PRAGMA_SIMD_REDUCTION {
	    my($PRM) = @_;
    	    eval q();
	}' unless defined(&_PSTL_PRAGMA_SIMD_REDUCTION);
    }
    if(((defined(&__INTEL_COMPILER) ? &__INTEL_COMPILER : undef))) {
	eval 'sub _PSTL_PRAGMA_FORCEINLINE () { &_PSTL_PRAGMA( &forceinline);}' unless defined(&_PSTL_PRAGMA_FORCEINLINE);
    } else {
	eval 'sub _PSTL_PRAGMA_FORCEINLINE () {1;}' unless defined(&_PSTL_PRAGMA_FORCEINLINE);
    }
    if(((defined(&__INTEL_COMPILER) ? &__INTEL_COMPILER : undef) >= 1900) || ((defined(&_PSTL_GCC_VERSION) ? &_PSTL_GCC_VERSION : undef) >= 100000)) {
	eval 'sub _PSTL_PRAGMA_SIMD_SCAN {
	    my($PRM) = @_;
    	    eval q( &_PSTL_PRAGMA( &omp  &simd  &reduction( &inscan, $PRM)));
	}' unless defined(&_PSTL_PRAGMA_SIMD_SCAN);
	eval 'sub _PSTL_PRAGMA_SIMD_INCLUSIVE_SCAN {
	    my($PRM) = @_;
    	    eval q( &_PSTL_PRAGMA( &omp  &scan  &inclusive($PRM)));
	}' unless defined(&_PSTL_PRAGMA_SIMD_INCLUSIVE_SCAN);
	eval 'sub _PSTL_PRAGMA_SIMD_EXCLUSIVE_SCAN {
	    my($PRM) = @_;
    	    eval q( &_PSTL_PRAGMA( &omp  &scan  &exclusive($PRM)));
	}' unless defined(&_PSTL_PRAGMA_SIMD_EXCLUSIVE_SCAN);
    } else {
	eval 'sub _PSTL_PRAGMA_SIMD_SCAN {
	    my($PRM) = @_;
    	    eval q();
	}' unless defined(&_PSTL_PRAGMA_SIMD_SCAN);
	eval 'sub _PSTL_PRAGMA_SIMD_INCLUSIVE_SCAN {
	    my($PRM) = @_;
    	    eval q();
	}' unless defined(&_PSTL_PRAGMA_SIMD_INCLUSIVE_SCAN);
	eval 'sub _PSTL_PRAGMA_SIMD_EXCLUSIVE_SCAN {
	    my($PRM) = @_;
    	    eval q();
	}' unless defined(&_PSTL_PRAGMA_SIMD_EXCLUSIVE_SCAN);
    }
    eval 'sub _PSTL_CPP17_EXECUTION_POLICIES_PRESENT () {( &_MSC_VER >= 1912);}' unless defined(&_PSTL_CPP17_EXECUTION_POLICIES_PRESENT);
    eval 'sub _PSTL_CPP14_2RANGE_MISMATCH_EQUAL_PRESENT () {( &_MSC_VER >= 1900||  &__cplusplus >= 201300 ||  &__cpp_lib_robust_nonmodifying_seq_ops == 201304);}' unless defined(&_PSTL_CPP14_2RANGE_MISMATCH_EQUAL_PRESENT);
    eval 'sub _PSTL_CPP14_MAKE_REVERSE_ITERATOR_PRESENT () {( &_MSC_VER >= 1900||  &__cplusplus >= 201402 ||  &__cpp_lib_make_reverse_iterator == 201402);}' unless defined(&_PSTL_CPP14_MAKE_REVERSE_ITERATOR_PRESENT);
    eval 'sub _PSTL_CPP14_INTEGER_SEQUENCE_PRESENT () {( &_MSC_VER >= 1900||  &__cplusplus >= 201402);}' unless defined(&_PSTL_CPP14_INTEGER_SEQUENCE_PRESENT);
    eval 'sub _PSTL_CPP14_VARIABLE_TEMPLATES_PRESENT () {(! &__INTEL_COMPILER ||  &__INTEL_COMPILER >= 1700)  && ( &_MSC_FULL_VER >= 190023918||  &__cplusplus >= 201402);}' unless defined(&_PSTL_CPP14_VARIABLE_TEMPLATES_PRESENT);
    eval 'sub _PSTL_EARLYEXIT_PRESENT () {( &__INTEL_COMPILER >= 1800);}' unless defined(&_PSTL_EARLYEXIT_PRESENT);
    eval 'sub _PSTL_MONOTONIC_PRESENT () {( &__INTEL_COMPILER >= 1800);}' unless defined(&_PSTL_MONOTONIC_PRESENT);
    if(((defined(&__INTEL_COMPILER) ? &__INTEL_COMPILER : undef) >= 1900|| !defined(&__INTEL_COMPILER)  && (defined(&_PSTL_GCC_VERSION) ? &_PSTL_GCC_VERSION : undef) >= 40900|| (defined(&_OPENMP) ? &_OPENMP : undef) >= 201307)) {
	eval 'sub _PSTL_UDR_PRESENT () {1;}' unless defined(&_PSTL_UDR_PRESENT);
    } else {
	eval 'sub _PSTL_UDR_PRESENT () {0;}' unless defined(&_PSTL_UDR_PRESENT);
    }
    if((((defined(&__INTEL_COMPILER) ? &__INTEL_COMPILER : undef) >= 1900 && (defined(&__INTEL_COMPILER_BUILD_DATE) ? &__INTEL_COMPILER_BUILD_DATE : undef) >= 20180626) || (defined(&_PSTL_GCC_VERSION) ? &_PSTL_GCC_VERSION : undef) >= 100000)) {
	eval 'sub _PSTL_UDS_PRESENT () {1;}' unless defined(&_PSTL_UDS_PRESENT);
    } else {
	eval 'sub _PSTL_UDS_PRESENT () {0;}' unless defined(&_PSTL_UDS_PRESENT);
    }
    if((defined(&_PSTL_EARLYEXIT_PRESENT) ? &_PSTL_EARLYEXIT_PRESENT : undef)) {
	eval 'sub _PSTL_PRAGMA_SIMD_EARLYEXIT () { &_PSTL_PRAGMA( &omp  &simd  &early_exit);}' unless defined(&_PSTL_PRAGMA_SIMD_EARLYEXIT);
    } else {
	eval 'sub _PSTL_PRAGMA_SIMD_EARLYEXIT () {1;}' unless defined(&_PSTL_PRAGMA_SIMD_EARLYEXIT);
    }
    if((defined(&_PSTL_MONOTONIC_PRESENT) ? &_PSTL_MONOTONIC_PRESENT : undef)) {
	eval 'sub _PSTL_PRAGMA_SIMD_ORDERED_MONOTONIC {
	    my($PRM) = @_;
    	    eval q( &_PSTL_PRAGMA( &omp  &ordered  &simd  &monotonic($PRM)));
	}' unless defined(&_PSTL_PRAGMA_SIMD_ORDERED_MONOTONIC);
	eval 'sub _PSTL_PRAGMA_SIMD_ORDERED_MONOTONIC_2ARGS {
	    my($PRM1, $PRM2) = @_;
    	    eval q( &_PSTL_PRAGMA( &omp  &ordered  &simd  &monotonic($PRM1, $PRM2)));
	}' unless defined(&_PSTL_PRAGMA_SIMD_ORDERED_MONOTONIC_2ARGS);
    } else {
	eval 'sub _PSTL_PRAGMA_SIMD_ORDERED_MONOTONIC {
	    my($PRM) = @_;
    	    eval q();
	}' unless defined(&_PSTL_PRAGMA_SIMD_ORDERED_MONOTONIC);
	eval 'sub _PSTL_PRAGMA_SIMD_ORDERED_MONOTONIC_2ARGS {
	    my($PRM1, $PRM2) = @_;
    	    eval q();
	}' unless defined(&_PSTL_PRAGMA_SIMD_ORDERED_MONOTONIC_2ARGS);
    }
    eval 'sub _PSTL_PRAGMA_DECLARE_REDUCTION {
        my($NAME, $OP) = @_;
	    eval q( &_PSTL_PRAGMA( &omp  &declare  &reduction($NAME:$OP :  &omp_out( &omp_in))  &initializer( &omp_priv =  &omp_orig)));
    }' unless defined(&_PSTL_PRAGMA_DECLARE_REDUCTION);
    if(((defined(&__INTEL_COMPILER) ? &__INTEL_COMPILER : undef) >= 1600)) {
	eval 'sub _PSTL_PRAGMA_VECTOR_UNALIGNED () { &_PSTL_PRAGMA( &vector  &unaligned);}' unless defined(&_PSTL_PRAGMA_VECTOR_UNALIGNED);
    } else {
	eval 'sub _PSTL_PRAGMA_VECTOR_UNALIGNED () {1;}' unless defined(&_PSTL_PRAGMA_VECTOR_UNALIGNED);
    }
    if(defined(&PSTL_USE_NONTEMPORAL_STORES)  && ((defined(&__INTEL_COMPILER) ? &__INTEL_COMPILER : undef) >= 1600)) {
	eval 'sub _PSTL_USE_NONTEMPORAL_STORES_IF_ALLOWED () { &_PSTL_PRAGMA( &vector  &nontemporal);}' unless defined(&_PSTL_USE_NONTEMPORAL_STORES_IF_ALLOWED);
    } else {
	eval 'sub _PSTL_USE_NONTEMPORAL_STORES_IF_ALLOWED () {1;}' unless defined(&_PSTL_USE_NONTEMPORAL_STORES_IF_ALLOWED);
    }
    if((defined(&_MSC_VER) ? &_MSC_VER : undef) || (defined(&__INTEL_COMPILER) ? &__INTEL_COMPILER : undef) ) {
	eval 'sub _PSTL_PRAGMA_LOCATION () { &__FILE__ ":"  &_PSTL_STRING( &__LINE__) ": [Parallel STL message]: ";}' unless defined(&_PSTL_PRAGMA_LOCATION);
    } else {
	eval 'sub _PSTL_PRAGMA_LOCATION () {" [Parallel STL message]: ";}' unless defined(&_PSTL_PRAGMA_LOCATION);
    }
    eval 'sub _PSTL_PRAGMA_MESSAGE_IMPL {
        my($x) = @_;
	    eval q( &_PSTL_PRAGMA( &message( &_PSTL_STRING_CONCAT( &_PSTL_PRAGMA_LOCATION, $x))));
    }' unless defined(&_PSTL_PRAGMA_MESSAGE_IMPL);
    if((defined(&_PSTL_USAGE_WARNINGS) ? &_PSTL_USAGE_WARNINGS : undef)) {
	eval 'sub _PSTL_PRAGMA_MESSAGE {
	    my($x) = @_;
    	    eval q( &_PSTL_PRAGMA_MESSAGE_IMPL($x));
	}' unless defined(&_PSTL_PRAGMA_MESSAGE);
	eval 'sub _PSTL_PRAGMA_MESSAGE_POLICIES {
	    my($x) = @_;
    	    eval q( &_PSTL_PRAGMA_MESSAGE_IMPL($x));
	}' unless defined(&_PSTL_PRAGMA_MESSAGE_POLICIES);
    } else {
	eval 'sub _PSTL_PRAGMA_MESSAGE {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&_PSTL_PRAGMA_MESSAGE);
	eval 'sub _PSTL_PRAGMA_MESSAGE_POLICIES {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&_PSTL_PRAGMA_MESSAGE_POLICIES);
    }
    eval 'sub _PSTL_CPP11_STD_ROTATE_BROKEN () {(( &__GLIBCXX__  &&  &__GLIBCXX__ < 20150716) || ( &_MSC_VER  &&  &_MSC_VER < 1800));}' unless defined(&_PSTL_CPP11_STD_ROTATE_BROKEN);
    eval 'sub _PSTL_ICC_18_OMP_SIMD_BROKEN () {( &__INTEL_COMPILER == 1800);}' unless defined(&_PSTL_ICC_18_OMP_SIMD_BROKEN);
}
1;
