INSERT INTO `<?php echo $table_prefix ?>administration_tools` (`name`, `controller`, `action`, `order`) VALUES
	('test_mail_settings', 'administration', 'tool_test_email', 1);

INSERT INTO `<?php echo $table_prefix ?>config_categories` (`name`, `is_system`, `category_order`) VALUES
	('system', 1, 0),
	('general', 0, 1),
	('mailing', 0, 2),
	('brand_colors', 0, 3),
	('passwords', 0, 4),
	('reports', 0, 5);


INSERT INTO `<?php echo $table_prefix ?>config_options` (`category_name`, `name`, `value`, `config_handler_class`, `is_system`, `option_order`, `dev_comment`) VALUES
	('system', 'project_logs_per_page', '10', 'IntegerConfigHandler', 1, 0, NULL),
	('system', 'messages_per_page', '5', 'IntegerConfigHandler', 1, 0, NULL),
	('system', 'max_avatar_width', '50', 'IntegerConfigHandler', 1, 0, NULL),
	('system', 'max_avatar_height', '50', 'IntegerConfigHandler', 1, 0, NULL),
	('system', 'logs_per_project', '5', 'IntegerConfigHandler', 1, 0, NULL),
	('system', 'max_logo_width', '50', 'IntegerConfigHandler', 1, 0, NULL),
	('system', 'max_logo_height', '50', 'IntegerConfigHandler', 1, 0, NULL),
	('system', 'files_per_page', '50', 'IntegerConfigHandler', 1, 0, NULL),
	('system', 'notification_from_address', '', 'StringConfigHandler', 1, 0, 'Address to use as from field in email notifications. If empty, users address is used'),
	('system', 'min_chars_for_match', '3', 'IntegerConfigHandler', 1, 0, 'If search criteria len is less than this, then use always LIKE'),
	('system', 'getting_started_step', '1', 'IntegerConfigHandler', 1, 0, ''),
	('general', 'upgrade_last_check_datetime', '2006-09-02 13:46:47', 'DateTimeConfigHandler', 1, 0, 'Date and time of the last upgrade check'),
	('general', 'upgrade_last_check_new_version', '0', 'BoolConfigHandler', 1, 0, 'True if system checked for the new version and found it. This value is used to hightligh upgrade tab in the administration'),
	('general', 'file_storage_adapter', 'fs', 'FileStorageConfigHandler', 0, 0, 'What storage adapter should be used? fs or mysql'),
	('general', 'theme', 'default', 'ThemeConfigHandler', 0, 0, NULL),
	('general', 'days_on_trash', '30', 'IntegerConfigHandler', 0, 0, 'Days before a file is deleted from trash. 0 = Not deleted'),
    ('general', 'show_pause_time_action', '1', 'BoolConfigHandler', '0', '0', NULL),
	('mailing', 'exchange_compatible', '0', 'BoolConfigHandler', 1, 0, NULL),
	('mailing', 'mail_transport', 'mail()', 'MailTransportConfigHandler', 0, 0, 'Values: ''mail()'' - try to emulate mail() function, ''smtp'' - use SMTP connection'),
	('mailing', 'smtp_server', '', 'StringConfigHandler', 0, 0, ''),
	('mailing', 'smtp_port', '25', 'IntegerConfigHandler', 0, 0, NULL),
	('mailing', 'smtp_address', '', 'StringConfigHandler', 0, 0, ''),
    ('mailing', 'notification_from_name', '', 'StringConfigHandler', 0, 0, ''),
	('mailing', 'smtp_authenticate', '0', 'BoolConfigHandler', 0, 0, 'Use SMTP authentication'),
	('mailing', 'smtp_username', '', 'StringConfigHandler', 0, 0, NULL),
	('mailing', 'smtp_password', '', 'PasswordConfigHandler', 0, 0, NULL),
	('mailing', 'smtp_secure_connection', 'no', 'SecureSmtpConnectionConfigHandler', 0, 0, 'Values: no, ssl, tls'),
	('mailing', 'show images in document notifications', '0', 'BoolConfigHandler', 0, 0, NULL),
	('mailing', 'show company logo in notifications', '1', 'BoolConfigHandler', 0, 0, NULL),
	('mailing', 'notification_recipients_field', 'to', 'MailFieldConfigHandler', '0', '10', NULL),
    ('mailing', 'disable_notifications_for_object_type', '', 'MultipleObjectTypeConfigHandler', 0, 0, NULL),
    ('mailing', 'notifications_add_members_in_subject', '', 'ManageableDimensionsConfigHandler', 0, 0, NULL),
	('passwords', 'min_password_length', '8', 'IntegerConfigHandler', 0, '1', NULL),
	('passwords', 'password_numbers', '1', 'IntegerConfigHandler', 0, '2', NULL),
	('passwords', 'password_uppercase_characters', '1', 'IntegerConfigHandler', 0, '3', NULL),
	('passwords', 'password_metacharacters', '1', 'IntegerConfigHandler', 0, '4', NULL),
	('passwords', 'password_expiration', '90', 'IntegerConfigHandler', 0, '5', NULL),
	('passwords', 'password_expiration_notification', '5', 'IntegerConfigHandler', 0, '6', NULL),
	('passwords', 'account_block', '0', 'BoolConfigHandler', 0, '7', NULL),
	('passwords', 'new_password_char_difference', '0', 'BoolConfigHandler', '0', '8', NULL),
	('passwords', 'validate_password_history', '0', 'BoolConfigHandler', '0', '9', NULL),
	('passwords', 'block_login_after_x_tries', '1', 'BoolConfigHandler', '0', '20', NULL),
	('general', 'checkout_notification_dialog', '0', 'BoolConfigHandler', '0', '0', NULL),
	('general', 'file_revision_comments_required', '0', 'BoolConfigHandler', '0', '0', NULL),
	('general', 'currency_code', '$', 'StringConfigHandler', '0', '0', NULL),
	('general', 'checkout_for_editing_online', '0', 'BoolConfigHandler', '0', '0', NULL),
	('general', 'show_feed_links', '0', 'BoolConfigHandler', '0', '0', NULL),
	('general', 'use_owner_company_logo_at_header', '1', 'BoolConfigHandler', '0', '0', NULL),
	('general', 'ask_administration_autentification', 0, 'BoolConfigHandler', 0, 0, NULL),
	('general', 'use tasks dependencies', 1, 'BoolConfigHandler', 0, 0, NULL),
	('general', 'use_task_work_performed', '1', 'BoolConfigHandler', '0', '0', NULL),
	('general', 'use_task_estimated_time', '1', 'BoolConfigHandler', '0', '0', NULL),
	('general', 'use_task_pending_time', '1', 'BoolConfigHandler', '0', '0', NULL),
	('general', 'use_task_percent_completed', '1', 'BoolConfigHandler', '0', '0', NULL),
    ('general', 'untitled_notes', '0', 'BoolConfigHandler', '0', '0', NULL),
    ('general', 'repeating_task', '0', 'BoolConfigHandler', '0', '0', NULL),
    ('general', 'working_days', '1,2,3,4,5,6,7', 'StringConfigHandler', '0', '0', NULL),
    ('general', 'wysiwyg_tasks', '1', 'BoolConfigHandler', '0', '0', NULL),
    ('general', 'wysiwyg_messages', '1', 'BoolConfigHandler', '0', '0', NULL),
    ('general', 'wysiwyg_projects', '0', 'BoolConfigHandler', '0', '0', NULL),
    ('general', 'use_milestones', '0', 'BoolConfigHandler', '0', '0', NULL),
    ('general', 'apply_milestone_subtasks', '1', 'BoolConfigHandler', '0', '0', NULL),
    ('general', 'show_tab_icons', '1', 'BoolConfigHandler', '0', '0', NULL),
	('general', 'can_assign_tasks_to_companies', '0', 'BoolConfigHandler', '0', '0', NULL),
    ('general', 'use_object_properties', '0', 'BoolConfigHandler', '0', '0', NULL),
    ('general', 'let_users_create_objects_in_root', '1', 'BoolConfigHandler', '0', '0', NULL),
    ('general', 'add_default_permissions_for_users', '1', 'BoolConfigHandler', '0', '0', NULL),
    ('general', 'inherit_permissions_from_parent_member', '1', 'BoolConfigHandler', '0', '0', NULL),
    ('general', 'give_member_permissions_to_new_users', '', 'UserTypeMultipleConfigHandler', '0', '0', NULL),
    ('general', 'milestone_selector_filter', 'current_and_parents', 'MilestoneSelectorFilterConfigHandler', 0, 0, NULL),
    ('general', 'show_owner_company_name_header', '0', 'BoolConfigHandler', 1, 100, ''),
	('general', 'enabled_dimensions', '', 'RootDimensionsConfigHandler', '1', '0', NULL),
	('general', 'last_sharing_table_rebuild', '', 'StringConfigHandler', '1', '0', NULL),
	('general', 'check_unique_mail_contact_comp', '0', 'BoolConfigHandler', 0, 0, NULL),
	('general', 'mandatory_address_fields', '', 'AddressFieldsConfigHandler', 0, 0, NULL),
	('system', 'last_template_instantiation_id', '0', 'IntegerConfigHandler', 1, 0, NULL),
	('brand_colors', 'brand_colors_head_back', '424242', 'ColorPickerConfigHandler', '0', '0', NULL),
    ('brand_colors', 'brand_colors_texture', '1', 'BoolConfigHandler', '0', '0', NULL),
	('brand_colors', 'brand_colors_head_font', 'FFFFFF', 'ColorPickerConfigHandler', '0', '0', NULL),
	('brand_colors', 'brand_colors_tabs_back', 'e7e7e7', 'ColorPickerConfigHandler', '1', '0', NULL),
	('brand_colors', 'brand_colors_tabs_font', '333333', 'ColorPickerConfigHandler', '1', '0', NULL),
	('reports', 'reports_inherit_company_address', '', 'BoolConfigHandler', '0', '0', NULL),
	('reports', 'reports_inherit_company_phones', '', 'BoolConfigHandler', '0', '0', NULL),
	('reports', 'show_company_info_report_print', '1', 'BoolConfigHandler', '0', '0', NULL),
	('general', 'use_time_quick_add_row', '1', 'BoolConfigHandler', 0, 0, NULL),
	('general', 'reclassify_time_when_linking_task', '1', 'BoolConfigHandler', 0, 0, ''),
	('general', 'ignored_dims_task_related_objs', '', 'ManageableDimensionsConfigHandler', '0', '0', ''),
	('system', 'default_timezone', '', 'TimezoneConfigHandler', 1, 0, ''),
	('system', 'users_that_can_mark_as_invoiced', '', 'StringConfigHandler', '0', '0', ''),
	('clients_and_contacts', 'default_type_address', '1', 'DefaultTypeAddressConfigHandler', 0, 0, ''),
	('clients_and_contacts', 'default_country_address', 'us', 'DefaultCountryAddressConfigHandler', 0, 0, ''),
	('clients_and_contacts', 'default_type_phone', '1', 'DefaultTypePhoneConfigHandler', '0', '0', ''),
	('clients_and_contacts', 'default_type_email', '1', 'DefaultTypeEmailConfigHandler', '0', '0', ''),
	('clients_and_contacts', 'mandatory_email_on_contacts', '0', 'BoolConfigHandler', '0', '0', '');
		
INSERT INTO `<?php echo $table_prefix ?>file_types` (`extension`, `icon`, `is_searchable`, `is_image`, `friendly_name`) VALUES
	('zip', 'archive.png', 0, 0, 'compressed archive file zip'),
	('rar', 'archive.png', 0, 0, 'compressed archive file rar'),
	('bz', 'archive.png', 0, 0, 'compressed archive file bz'),
	('bz2', 'archive.png', 0, 0, 'compressed archive file bz'),
	('gz', 'archive.png', 0, 0, 'compressed archive file gz'),
	('ace', 'archive.png', 0, 0, 'compressed archive file ace'),
	('mp3', 'audio.png', 0, 0, 'audio mp3'),
	('wma', 'audio.png', 0, 0, 'Windows Media audio'),
	('ogg', 'audio.png', 0, 0, 'vorbis audio file'),
	('doc', 'doc.png', 0, 0, 'microsoft word file'),
	('xls', 'xls.png', 0, 0, 'microsoft excel spreadsheet'),
	('docx', 'doc.png', 1, 0, 'microsoft word xml document'),
	('xlsx', 'xls.png', 0, 0, 'microsoft excel xml spreadsheet'),
	('gif', 'image.png', 0, 1, 'gif image'),
	('jpg', 'image.png', 0, 1, 'jpg image'),
	('jpeg', 'image.png', 0, 1, 'jpeg image'),
	('png', 'image.png', 0, 1, 'png image'),
	('mov', 'mov.png', 0, 0, 'quicktime movie file'),
	('pdf', 'pdf.png', 1, 0, 'pdf file'),
	('psd', 'psd.png', 0, 0, 'adobe photoshop document'),
	('rm', 'rm.png', 0, 0, 'real media file'),
	('svg', 'svg.png', 0, 0, 'vector graphics file'),
	('swf', 'swf.png', 0, 0, 'shockwave flash movie'),
	('avi', 'video.png', 0, 0, 'microsoft audio/visual interleaved'),
	('mpeg', 'video.png', 0, 0, 'motion picture experts group file'),
	('mpg', 'video.png', 0, 0, 'video stream'),
	('qt', 'mov.png', 0, 0, 'apple quicktime movie'),
	('vob', 'video.png', 0, 0, 'dvd video object file'),
	('txt', 'text.png', 1, 0, 'raw text file'),
	('html', 'html.png', 1, 0, 'hypertext markup language file'),
	('slim', 'ppt.png', 1, 0, 'slim presentation file'),	
	('ppt', 'ppt.png', 0, 0, 'powerpoint presentation file'),	
	('webfile', 'webfile.png', 0, 0, 'web file'),    
	('odt', 'doc.png', '0', '0', 'opendocument text document'),    
	('fodt', 'doc.png', '0', '0', 'fodt'),    
	('ics', 'ics.png', '0', '0', 'icalendar file');


INSERT INTO `<?php echo $table_prefix ?>im_types` (`name`, `icon`, `disabled`) VALUES
	('ICQ', 'icq.gif', '1'),
	('AIM', 'aim.gif', '1'),
	('MSN', 'msn.gif', '1'),
	('Yahoo!', 'yahoo.gif', '1'),
	('Skype', 'skype.gif', '1'),
	('Jabber', 'jabber.gif', '1'),
	('Twitter', 'twitter.svg', '0'),
	('Facebook', 'facebook.svg', '0'),
	('LinkedIn', 'linkedin.svg', '0');


INSERT INTO `<?php echo $table_prefix ?>cron_events` (`name`, `recursive`, `delay`, `is_system`, `enabled`, `date`) VALUES
	('purge_trash', '1', '1440', '1', '1', '1900-01-01 00:00:00'),
	('send_reminders', '1', '10', '0', '1', '1900-01-01 00:00:00'),
	('send_password_expiration_reminders', '1', '1440', '1', '1', '1900-01-01 00:00:00'),
	('send_notifications_through_cron', '1', '1', '0', '0', '1900-01-01 00:00:00'),
	('delete_mails_from_server', '1', '1440', '1', '1', '1900-01-01 00:00:00'),
	('clear_tmp_folder', '1', '1440', '1', '1', '1900-01-01 00:00:00'),
	('check_upgrade', '1', '1440', '1', '0', '1900-01-01 00:00:00'),
	('import_google_calendar', '1', '10', '0', '0', '1900-01-01 00:00:00'),
	('export_google_calendar', '1', '10', '0', '0', '1900-01-01 00:00:00'),
	('sharing_table_partial_rebuild', '1', '1440', '1', '1', '1900-01-01 00:00:00'),
	('check_sharing_table_flags', '1', '10', '1', '1', '1900-01-01 00:00:00'),
	('clean_object_selector_temp_selection', '1', '360', '1', '1', '1900-01-01 00:00:00'),
	('send_outbox_mails', '1', '1', '1', '1', '1900-01-01 00:00:00'),
	('rebuild_contact_member_cache', '1', '1440', '1', '1', '1900-01-01 00:00:00');
	
INSERT INTO `<?php echo $table_prefix ?>object_reminder_types` (`name`) VALUES
  ('reminder_email'),
  ('reminder_popup');
  
INSERT INTO `<?php echo $table_prefix ?>contact_config_categories` (`name`, `is_system`, `type`, `category_order`, `located_under`) VALUES 
	('general', 0, 0, 0, 0),
	('task panel', 0, 0, 2, 0),
	('calendar panel', 0, 0, 4, 0),
	('context help', 1, 0, 5, 0),
	('time panel', 0, 0, 3, 0),
	('contact panel', 0, 0, 8, 0),
	('listing preferences', 0, 0, 10, 0),
	('reporting', 0, 0, 15, 0),
	('connected systems', 0, 0, 9, 0);
	
INSERT INTO `<?php echo $table_prefix ?>contact_config_options` (`category_name`, `name`, `default_value`, `config_handler_class`, `is_system`, `option_order`, `dev_comment`) VALUES 
 ('task panel','tasksDateStart','0000-00-00 00:00:00','DateTimeConfigHandler',1,0,'date from to filter out task list'),
 ('task panel','tasksDateEnd','0000-00-00 00:00:00','DateTimeConfigHandler',1,0,'the date up to filter the list of tasks'),
 ('task panel', 'show_notify_checkbox_in_quick_add', '1', 'BoolConfigHandler', 1, 0, 'Show notification checkbox in quick add task view'),
 ('task panel', 'can notify from quick add', '1', 'BoolConfigHandler', 0, 0, 'Notification checkbox default value'),
 ('task panel', 'can notify subscribers', '1', 'BoolConfigHandler', 0, 0, 'Notification checkbox default value'),
 ('task panel', 'tasksShowWorkspaces', '1', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowTime', '1', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowTimeQuick', '1', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowDates', '1', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowPercentCompletedBar', '0', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowTimeEstimates', '1', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowTotalTimeEstimates', '0', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowTimePending', '0', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowTimeWorked', '0', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowTotalTimeWorked', '0', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowRemainingTime', '0', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowTotalRemainingTime', '0', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowQuickEdit', '1', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowQuickComplete', '0', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowQuickComment', '0', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowQuickMarkAsStarted', '1', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowStartDates', '0', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowAssignedBy', '0', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowClassification', '1', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowSubtasksStructure', '1', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowEndDates', '1', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowQuickAddSubTasks', '0', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowDescriptionOnTimeForms', '1', 'BoolConfigHandler', 0, 0, ''),
 ('task panel', 'tasksShowTags', '1', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksShowEmptyMilestones', '1', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksPreviousPendingTasks', '1', 'BoolConfigHandler', 1, 0, ''),
 ('task panel', 'tasksGroupBy', 'due_date', 'StringConfigHandler', 1, 0, ''),
 ('task panel', 'tasksOrderBy', 'priority', 'StringConfigHandler', 1, 0, ''),
 ('task panel', 'tasksListingOrder', 'ASC', 'StringConfigHandler', 1, 0, ''),
 ('task panel', 'task panel status', '1', 'IntegerConfigHandler', 1, 0, ''),
 ('task panel', 'task panel filter', 'assigned_to', 'StringConfigHandler', 1, 0, ''),
 ('task panel', 'task panel filter value', '0', 'UserCompanyConfigHandler', 1, 0, ''),
 ('task panel', 'noOfTasks', '15', 'IntegerConfigHandler', '0', '100', NULL),
 ('task panel', 'task_display_limit', '500', 'IntegerConfigHandler', '0', '200', NULL),
 ('task panel', 'pushUseWorkingDays', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('task panel', 'tasksShowDimensionCols', '', 'StringConfigHandler', 1, 0, ''),
 ('task panel', 'tasksUseDateFilters', '1', 'BoolConfigHandler', 0, 0, ''),
 ('task panel', 'tasksShowAssignedToName', '0', 'BoolConfigHandler', 0, 0, ''),
 ('task panel', 'tasksGroupsPaginationCount', '5', 'IntegerConfigHandler', 0, 0, ''),
 ('general', 'listingContactsBy', '0', 'BoolConfigHandler', '0', '0', NULL),
 ('general', 'localization', '', 'LocalizationConfigHandler', 0, 100, ''),
 ('general', 'search_engine', 'match', 'SearchEngineConfigHandler', 0, 700, ''),
 ('general', 'lastAccessedWorkspace', '0', 'IntegerConfigHandler', 1, 0, ''),
 ('general', 'work_day_start_time', '9:00', 'TimeConfigHandler', 0, 400, 'Work day start time'),
 ('general', 'work_day_end_time', '18:00', 'TimeConfigHandler', 0, 410, 'Work day end time'),
 ('general', 'time_format_use_24', '0', 'BoolConfigHandler', 0, 500, 'Use 24 hours time format'),
 ('general', 'date_format', 'd/m/Y', 'DateFormatConfigHandler', 0, 600, 'Date objects will be displayed using this format.'),
 ('general', 'descriptive_date_format', 'F j, Y (l)', 'StringConfigHandler', 0, 700, 'Descriptive dates will be displayed using this format.'),
 ('general', 'custom_report_tab', '5', 'StringConfigHandler', '1', '0', NULL),
 ('general', 'last_mail_format', 'html', 'StringConfigHandler', '1', '0', NULL),
 ('general', 'amount_objects_to_show', '5', 'IntegerConfigHandler', '0', '0', NULL),
 ('general', 'reset_password', '', 'StringConfigHandler', '1', '0', 'Used to store per-user tokens to validate password reset requests'),
 ('general', 'autodetect_time_zone', '1', 'BoolConfigHandler', '0', '0', NULL),
 ('general', 'detect_mime_type_from_extension', '0', 'BoolConfigHandler', '0', '0', NULL),
 ('general', 'root_dimensions', '', 'RootDimensionsConfigHandler', '0', '0', NULL),
 ('general', 'show_object_direct_url',0,'BoolConfigHandler',0,0,NULL ),
 ('general', 'drag_drop_prompt','prompt','DragDropPromptConfigHandler',0,0,NULL ),
 ('general', 'notify_myself_too', '0', 'BoolConfigHandler', '0', '100', ''),
 ('calendar panel', 'calendar view type', 'viewweek', 'StringConfigHandler', 1, 0, ''),
 ('calendar panel', 'calendar user filter', '0', 'IntegerConfigHandler', 1, 0, ''),
 ('calendar panel', 'calendar status filter', '', 'StringConfigHandler', 1, 0, ''),
 ('calendar panel', 'start_monday', '', 'BoolConfigHandler', 0, 0, ''),
 ('calendar panel', 'show_week_numbers', '', 'BoolConfigHandler', 0, 0, ''),
 ('calendar panel', 'show_birthdays_in_calendar', '1', 'BoolConfigHandler', 0, 0, ''),
 ('calendar panel', 'show_multiple_color_events', '1', 'BoolConfigHandler', 0, 0, ''),
 ('calendar panel', 'displayed events amount', '3', 'IntegerConfigHandler', 0, 0, ''),
 ('context help', 'show_tasks_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_account_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_active_tasks_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_general_timeslots_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_late_tasks_widget_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_pending_tasks_widget_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_documents_widget_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_active_tasks_widget_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_calendar_widget_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_messages_widget_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_dashboard_info_widget_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_comments_widget_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_emails_widget_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_reporting_panel_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_file_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_administration_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_member_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_contact_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_company_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_upload_file_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_upload_file_workspace_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_upload_file_tags_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_upload_file_description_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_upload_file_custom_properties_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_upload_file_subscribers_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_upload_file_linked_objects_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_note_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_note_workspace_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_note_tags_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_note_custom_properties_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_note_subscribers_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_note_linked_object_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_milestone_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_milestone_workspace_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_milestone_tags_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_milestone_description_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_milestone_reminders_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_milestone_custom_properties_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_milestone_linked_object_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_milestone_subscribers_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_workspace_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_print_report_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_task_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_task_workspace_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_task_tags_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_task_reminders_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_task_custom_properties_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_task_linked_objects_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_task_subscribers_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_list_task_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_time_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_webpage_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_webpage_workspace_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_webpage_tags_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_webpage_description_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_webpage_custom_properties_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_webpage_subscribers_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_webpage_linked_objects_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_event_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_event_workspace_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_event_tag_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_event_description_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_event_repeat_options_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_event_reminders_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_event_custom_properties_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_event_subscribers_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_event_linked_objects_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('context help', 'show_add_event_inivitation_context_help', '1', 'BoolConfigHandler', '1', '0', NULL),
 ('time panel', 'TM show time type', '0', 'IntegerConfigHandler', 1, 0, ''),
 ('time panel', 'TM report show time type', '0', 'IntegerConfigHandler', 1, 0, ''),
 ('time panel', 'TM user filter', '0', 'IntegerConfigHandler', 1, 0, ''),
 ('time panel', 'TM tasks user filter', '0', 'IntegerConfigHandler', 1, 0, ''),
 ('time panel', 'show_start_time_action', '1', 'BoolConfigHandler', 0, 0, ''),
 ('time panel', 'add_timeslot_view_dimensions_combos', '', 'ManageableDimensionsConfigHandler', '0', '0', 'dimensions ids for skip'),
 ('time panel', 'show_pause_time_action', '1', 'BoolConfigHandler', '0', '0', ''),
 ('time panel', 'stop_running_timeslots', '3', 'ListConfigHandler', '0', '0', ''), 
 ('general', 'show_context_help', 'until_close', 'ShowContextHelpConfigHandler', '0', '0', NULL),
 ('dashboard', 'show charts widget', '1', 'BoolConfigHandler', 0, 600, ''),
 ('dashboard', 'show dashboard info widget', '1', 'BoolConfigHandler', 0, 900, ''),
 ('general', 'rememberGUIState', '1', 'RememberGUIConfigHandler', 0, 300, ''),
 ('calendar panel', 'calendar task filter', 'pending', 'StringConfigHandler', 1, 0, ''),
 ('task panel', 'close timeslot open', '1', 'BoolConfigHandler', 0, 0, ''),
 ('calendar panel', 'reminders_events', 'reminder_email,1,60', 'StringConfigHandler', '0', '0', NULL),
 ('dashboard', 'filters_dashboard', '0,0,10,0', 'StringConfigHandler', '0', '0', 'first position: entry to see the dimension, second position: view timeslot, third position: recent activities to show, fourth position: view views and downloads'),
 ('task panel', 'reminders_tasks', 'reminder_email,1,1440', 'StringConfigHandler', '0', '23', NULL),
 ('task panel', 'add_task_autoreminder', '0', 'BoolConfigHandler', '0', '21', NULL),
 ('task panel', 'add_self_task_autoreminder', '1', 'BoolConfigHandler', '0', '22', NULL),
 ('task panel', 'add_task_default_reminder', '1', 'BoolConfigHandler', '0', '20', NULL),
 ('task panel', 'quick_add_task_view_dimensions_combos', '', 'ManageableDimensionsConfigHandler', '0', '0', 'dimensions ids for skip'),
 ('calendar panel', 'add_event_autoreminder', '1', 'BoolConfigHandler', '0', '0', NULL),
 ('calendar panel', 'autoassign_events', '0', 'BoolConfigHandler', '0', '0', NULL),
 ('calendar panel', 'event_send_invitations', '1', 'BoolConfigHandler', '0', '0', NULL),
 ('calendar panel', 'event_subscribe_invited', '1', 'BoolConfigHandler', '0', '0', NULL),
 ('mails panel', 'mails_per_page', '50', 'IntegerConfigHandler', '0', '0', NULL),
 ('mails panel', 'attach_to_notification', '0', 'BoolConfigHandler', '0', '0', NULL),
 ('general', 'access_member_after_add', '1', 'BoolConfigHandler', '0', '1300', NULL),
 ('general', 'access_member_after_add_remember', '0', 'BoolConfigHandler', '0', '1301', NULL),
 ('general', 'sendEmailNotification', '1', 'BoolConfigHandler', '0', '0', 'Send email notification to new user'),
 ('general', 'viewContactsChecked', '1', 'BoolConfigHandler', '1', '0', 'in people panel is view contacts checked'),
 ('general', 'viewUsersChecked', '1', 'BoolConfigHandler', '1', '0', 'in people panel is view users checked'),
 ('general', 'viewCompaniesChecked', '1', 'BoolConfigHandler', '1', '0', 'in people panel is view companies checked'),
 ('general', 'updateOnLinkedObjects', '1', 'BoolConfigHandler', '0', '0', 'Update objects when linking others'),
 ('dashboard', 'overviewAsList', '0', 'BoolConfigHandler', '1', '0', 'View Overview as list'),
 ('general', 'contacts_per_page', '50', 'IntegerConfigHandler', '0', '1200', NULL),
 ('listing preferences', 'breadcrumb_member_count', '5', 'IntegerConfigHandler', '0', '5', NULL),
 ('general', 'timeReportDate', '4', 'IntegerConfigHandler', 1, 0, ''),
 ('general', 'timeReportDateStart', '1900-01-01 00:00:00', 'DateTimeConfigHandler', 1, 0, ''),
 ('general', 'timeReportDateEnd', '1900-01-01 00:00:00', 'DateTimeConfigHandler', 1, 0, ''),
 ('general', 'timeReportPerson', '0', 'IntegerConfigHandler', 1, 0, ''),
 ('general', 'timeReportTimeslotType', '2', 'IntegerConfigHandler', 1, 0, ''),
 ('general', 'timeReportGroupBy', '0,0,0', 'StringConfigHandler', 1, 0, ''),
 ('general', 'timeReportAltGroupBy', '0,0,0', 'StringConfigHandler', 1, 0, ''),
 ('general', 'timeReportShowEstimatedTime', '1', 'BoolConfigHandler', 1, 0, ''),
 ('general', 'timeReportTaskStatus', 'all', 'StringConfigHandler', 1, 0, ''),
 ('general', 'can_modify_navigation_panel', '1', 'BoolConfigHandler', 1, 0, ''),
 ('general', 'view_mail_attachs_expanded', '1', 'BoolConfigHandler', 1, 0, ''),
 ('general', 'timeReportShowBilling', '0', 'BoolConfigHandler', 1, 0, ''),
 ('general', 'settings_closed', '0', 'BoolConfigHandler', 1, 0, ''),
 ('contact panel', 'show_inactive_users_in_list', '1', 'BoolConfigHandler', '0', '0', NULL),
 ('general', 'enable_trash_confirmation', '1', 'BoolConfigHandler', 0, 0, ''),
 ('general', 'enable_archive_confirmation', '1', 'BoolConfigHandler', 0, 0, ''),
 ('general', 'trash_objects_in_member_after_delete', '0', 'BoolConfigHandler', 1, 0, ''),
 ('system', 'widget_dimensions', '', 'AllDimensionsConfigHandler', 1, 0, ''),
 ('reporting', 'report_time_colums_display', 'friendly', 'TimeFormatConfigHandler', 0, 1, '');

 INSERT INTO `<?php echo $table_prefix ?>contact_config_options` (`category_name`, `name`, `default_value`, `config_handler_class`, `is_system`, `option_order`, `dev_comment`,`options`)
VALUES ("reporting", "pdf_page_layout", "Portrait", "ListConfigHandler", "0", "0", "",'{"option": [{"value": "Portrait","text": "config_pdf_layout_portrait"},{"value": "Landscape","text": "config_pdf_layout_landscape"}]}'),
('reporting', 'pdf_page_size', 'A4', 'ListConfigHandler', '0', '0','','{"option": [{"value": "A0","text": "config_pdf_size_A0"},{"value": "A1","text": "config_pdf_size_A1"},{"value": "A2","text": "config_pdf_size_A2"},{"value": "A3","text": "config_pdf_size_A3"},{"value": "A4","text": "config_pdf_size_A4"},{"value": "A5","text": "config_pdf_size_A5"},{"value": "Legal","text": "config_pdf_size_legal"},{"value": "Letter","text": "config_pdf_size_letter"}]}');

INSERT INTO `<?php echo $table_prefix ?>contact_config_options` (`category_name`, `name`, `default_value`, `config_handler_class`, `is_system`, `option_order`, `dev_comment`,`options`)
VALUES ("time panel", "automatic_calculation_time", "1", "ListConfigHandler", "0", "0", " ",'{"option": [{"value": "1","text": "config_start_calc"},{"value": "2","text": "config_end_calc"},{"value": "3","text": "always_show_modal"}]}'),
('contact panel', 'properties_for_contact_component', '', 'ContactPropertySelectorConfigHandler', '0', '0','','contact');

INSERT INTO `<?php echo $table_prefix ?>contact_config_options` (`category_name`, `name`, `default_value`, `config_handler_class`, `is_system`, `option_order`, `dev_comment`, `options`) VALUES
('time panel', 'automatic_calculation_start_time', '1', 'ListConfigHandler', '0', '0', ' ', '{"option": [{"value": "1","text": "config_dates_calc"},{"value": "2","text": "config_hours_calc"},{"value": "3","text": "always_show_modal"}]}');

INSERT INTO `<?php echo $table_prefix ?>contact_config_options` (`category_name`, `name`, `default_value`, `config_handler_class`, `is_system`, `option_order`, `dev_comment`, `options`) VALUES
('general', 'decimals_separator', '.', 'ListConfigHandler', '0', '0', ' ', '{"option": [{"value": ".","text": "."},{"value": ",","text": ","}]}'),
('general', 'thousand_separator', ',', 'ListConfigHandler', '0', '0', ' ', '{"option": [{"value": ".","text": "."},{"value": ",","text": ","}]}'),
('general', 'decimal_digits', '2', 'IntegerConfigHandler', '0', '0', ' ', '');

INSERT INTO `<?php echo $table_prefix ?>object_types` (`name`,`handler_class`,`table_name`,`type`,`icon`,`plugin_id`) VALUES
 ('workspace', 'Workspaces', 'workspaces', 'dimension_object', 'workspace', 0),
 ('tag', '', '', 'dimension_group', 'tag', 0),
 ('message', 'ProjectMessages', 'project_messages', 'content_object', 'message', 0),
 ('weblink', 'ProjectWebpages', 'project_webpages', 'content_object', 'weblink', 0),
 ('task', 'ProjectTasks', 'project_tasks', 'content_object', 'task', 0),
 ('file', 'ProjectFiles', 'project_files', 'content_object', 'file', 0),
 ('form', 'ProjectForms', 'project_forms', '', '', 0),
 ('chart', 'ProjectCharts', 'project_charts', '', '', 0),
 ('milestone', 'ProjectMilestones', 'project_milestones', 'content_object', 'milestone', 0),
 ('event', 'ProjectEvents', 'project_events', 'content_object', 'event', 0), 
 ('report', 'Reports', 'reports', 'located', 'reporting', 0),
 ('template', 'COTemplates', 'templates', 'located', 'template', 0),
 ('comment', 'Comments', 'comments', 'comment', 'comment', 0), 
 ('billing', 'Billings', 'billings', '', '', 0),
 ('contact', 'Contacts', 'contacts', 'content_object', 'contact', 0),
 ('file revision', 'ProjectFileRevisions', 'project_file_revisions', 'content_object', 'file', 0),
 ('timeslot', 'Timeslots', 'timeslots', 'located', 'time', 0),
 ('template_task', 'TemplateTasks', 'template_tasks', 'content_object', 'task', 0),
 ('template_milestone', 'TemplateMilestones', 'template_milestones', 'content_object', 'milestone', 0);

UPDATE `<?php echo $table_prefix ?>contact_config_options` 
SET `options`='{"no_empty_value":1, "option": [{"value": "1","text": "config_allow_stop_timer"},{"value": "2","text": "config_allow_pause_timer"},{"value": "3","text": "config_let_timer_continue"}]}'
WHERE `name`='stop_running_timeslots';

INSERT INTO `<?php echo $table_prefix ?>address_types` (`name`,`is_system`) VALUES
 ('home', 1),
 ('work', 1),
 ('other', 1),
 ('postal', '1');

INSERT INTO `<?php echo $table_prefix ?>telephone_types` (`name`,`is_system`) VALUES
 ('home', 1),
 ('work', 1),
 ('other', 1),
 ('assistant', 0),
 ('callback', 0),
 ('mobile', 1),
 ('pager', 0),
 ('fax', 0);

INSERT INTO `<?php echo $table_prefix ?>email_types` (`name`,`is_system`) VALUES
 ('user',1),
 ('personal', 1),
 ('work', 1),
 ('other', 1);
 
INSERT INTO `<?php echo $table_prefix ?>webpage_types` (`name`,`is_system`) VALUES
 ('personal', 1),
 ('work', 1),
 ('other', 1);


INSERT INTO `<?php echo $table_prefix ?>tab_panels` (`id`,`title`,`icon_cls`,`refresh_on_context_change`,`default_controller`,`default_action`,`initial_controller`,`initial_action`,`enabled`,`type`,`ordering`,`plugin_id`,`object_type_id`) VALUES 
 ('calendar-panel','calendar','ico-calendar',1,'event','view_calendar','','',0,'system',7,0,(SELECT id FROM <?php echo $table_prefix ?>object_types WHERE name='event')),
 ('contacts-panel','contacts','ico-contacts',1,'contact','init','','',0,'system',4,0,(SELECT id FROM <?php echo $table_prefix ?>object_types WHERE name='contact')),
 ('documents-panel','documents','ico-documents',1,'files','init','','',1,'system',3,0,(SELECT id FROM <?php echo $table_prefix ?>object_types WHERE name='file')),
 ('messages-panel','messages','ico-messages',1,'message','init','','',0,'system',10,0,(SELECT id FROM <?php echo $table_prefix ?>object_types WHERE name='message')),
 ('overview-panel','overview','ico-overview',1,'dashboard','main_dashboard','dashboard','main_dashboard',1,'system',1,0,0),
 ('reporting-panel','reporting','ico-reporting',1,'reporting','index','','',1,'system',8,0,(SELECT id FROM <?php echo $table_prefix ?>object_types WHERE name='report')),
 ('tasks-panel','tasks','ico-tasks',1,'task','new_list_tasks','','',1,'system',2,0,(SELECT id FROM <?php echo $table_prefix ?>object_types WHERE name='task')),
 ('time-panel','time','ico-time-layout',1,'time','index','','',1,'system',5,0,0),
 ('webpages-panel','web pages','ico-webpages',1,'webpage','init','','',0,'system',9,0,(SELECT id FROM <?php echo $table_prefix ?>object_types WHERE name='weblink')),
 ('more-panel','getting started','ico-more-tab',0,'more','index','','',1,'system',100,0,0);



INSERT INTO `<?php echo $table_prefix ?>permission_groups` (`name`, `contact_id`, `is_context`, `plugin_id`, `type`) VALUES
('Super Administrator',	0,	0,	0, 'roles'),
('Administrator',	0,	0,	0, 'roles'),
('Manager',	0,	0,	0, 'roles'),
('Executive',	0,	0,	0, 'roles'),
('Collaborator Customer',	0,	0,	0, 'roles'),
('Internal Collaborator',	0,	0,	0, 'roles'),
('External Collaborator',	0,	0,	0, 'roles'),
('ExecutiveGroup',	0,	0,	0, 'roles'),
('CollaboratorGroup',	0,	0,	0, 'roles'),
('GuestGroup',	0,	0,	0, 'roles'),
('Guest Customer',	0,	0,	0, 'roles'),
('Guest',	0,	0,	0, 'roles'),
('Non-Exec Director',	0,	0,	0, 'roles');

SET @exegroup := (SELECT pg.id FROM <?php echo $table_prefix ?>permission_groups pg WHERE pg.name = 'ExecutiveGroup');
SET @colgroup := (SELECT pg.id FROM <?php echo $table_prefix ?>permission_groups pg WHERE pg.name = 'CollaboratorGroup');
SET @guegroup := (SELECT pg.id FROM <?php echo $table_prefix ?>permission_groups pg WHERE pg.name = 'GuestGroup');
UPDATE `<?php echo $table_prefix ?>permission_groups` SET `parent_id` = (@exegroup) WHERE `name` IN ('Super Administrator','Administrator','Manager','Executive');
UPDATE `<?php echo $table_prefix ?>permission_groups` SET `parent_id` = (@colgroup) WHERE `name` IN ('Collaborator Customer','Internal Collaborator','External Collaborator');
UPDATE `<?php echo $table_prefix ?>permission_groups` SET `parent_id` = (@guegroup) WHERE `name` IN ('Guest Customer','Guest','Non-Exec Director');

INSERT INTO `<?php echo $table_prefix ?>tab_panel_permissions` (`permission_group_id`, `tab_panel_id`) VALUES 
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Super Administrator'),	'calendar-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Super Administrator'),	'documents-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Super Administrator'),	'mails-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Super Administrator'),	'messages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Super Administrator'),	'overview-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Super Administrator'),	'tasks-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Super Administrator'),	'time-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Super Administrator'),	'webpages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Super Administrator'),	'contacts-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Super Administrator'),	'reporting-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Super Administrator'),	'more-panel'),

((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Administrator'),	'calendar-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Administrator'),	'documents-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Administrator'),	'mails-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Administrator'),	'messages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Administrator'),	'overview-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Administrator'),	'tasks-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Administrator'),	'time-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Administrator'),	'webpages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Administrator'),	'contacts-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Administrator'),	'reporting-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Administrator'),	'more-panel'),

((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Manager'),	'calendar-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Manager'),	'documents-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Manager'),	'mails-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Manager'),	'messages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Manager'),	'overview-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Manager'),	'tasks-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Manager'),	'time-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Manager'),	'webpages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Manager'),	'contacts-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Manager'),	'reporting-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Manager'),	'more-panel'),

((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Executive'),	'calendar-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Executive'),	'documents-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Executive'),	'mails-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Executive'),	'messages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Executive'),	'overview-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Executive'),	'tasks-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Executive'),	'time-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Executive'),	'webpages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Executive'),	'contacts-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Executive'),	'reporting-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Executive'),	'more-panel'),

((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Collaborator Customer'),	'calendar-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Collaborator Customer'),	'documents-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Collaborator Customer'),	'messages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Collaborator Customer'),	'overview-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Collaborator Customer'),	'tasks-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Collaborator Customer'),	'time-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Collaborator Customer'),	'webpages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Collaborator Customer'),	'contacts-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Collaborator Customer'),	'reporting-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Collaborator Customer'),	'more-panel'),

((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Internal Collaborator'),	'calendar-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Internal Collaborator'),	'documents-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Internal Collaborator'),	'messages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Internal Collaborator'),	'overview-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Internal Collaborator'),	'tasks-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Internal Collaborator'),	'time-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Internal Collaborator'),	'webpages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Internal Collaborator'),	'more-panel'),

((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'External Collaborator'),	'calendar-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'External Collaborator'),	'documents-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'External Collaborator'),	'messages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'External Collaborator'),	'overview-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'External Collaborator'),	'tasks-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'External Collaborator'),	'time-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'External Collaborator'),	'webpages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'External Collaborator'),	'more-panel'),

((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Guest Customer'),	'overview-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Guest Customer'),	'calendar-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Guest Customer'),	'documents-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Guest Customer'),	'messages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Guest Customer'),	'webpages-panel'),

((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Guest'),	'overview-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Guest'),	'calendar-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Guest'),	'messages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Guest'),	'webpages-panel'),

((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Non-Exec Director'),	'calendar-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Non-Exec Director'),	'documents-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Non-Exec Director'),	'messages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Non-Exec Director'),	'overview-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Non-Exec Director'),	'tasks-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Non-Exec Director'),	'time-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Non-Exec Director'),	'webpages-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Non-Exec Director'),	'contacts-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Non-Exec Director'),	'reporting-panel'),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Non-Exec Director'),	'more-panel');


INSERT INTO `<?php echo $table_prefix ?>system_permissions` (`permission_group_id`, `can_manage_security`, `can_manage_configuration`, `can_manage_templates`, `can_manage_time`, `can_add_mail_accounts`, `can_manage_dimensions`, `can_manage_dimension_members`, `can_manage_tasks`, `can_task_assignee`, `can_manage_billing`, `can_view_billing`, `can_see_assigned_to_other_tasks`, `can_manage_contacts`, `can_update_other_users_invitations`, `can_link_objects`, `can_instantiate_templates`, `can_manage_repetitive_properties_of_tasks`, `can_see_others_timeslots`, `can_reopen_task`) VALUES
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Super Administrator'),	1,	1,	1,	1,	1,		1,	1,	1,	1,	1,	1,	1, 1, 1, 1, 1, 1, 1, 1),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Administrator'),	1,	1,	1,	1,	1,		1,	1,	1,	1,	1,	1,	1, 0, 1, 1, 1, 1, 1, 1),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Manager'),	1,	0,	1,	1,	1,		0,	1,	1,	1,	1,	1,	1, 0, 1, 1, 1, 1, 1, 1),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Executive'),	0,	0,	0,	0,	1,		0,	1,	1,	1,	0,	1,	0, 0, 0, 1, 1, 1, 0, 1),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Collaborator Customer'),	0,	0,	0,	0,	0,		0,	0,	0,	1,	0,	0,	0, 0, 0, 1, 0, 0, 0, 0),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Internal Collaborator'),	0,	0,	0,	0,	0,		0,	0,	0,	1,	0,	0,	0, 0, 0, 1, 0, 0, 0, 0),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'External Collaborator'),	0,	0,	0,	0,	0,		0,	0,	0,	1,	0,	0,	0, 0, 0, 1, 0, 0, 0, 0),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Guest Customer'),	0,	0,	0,	0,	0,		0,	0,	0,	0,	0,	0,	0, 0, 0, 0, 0, 0, 0, 0),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Guest'),	0,	0,	0,	0,	0,		0,	0,	0,	0,	0,	0,	0, 0, 0, 0, 0, 0, 0, 0),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Non-Exec Director'),	0,	0,	0,	0,	0,		0,	0,	0,	0,	0,	1,	1, 0, 0, 0, 0, 0, 1, 0);

INSERT INTO `<?php echo $table_prefix ?>max_system_permissions` (`permission_group_id`, `can_manage_security`, `can_manage_configuration`, `can_manage_templates`, `can_manage_time`, `can_add_mail_accounts`, `can_manage_dimensions`, `can_manage_dimension_members`, `can_manage_tasks`, `can_task_assignee`, `can_manage_billing`, `can_view_billing`, `can_see_assigned_to_other_tasks`, `can_manage_contacts`, `can_update_other_users_invitations`, `can_link_objects`, `can_instantiate_templates`, `can_manage_repetitive_properties_of_tasks`,`can_see_others_timeslots`, `can_reopen_task`) VALUES
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Super Administrator'),	1,	1,	1,	1,	1,		1,	1,	1,	1,	1,	1,	1, 1, 1, 1, 1, 1, 1, 1),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Administrator'),	1,	1,	1,	1,	1,		1,	1,	1,	1,	1,	1,	1, 1, 1, 1, 1, 1, 1, 1),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Manager'),	1,	0,	1,	1,	1,		0,	1,	1,	1,	1,	1,	1, 1, 1, 1, 1, 1, 1, 1),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Executive'),	1,	0,	0,	0,	1,		0,	1,	1,	1,	0,	1,	1, 1, 1, 1, 1, 1, 1, 1),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Collaborator Customer'),	0,	0,	0,	0,	0,		0,	0,	0,	1,	0,	0,	1, 0, 0, 1, 0, 0, 1, 0),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Internal Collaborator'),	0,	0,	0,	0,	0,		0,	0,	0,	1,	0,	0,	0, 0, 0, 1, 0, 0, 0, 1),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'External Collaborator'),	0,	0,	0,	0,	0,		0,	0,	0,	1,	0,	0,	0, 0, 0, 1, 0, 0, 0, 0),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Guest Customer'),	0,	0,	0,	0,	0,		0,	0,	0,	0,	0,	0,	1, 0, 0, 0, 0, 0, 1, 0),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Guest'),	0,	0,	0,	0,	0,		0,	0,	0,	0,	0,	0,	1, 0, 0, 0, 0, 0, 1, 0),
((SELECT id FROM <?php echo $table_prefix ?>permission_groups WHERE name = 'Non-Exec Director'),	0,	0,	0,	0,	0,		0,	0,	0,	0,	0,	1,	1, 0, 0, 0, 0, 0, 1, 0);

INSERT INTO `<?php echo $table_prefix ?>widgets` (`name`,`title`,`plugin_id`,`path`,`default_options`,`default_section`,`default_order`,`icon_cls`) VALUES 
 ('overdue_upcoming','overdue and upcoming',0,'','','left',3,'ico-task'),
 ('people','people',0,'','','right',-1,'ico-contact'),
 ('messages','notes',0,'','','right',1000,'ico-message'),
 ('documents','documents',0,'','','right',1100,'ico-file'),
 ('calendar','upcoming events milestones and tasks',0,'','','top',0,'ico-event'),
 ('completed_tasks_list','completed tasks list',0,'','','right',150,'ico-task'),
 ('activity_feed', 'activity_feed', 0, '', '', 'left', 10,'ico-properties'),
 ('active_context_info','active_context_info',0,'','','left',1,'ico-summary'),
 ('comments','comments',0,'','','left',15,'ico-comment');

INSERT INTO <?php echo $table_prefix ?>role_object_type_permissions (role_id, object_type_id, can_delete, can_write)
 SELECT p.id, o.id, 1, 1
 FROM `<?php echo $table_prefix ?>object_types` o JOIN `<?php echo $table_prefix ?>permission_groups` p
 WHERE o.`name` IN ('message','weblink','file','task','milestone','event','contact','timeslot','report')
 AND p.`name` IN ('Super Administrator','Administrator','Manager');

INSERT INTO <?php echo $table_prefix ?>role_object_type_permissions (role_id, object_type_id, can_delete, can_write)
 SELECT p.id, o.id, 0, 1
 FROM `<?php echo $table_prefix ?>object_types` o JOIN `<?php echo $table_prefix ?>permission_groups` p
 WHERE o.`name` IN ('message','weblink','file','task','milestone','event','contact','timeslot','report')
 AND p.`name` IN ('Executive');

INSERT INTO <?php echo $table_prefix ?>role_object_type_permissions (role_id, object_type_id, can_delete, can_write)
 SELECT p.id, o.id, 0, 1
 FROM `<?php echo $table_prefix ?>object_types` o JOIN `<?php echo $table_prefix ?>permission_groups` p
 WHERE o.`name` IN ('file','timeslot')
 AND p.`name` IN ('Collaborator Customer','Internal Collaborator');

INSERT INTO <?php echo $table_prefix ?>role_object_type_permissions (role_id, object_type_id, can_delete, can_write)
 SELECT p.id, o.id, 0, 0
 FROM `<?php echo $table_prefix ?>object_types` o JOIN `<?php echo $table_prefix ?>permission_groups` p
 WHERE o.`name` IN ('task','milestone','event','report','contact')
 AND p.`name` IN ('Collaborator Customer','Internal Collaborator');

INSERT INTO <?php echo $table_prefix ?>role_object_type_permissions (role_id, object_type_id, can_delete, can_write)
 SELECT p.id, o.id, 0, 1
 FROM `<?php echo $table_prefix ?>object_types` o JOIN `<?php echo $table_prefix ?>permission_groups` p
 WHERE o.`name` IN ('timeslot')
 AND p.`name` IN ('External Collaborator');

INSERT INTO <?php echo $table_prefix ?>role_object_type_permissions (role_id, object_type_id, can_delete, can_write)
 SELECT p.id, o.id, 0, 0
 FROM `<?php echo $table_prefix ?>object_types` o JOIN `<?php echo $table_prefix ?>permission_groups` p
 WHERE o.`name` IN ('task','file','milestone')
 AND p.`name` IN ('External Collaborator');

INSERT INTO <?php echo $table_prefix ?>max_role_object_type_permissions (role_id, object_type_id, can_delete, can_write)
 SELECT p.id, o.id, 1, 1
 FROM `<?php echo $table_prefix ?>object_types` o JOIN `<?php echo $table_prefix ?>permission_groups` p
 WHERE o.`name` IN ('message','weblink','file','task','milestone','event','contact','timeslot','report')
 AND p.`name` IN ('Super Administrator','Administrator','Manager','Executive');

INSERT INTO <?php echo $table_prefix ?>max_role_object_type_permissions (role_id, object_type_id, can_delete, can_write)
 SELECT p.id, o.id, 0, 1
 FROM `<?php echo $table_prefix ?>object_types` o JOIN `<?php echo $table_prefix ?>permission_groups` p
 WHERE o.`name` IN ('message','weblink','file','timeslot','contact','report')
 AND p.`name` IN ('Collaborator Customer','Internal Collaborator','External Collaborator');

INSERT INTO <?php echo $table_prefix ?>max_role_object_type_permissions (role_id, object_type_id, can_delete, can_write)
 SELECT p.id, o.id, 0, 0
 FROM `<?php echo $table_prefix ?>object_types` o JOIN `<?php echo $table_prefix ?>permission_groups` p
 WHERE o.`name` IN ('task','milestone','event')
 AND p.`name` IN ('Collaborator Customer','Internal Collaborator','External Collaborator');

INSERT INTO <?php echo $table_prefix ?>max_role_object_type_permissions (role_id, object_type_id, can_delete, can_write)
 SELECT p.id, o.id, 0, 0
 FROM `<?php echo $table_prefix ?>object_types` o JOIN `<?php echo $table_prefix ?>permission_groups` p
 WHERE o.`name` IN ('message','weblink','file','task','milestone','event','contact','timeslot','report')
 AND p.`name` IN ('Guest Customer','Guest','Non-Exec Director');

INSERT INTO `<?php echo $table_prefix ?>contact_widget_options` (widget_name,contact_id,member_type_id,`option`,`value`,config_handler_class,is_system) VALUES
('overdue_upcoming',0,0,'assigned_to_user',0,'UserCompanyConfigHandler',0),
('calendar',0,0,'filter_by_myself',1,'BooleanConfigHandler',0)
ON DUPLICATE KEY UPDATE widget_name=widget_name;

UPDATE `<?php echo $table_prefix ?>config_options` SET `value`=(
	SELECT GROUP_CONCAT(id) FROM <?php echo $table_prefix ?>permission_groups WHERE `name` IN ('Super Administrator', 'Administrator', 'Manager', 'Executive')
)
WHERE `name`='give_member_permissions_to_new_users';

INSERT INTO `<?php echo $table_prefix ?>currencies` (`symbol`, `name`, `short_name`, `is_default`) VALUES
('$', 'Dollar', 'USD', 0);

INSERT INTO <?php echo $table_prefix ?>custom_properties (`object_type_id`,`name`,`code`,`type`,`visible_by_default`,`is_special`,`description`, `values`, `default_value`) VALUES
((SELECT id FROM <?php echo $table_prefix ?>object_types WHERE name='contact'), 'Job title', 'job_title', 'text', 1, 1, '', '', '');

INSERT INTO <?php echo $table_prefix ?>custom_properties (object_type_id, name, code, `type`,`is_special`,`description`, `values`, `default_value`) VALUES
((SELECT id FROM <?php echo $table_prefix ?>object_types WHERE name='contact'), 'Prefix', 'prefix_code', 'text', 1, '', '', '');


INSERT INTO <?php echo $table_prefix ?>dimension_associations_config (association_id, config_name, value)
	SELECT id, 'autoclassify_in_property_member', '1'
	FROM <?php echo $table_prefix ?>dimension_member_associations WHERE associated_dimension_id NOT IN (SELECT id FROM <?php echo $table_prefix ?>dimensions WHERE code='feng_persons')
ON DUPLICATE KEY UPDATE value=value;

INSERT INTO <?php echo $table_prefix ?>dimension_associations_config (association_id, config_name, value)
	SELECT id, 'allow_remove_from_property_member', '1'
	FROM <?php echo $table_prefix ?>dimension_member_associations WHERE associated_dimension_id NOT IN (SELECT id FROM <?php echo $table_prefix ?>dimensions WHERE code='feng_persons')
ON DUPLICATE KEY UPDATE value=value;


INSERT INTO `<?php echo $table_prefix ?>countries` (`code`, `name`) VALUES
('AF',	'Afghanistan'),
('AX',	'Aland Islands'),
('AL',	'Albania'),
('DZ',	'Algeria'),
('AS',	'American Samoa'),
('AD',	'Andorra'),
('AO',	'Angola'),
('AI',	'Anguilla'),
('AQ',	'Antarctica'),
('AG',	'Antigua and Barbuda'),
('AR',	'Argentina'),
('AM',	'Armenia'),
('AW',	'Aruba'),
('AU',	'Australia'),
('AT',	'Austria'),
('AZ',	'Azerbaijan'),
('BS',	'Bahamas'),
('BH',	'Bahrain'),
('BD',	'Bangladesh'),
('BB',	'Barbados'),
('BY',	'Belarus'),
('BE',	'Belgium'),
('BZ',	'Belize'),
('BJ',	'Benin'),
('BM',	'Bermuda'),
('BT',	'Bhutan'),
('BO',	'Bolivia'),
('BQ',	'Bonaire, Saint Eustatius and Saba '),
('BA',	'Bosnia and Herzegovina'),
('BW',	'Botswana'),
('BV',	'Bouvet Island'),
('BR',	'Brazil'),
('IO',	'British Indian Ocean Territory'),
('VG',	'British Virgin Islands'),
('BN',	'Brunei'),
('BG',	'Bulgaria'),
('BF',	'Burkina Faso'),
('BI',	'Burundi'),
('KH',	'Cambodia'),
('CM',	'Cameroon'),
('CA',	'Canada'),
('CV',	'Cape Verde'),
('KY',	'Cayman Islands'),
('CF',	'Central African Republic'),
('TD',	'Chad'),
('CL',	'Chile'),
('CN',	'China'),
('CX',	'Christmas Island'),
('CC',	'Cocos Islands'),
('CO',	'Colombia'),
('KM',	'Comoros'),
('CK',	'Cook Islands'),
('CR',	'Costa Rica'),
('HR',	'Croatia'),
('CU',	'Cuba'),
('CW',	'Cura├ºao'),
('CY',	'Cyprus'),
('CZ',	'Czech Republic'),
('CD',	'Democratic Republic of the Congo'),
('DK',	'Denmark'),
('DJ',	'Djibouti'),
('DM',	'Dominica'),
('DO',	'Dominican Republic'),
('TL',	'East Timor'),
('EC',	'Ecuador'),
('EG',	'Egypt'),
('SV',	'El Salvador'),
('GQ',	'Equatorial Guinea'),
('ER',	'Eritrea'),
('EE',	'Estonia'),
('ET',	'Ethiopia'),
('FK',	'Falkland Islands'),
('FO',	'Faroe Islands'),
('FJ',	'Fiji'),
('FI',	'Finland'),
('FR',	'France'),
('GF',	'French Guiana'),
('PF',	'French Polynesia'),
('TF',	'French Southern Territories'),
('GA',	'Gabon'),
('GM',	'Gambia'),
('GE',	'Georgia'),
('DE',	'Germany'),
('GH',	'Ghana'),
('GI',	'Gibraltar'),
('GR',	'Greece'),
('GL',	'Greenland'),
('GD',	'Grenada'),
('GP',	'Guadeloupe'),
('GU',	'Guam'),
('GT',	'Guatemala'),
('GG',	'Guernsey'),
('GN',	'Guinea'),
('GW',	'Guinea-Bissau'),
('GY',	'Guyana'),
('HT',	'Haiti'),
('HM',	'Heard Island and McDonald Islands'),
('HN',	'Honduras'),
('HK',	'Hong Kong'),
('HU',	'Hungary'),
('IS',	'Iceland'),
('IN',	'India'),
('ID',	'Indonesia'),
('IR',	'Iran'),
('IQ',	'Iraq'),
('IE',	'Ireland'),
('IM',	'Isle of Man'),
('IL',	'Israel'),
('IT',	'Italy'),
('CI',	'Ivory Coast'),
('JM',	'Jamaica'),
('JP',	'Japan'),
('JE',	'Jersey'),
('JO',	'Jordan'),
('KZ',	'Kazakhstan'),
('KE',	'Kenya'),
('KI',	'Kiribati'),
('XK',	'Kosovo'),
('KW',	'Kuwait'),
('KG',	'Kyrgyzstan'),
('LA',	'Laos'),
('LV',	'Latvia'),
('LB',	'Lebanon'),
('LS',	'Lesotho'),
('LR',	'Liberia'),
('LY',	'Libya'),
('LI',	'Liechtenstein'),
('LT',	'Lithuania'),
('LU',	'Luxembourg'),
('MO',	'Macao'),
('MK',	'Macedonia'),
('MG',	'Madagascar'),
('MW',	'Malawi'),
('MY',	'Malaysia'),
('MV',	'Maldives'),
('ML',	'Mali'),
('MT',	'Malta'),
('MH',	'Marshall Islands'),
('MQ',	'Martinique'),
('MR',	'Mauritania'),
('MU',	'Mauritius'),
('YT',	'Mayotte'),
('MX',	'Mexico'),
('FM',	'Micronesia'),
('MD',	'Moldova'),
('MC',	'Monaco'),
('MN',	'Mongolia'),
('ME',	'Montenegro'),
('MS',	'Montserrat'),
('MA',	'Morocco'),
('MZ',	'Mozambique'),
('MM',	'Myanmar'),
('NA',	'Namibia'),
('NR',	'Nauru'),
('NP',	'Nepal'),
('NL',	'Netherlands'),
('AN',	'Netherlands Antilles'),
('NC',	'New Caledonia'),
('NZ',	'New Zealand'),
('NI',	'Nicaragua'),
('NE',	'Niger'),
('NG',	'Nigeria'),
('NU',	'Niue'),
('NF',	'Norfolk Island'),
('KP',	'North Korea'),
('MP',	'Northern Mariana Islands'),
('NO',	'Norway'),
('OM',	'Oman'),
('PK',	'Pakistan'),
('PW',	'Palau'),
('PS',	'Palestinian Territory'),
('PA',	'Panama'),
('PG',	'Papua New Guinea'),
('PY',	'Paraguay'),
('PE',	'Peru'),
('PH',	'Philippines'),
('PN',	'Pitcairn'),
('PL',	'Poland'),
('PT',	'Portugal'),
('PR',	'Puerto Rico'),
('QA',	'Qatar'),
('CG',	'Republic of the Congo'),
('RE',	'Reunion'),
('RO',	'Romania'),
('RU',	'Russia'),
('RW',	'Rwanda'),
('BL',	'Saint Barth├®lemy'),
('SH',	'Saint Helena'),
('KN',	'Saint Kitts and Nevis'),
('LC',	'Saint Lucia'),
('MF',	'Saint Martin'),
('PM',	'Saint Pierre and Miquelon'),
('VC',	'Saint Vincent and the Grenadines'),
('WS',	'Samoa'),
('SM',	'San Marino'),
('ST',	'Sao Tome and Principe'),
('SA',	'Saudi Arabia'),
('SN',	'Senegal'),
('RS',	'Serbia'),
('CS',	'Serbia and Montenegro'),
('SC',	'Seychelles'),
('SL',	'Sierra Leone'),
('SG',	'Singapore'),
('SX',	'Sint Maarten'),
('SK',	'Slovakia'),
('SI',	'Slovenia'),
('SB',	'Solomon Islands'),
('SO',	'Somalia'),
('ZA',	'South Africa'),
('GS',	'South Georgia and the South Sandwich Islands'),
('KR',	'South Korea'),
('SS',	'South Sudan'),
('ES',	'Spain'),
('LK',	'Sri Lanka'),
('SD',	'Sudan'),
('SR',	'Suriname'),
('SJ',	'Svalbard and Jan Mayen'),
('SZ',	'Swaziland'),
('SE',	'Sweden'),
('CH',	'Switzerland'),
('SY',	'Syria'),
('TW',	'Taiwan'),
('TJ',	'Tajikistan'),
('TZ',	'Tanzania'),
('TH',	'Thailand'),
('TG',	'Togo'),
('TK',	'Tokelau'),
('TO',	'Tonga'),
('TT',	'Trinidad and Tobago'),
('TN',	'Tunisia'),
('TR',	'Turkey'),
('TM',	'Turkmenistan'),
('TC',	'Turks and Caicos Islands'),
('TV',	'Tuvalu'),
('VI',	'U.S. Virgin Islands'),
('UG',	'Uganda'),
('UA',	'Ukraine'),
('AE',	'United Arab Emirates'),
('GB',	'United Kingdom'),
('US',	'United States'),
('UM',	'United States Minor Outlying Islands'),
('UY',	'Uruguay'),
('UZ',	'Uzbekistan'),
('VU',	'Vanuatu'),
('VA',	'Vatican'),
('VE',	'Venezuela'),
('VN',	'Vietnam'),
('WF',	'Wallis and Futuna'),
('EH',	'Western Sahara'),
('YE',	'Yemen'),
('ZM',	'Zambia'),
('ZW',	'Zimbabwe');


INSERT INTO `<?php echo $table_prefix ?>timezones` (`id`, `country_code`, `name`, `has_dst`, `gmt_offset`, `gmt_dst_offset`, `using_dst`) VALUES
(1,	'AD',	'Europe/Andorra',	1,	3600,	7200,	0),
(2,	'AE',	'Asia/Dubai',	0,	14400,	14400,	0),
(3,	'AF',	'Asia/Kabul',	0,	16200,	16200,	0),
(4,	'AG',	'America/Antigua',	0,	-14400,	-14400,	0),
(5,	'AI',	'America/Anguilla',	0,	-14400,	-14400,	0),
(6,	'AL',	'Europe/Tirane',	1,	3600,	7200,	0),
(7,	'AM',	'Asia/Yerevan',	0,	14400,	18000,	0),
(8,	'AO',	'Africa/Luanda',	0,	3600,	3600,	0),
(9,	'AQ',	'Antarctica/McMurdo',	1,	43200,	46800,	1),
(10,	'AQ',	'Antarctica/Casey',	0,	28800,	28800,	0),
(11,	'AQ',	'Antarctica/Davis',	0,	25200,	25200,	0),
(12,	'AQ',	'Antarctica/DumontDUrville',	0,	36000,	36000,	0),
(13,	'AQ',	'Antarctica/Mawson',	0,	18000,	18000,	0),
(14,	'AQ',	'Antarctica/Palmer',	1,	-14400,	-10800,	1),
(15,	'AQ',	'Antarctica/Rothera',	0,	-10800,	-10800,	0),
(16,	'AQ',	'Antarctica/Syowa',	0,	10800,	10800,	0),
(17,	'AQ',	'Antarctica/Troll',	0,	0,	7200,	0),
(18,	'AQ',	'Antarctica/Vostok',	0,	21600,	21600,	0),
(19,	'AR',	'America/Argentina/Buenos_Aires',	0,	-10800,	-7200,	0),
(20,	'AR',	'America/Argentina/Cordoba',	0,	-10800,	-7200,	0),
(21,	'AR',	'America/Argentina/Salta',	0,	-10800,	-7200,	0),
(22,	'AR',	'America/Argentina/Jujuy',	0,	-10800,	-7200,	0),
(23,	'AR',	'America/Argentina/Tucuman',	0,	-10800,	-7200,	0),
(24,	'AR',	'America/Argentina/Catamarca',	0,	-10800,	-7200,	0),
(25,	'AR',	'America/Argentina/La_Rioja',	0,	-10800,	-7200,	0),
(26,	'AR',	'America/Argentina/San_Juan',	0,	-10800,	-7200,	0),
(27,	'AR',	'America/Argentina/Mendoza',	0,	-10800,	-7200,	0),
(28,	'AR',	'America/Argentina/San_Luis',	0,	-10800,	-10800,	0),
(29,	'AR',	'America/Argentina/Rio_Gallegos',	0,	-10800,	-7200,	0),
(30,	'AR',	'America/Argentina/Ushuaia',	0,	-10800,	-7200,	0),
(31,	'AS',	'Pacific/Pago_Pago',	0,	-39600,	-39600,	0),
(32,	'AT',	'Europe/Vienna',	1,	3600,	7200,	0),
(33,	'AU',	'Australia/Lord_Howe',	1,	37800,	39600,	1),
(34,	'AU',	'Antarctica/Macquarie',	0,	39600,	39600,	0),
(35,	'AU',	'Australia/Hobart',	1,	36000,	39600,	1),
(36,	'AU',	'Australia/Currie',	1,	36000,	39600,	1),
(37,	'AU',	'Australia/Melbourne',	1,	36000,	39600,	1),
(38,	'AU',	'Australia/Sydney',	1,	36000,	39600,	1),
(39,	'AU',	'Australia/Broken_Hill',	1,	34200,	37800,	1),
(40,	'AU',	'Australia/Brisbane',	0,	36000,	39600,	0),
(41,	'AU',	'Australia/Lindeman',	0,	36000,	39600,	0),
(42,	'AU',	'Australia/Adelaide',	1,	34200,	37800,	1),
(43,	'AU',	'Australia/Darwin',	0,	34200,	37800,	0),
(44,	'AU',	'Australia/Perth',	0,	28800,	32400,	0),
(45,	'AU',	'Australia/Eucla',	0,	31500,	35100,	0),
(46,	'AW',	'America/Aruba',	0,	-14400,	-14400,	0),
(47,	'AX',	'Europe/Mariehamn',	1,	7200,	10800,	0),
(48,	'AZ',	'Asia/Baku',	1,	14400,	18000,	0),
(49,	'BA',	'Europe/Sarajevo',	1,	3600,	7200,	0),
(50,	'BB',	'America/Barbados',	0,	-14400,	-10800,	0),
(51,	'BD',	'Asia/Dhaka',	0,	21600,	25200,	0),
(52,	'BE',	'Europe/Brussels',	1,	3600,	7200,	0),
(53,	'BF',	'Africa/Ouagadougou',	0,	0,	0,	0),
(54,	'BG',	'Europe/Sofia',	1,	7200,	10800,	0),
(55,	'BH',	'Asia/Bahrain',	0,	10800,	10800,	0),
(56,	'BI',	'Africa/Bujumbura',	0,	7200,	7200,	0),
(57,	'BJ',	'Africa/Porto-Novo',	0,	3600,	3600,	0),
(58,	'BL',	'America/St_Barthelemy',	0,	-14400,	-14400,	0),
(59,	'BM',	'Atlantic/Bermuda',	1,	-14400,	-10800,	0),
(60,	'BN',	'Asia/Brunei',	0,	28800,	28800,	0),
(61,	'BO',	'America/La_Paz',	0,	-14400,	-12756,	0),
(62,	'BQ',	'America/Kralendijk',	0,	-14400,	-14400,	0),
(63,	'BR',	'America/Noronha',	0,	-7200,	-3600,	0),
(64,	'BR',	'America/Belem',	0,	-10800,	-7200,	0),
(65,	'BR',	'America/Fortaleza',	0,	-10800,	-7200,	0),
(66,	'BR',	'America/Recife',	0,	-10800,	-7200,	0),
(67,	'BR',	'America/Araguaina',	1,	-10800,	-7200,	0),
(68,	'BR',	'America/Maceio',	0,	-10800,	-7200,	0),
(69,	'BR',	'America/Bahia',	0,	-10800,	-7200,	0),
(70,	'BR',	'America/Sao_Paulo',	1,	-10800,	-7200,	1),
(71,	'BR',	'America/Campo_Grande',	1,	-14400,	-10800,	1),
(72,	'BR',	'America/Cuiaba',	1,	-14400,	-10800,	1),
(73,	'BR',	'America/Santarem',	0,	-10800,	-10800,	0),
(74,	'BR',	'America/Porto_Velho',	0,	-14400,	-10800,	0),
(75,	'BR',	'America/Boa_Vista',	0,	-14400,	-10800,	0),
(76,	'BR',	'America/Manaus',	0,	-14400,	-10800,	0),
(77,	'BR',	'America/Eirunepe',	0,	-18000,	-14400,	0),
(78,	'BR',	'America/Rio_Branco',	0,	-18000,	-14400,	0),
(79,	'BS',	'America/Nassau',	1,	-18000,	-14400,	0),
(80,	'BT',	'Asia/Thimphu',	0,	21600,	21600,	0),
(81,	'BW',	'Africa/Gaborone',	0,	7200,	7200,	0),
(82,	'BY',	'Europe/Minsk',	0,	10800,	10800,	0),
(83,	'BZ',	'America/Belize',	0,	-21600,	-18000,	0),
(84,	'CA',	'America/St_Johns',	1,	-12600,	-9000,	0),
(85,	'CA',	'America/Halifax',	1,	-14400,	-10800,	0),
(86,	'CA',	'America/Glace_Bay',	1,	-14400,	-10800,	0),
(87,	'CA',	'America/Moncton',	1,	-14400,	-10800,	0),
(88,	'CA',	'America/Goose_Bay',	1,	-14400,	-10800,	0),
(89,	'CA',	'America/Blanc-Sablon',	0,	-14400,	-10800,	0),
(90,	'CA',	'America/Toronto',	1,	-18000,	-14400,	0),
(91,	'CA',	'America/Nipigon',	1,	-18000,	-14400,	0),
(92,	'CA',	'America/Thunder_Bay',	1,	-18000,	-14400,	0),
(93,	'CA',	'America/Iqaluit',	1,	-18000,	-14400,	0),
(94,	'CA',	'America/Pangnirtung',	1,	-18000,	-14400,	0),
(95,	'CA',	'America/Atikokan',	0,	-18000,	-18000,	0),
(96,	'CA',	'America/Winnipeg',	1,	-21600,	-18000,	0),
(97,	'CA',	'America/Rainy_River',	1,	-21600,	-18000,	0),
(98,	'CA',	'America/Resolute',	1,	-21600,	-18000,	0),
(99,	'CA',	'America/Rankin_Inlet',	1,	-21600,	-18000,	0),
(100,	'CA',	'America/Regina',	0,	-21600,	-21600,	0),
(101,	'CA',	'America/Swift_Current',	0,	-21600,	-21600,	0),
(102,	'CA',	'America/Edmonton',	1,	-25200,	-21600,	0),
(103,	'CA',	'America/Cambridge_Bay',	1,	-25200,	-21600,	0),
(104,	'CA',	'America/Yellowknife',	1,	-25200,	-21600,	0),
(105,	'CA',	'America/Inuvik',	1,	-25200,	-21600,	0),
(106,	'CA',	'America/Creston',	0,	-25200,	-25200,	0),
(107,	'CA',	'America/Dawson_Creek',	0,	-25200,	-25200,	0),
(108,	'CA',	'America/Fort_Nelson',	1,	-25200,	-25200,	0),
(109,	'CA',	'America/Vancouver',	1,	-28800,	-25200,	0),
(110,	'CA',	'America/Whitehorse',	1,	-28800,	-25200,	0),
(111,	'CA',	'America/Dawson',	1,	-28800,	-25200,	0),
(112,	'CC',	'Indian/Cocos',	0,	23400,	23400,	0),
(113,	'CD',	'Africa/Kinshasa',	0,	3600,	3600,	0),
(114,	'CD',	'Africa/Lubumbashi',	0,	7200,	7200,	0),
(115,	'CF',	'Africa/Bangui',	0,	3600,	3600,	0),
(116,	'CG',	'Africa/Brazzaville',	0,	3600,	3600,	0),
(117,	'CH',	'Europe/Zurich',	1,	3600,	7200,	0),
(118,	'CI',	'Africa/Abidjan',	0,	0,	0,	0),
(119,	'CK',	'Pacific/Rarotonga',	0,	-36000,	-34200,	0),
(120,	'CL',	'America/Santiago',	1,	-14400,	-10800,	1),
(121,	'CL',	'Pacific/Easter',	1,	-21600,	-18000,	1),
(122,	'CM',	'Africa/Douala',	0,	3600,	3600,	0),
(123,	'CN',	'Asia/Shanghai',	0,	28800,	32400,	0),
(124,	'CN',	'Asia/Urumqi',	0,	21600,	21600,	0),
(125,	'CO',	'America/Bogota',	0,	-18000,	-14400,	0),
(126,	'CR',	'America/Costa_Rica',	0,	-21600,	-18000,	0),
(127,	'CU',	'America/Havana',	1,	-18000,	-14400,	0),
(128,	'CV',	'Atlantic/Cape_Verde',	0,	-3600,	-3600,	0),
(129,	'CW',	'America/Curacao',	0,	-14400,	-14400,	0),
(130,	'CX',	'Indian/Christmas',	0,	25200,	25200,	0),
(131,	'CY',	'Asia/Nicosia',	1,	7200,	10800,	0),
(132,	'CZ',	'Europe/Prague',	1,	3600,	7200,	0),
(133,	'DE',	'Europe/Berlin',	1,	3600,	7200,	0),
(134,	'DE',	'Europe/Busingen',	1,	3600,	7200,	0),
(135,	'DJ',	'Africa/Djibouti',	0,	10800,	10800,	0),
(136,	'DK',	'Europe/Copenhagen',	1,	3600,	7200,	0),
(137,	'DM',	'America/Dominica',	0,	-14400,	-14400,	0),
(138,	'DO',	'America/Santo_Domingo',	0,	-14400,	-16200,	0),
(139,	'DZ',	'Africa/Algiers',	0,	3600,	3600,	0),
(140,	'EC',	'America/Guayaquil',	0,	-18000,	-18000,	0),
(141,	'EC',	'Pacific/Galapagos',	0,	-21600,	-21600,	0),
(142,	'EE',	'Europe/Tallinn',	1,	7200,	10800,	0),
(143,	'EG',	'Africa/Cairo',	1,	7200,	10800,	0),
(144,	'EH',	'Africa/El_Aaiun',	1,	0,	3600,	0),
(145,	'ER',	'Africa/Asmara',	0,	10800,	10800,	0),
(146,	'ES',	'Europe/Madrid',	1,	3600,	7200,	0),
(147,	'ES',	'Africa/Ceuta',	1,	3600,	7200,	0),
(148,	'ES',	'Atlantic/Canary',	1,	0,	3600,	0),
(149,	'ET',	'Africa/Addis_Ababa',	0,	10800,	10800,	0),
(150,	'FI',	'Europe/Helsinki',	1,	7200,	10800,	0),
(151,	'FJ',	'Pacific/Fiji',	1,	43200,	46800,	1),
(152,	'FK',	'Atlantic/Stanley',	0,	-10800,	-10800,	0),
(153,	'FM',	'Pacific/Chuuk',	0,	36000,	36000,	0),
(154,	'FM',	'Pacific/Pohnpei',	0,	39600,	39600,	0),
(155,	'FM',	'Pacific/Kosrae',	0,	39600,	39600,	0),
(156,	'FO',	'Atlantic/Faroe',	1,	0,	3600,	0),
(157,	'FR',	'Europe/Paris',	1,	3600,	7200,	0),
(158,	'GA',	'Africa/Libreville',	0,	3600,	3600,	0),
(159,	'GB',	'Europe/London',	1,	0,	3600,	1),
(160,	'GD',	'America/Grenada',	0,	-14400,	-14400,	0),
(161,	'GE',	'Asia/Tbilisi',	0,	14400,	14400,	0),
(162,	'GF',	'America/Cayenne',	0,	-10800,	-10800,	0),
(163,	'GG',	'Europe/Guernsey',	1,	0,	3600,	0),
(164,	'GH',	'Africa/Accra',	0,	0,	1200,	0),
(165,	'GI',	'Europe/Gibraltar',	1,	3600,	7200,	0),
(166,	'GL',	'America/Godthab',	1,	-10800,	-7200,	0),
(167,	'GL',	'America/Danmarkshavn',	0,	0,	-7200,	0),
(168,	'GL',	'America/Scoresbysund',	1,	-3600,	0,	0),
(169,	'GL',	'America/Thule',	1,	-14400,	-10800,	0),
(170,	'GM',	'Africa/Banjul',	0,	0,	0,	0),
(171,	'GN',	'Africa/Conakry',	0,	0,	0,	0),
(172,	'GP',	'America/Guadeloupe',	0,	-14400,	-14400,	0),
(173,	'GQ',	'Africa/Malabo',	0,	3600,	3600,	0),
(174,	'GR',	'Europe/Athens',	1,	7200,	10800,	0),
(175,	'GS',	'Atlantic/South_Georgia',	0,	-7200,	-7200,	0),
(176,	'GT',	'America/Guatemala',	0,	-21600,	-18000,	0),
(177,	'GU',	'Pacific/Guam',	0,	36000,	36000,	0),
(178,	'GW',	'Africa/Bissau',	0,	0,	0,	0),
(179,	'GY',	'America/Guyana',	0,	-14400,	-14400,	0),
(180,	'HK',	'Asia/Hong_Kong',	0,	28800,	32400,	0),
(181,	'HN',	'America/Tegucigalpa',	0,	-21600,	-18000,	0),
(182,	'HR',	'Europe/Zagreb',	1,	3600,	7200,	0),
(183,	'HT',	'America/Port-au-Prince',	1,	-18000,	-14400,	0),
(184,	'HU',	'Europe/Budapest',	1,	3600,	7200,	0),
(185,	'ID',	'Asia/Jakarta',	0,	25200,	25200,	0),
(186,	'ID',	'Asia/Pontianak',	0,	25200,	25200,	0),
(187,	'ID',	'Asia/Makassar',	0,	28800,	28800,	0),
(188,	'ID',	'Asia/Jayapura',	0,	32400,	32400,	0),
(189,	'IE',	'Europe/Dublin',	1,	0,	3600,	0),
(190,	'IL',	'Asia/Jerusalem',	1,	7200,	10800,	0),
(191,	'IM',	'Europe/Isle_of_Man',	1,	0,	3600,	0),
(192,	'IN',	'Asia/Kolkata',	0,	19800,	23400,	0),
(193,	'IO',	'Indian/Chagos',	0,	21600,	21600,	0),
(194,	'IQ',	'Asia/Baghdad',	0,	10800,	14400,	0),
(195,	'IR',	'Asia/Tehran',	1,	12600,	16200,	0),
(196,	'IS',	'Atlantic/Reykjavik',	0,	0,	0,	0),
(197,	'IT',	'Europe/Rome',	1,	3600,	7200,	0),
(198,	'JE',	'Europe/Jersey',	1,	0,	3600,	0),
(199,	'JM',	'America/Jamaica',	0,	-18000,	-14400,	0),
(200,	'JO',	'Asia/Amman',	1,	7200,	10800,	0),
(201,	'JP',	'Asia/Tokyo',	0,	32400,	36000,	0),
(202,	'KE',	'Africa/Nairobi',	0,	10800,	10800,	0),
(203,	'KG',	'Asia/Bishkek',	0,	18000,	21600,	0),
(204,	'KH',	'Asia/Phnom_Penh',	0,	25200,	25200,	0),
(205,	'KI',	'Pacific/Tarawa',	0,	43200,	43200,	0),
(206,	'KI',	'Pacific/Enderbury',	0,	46800,	46800,	0),
(207,	'KI',	'Pacific/Kiritimati',	0,	50400,	50400,	0),
(208,	'KM',	'Indian/Comoro',	0,	10800,	10800,	0),
(209,	'KN',	'America/St_Kitts',	0,	-14400,	-14400,	0),
(210,	'KP',	'Asia/Pyongyang',	0,	30600,	30600,	0),
(211,	'KR',	'Asia/Seoul',	0,	32400,	36000,	0),
(212,	'KW',	'Asia/Kuwait',	0,	10800,	10800,	0),
(213,	'KY',	'America/Cayman',	0,	-18000,	-18000,	0),
(214,	'KZ',	'Asia/Almaty',	0,	21600,	25200,	0),
(215,	'KZ',	'Asia/Qyzylorda',	0,	18000,	21600,	0),
(216,	'KZ',	'Asia/Aqtobe',	0,	18000,	21600,	0),
(217,	'KZ',	'Asia/Aqtau',	0,	14400,	18000,	0),
(218,	'KZ',	'Asia/Oral',	0,	14400,	18000,	0),
(219,	'LA',	'Asia/Vientiane',	0,	25200,	25200,	0),
(220,	'LB',	'Asia/Beirut',	1,	7200,	10800,	0),
(221,	'LC',	'America/St_Lucia',	0,	-14400,	-14400,	0),
(222,	'LI',	'Europe/Vaduz',	1,	3600,	7200,	0),
(223,	'LK',	'Asia/Colombo',	0,	19800,	23400,	0),
(224,	'LR',	'Africa/Monrovia',	0,	0,	0,	0),
(225,	'LS',	'Africa/Maseru',	0,	7200,	10800,	0),
(226,	'LT',	'Europe/Vilnius',	1,	7200,	10800,	0),
(227,	'LU',	'Europe/Luxembourg',	1,	3600,	7200,	0),
(228,	'LV',	'Europe/Riga',	1,	7200,	10800,	0),
(229,	'LY',	'Africa/Tripoli',	1,	7200,	7200,	0),
(230,	'MA',	'Africa/Casablanca',	1,	0,	3600,	0),
(231,	'MC',	'Europe/Monaco',	1,	3600,	7200,	0),
(232,	'MD',	'Europe/Chisinau',	1,	7200,	10800,	0),
(233,	'ME',	'Europe/Podgorica',	1,	3600,	7200,	0),
(234,	'MF',	'America/Marigot',	0,	-14400,	-14400,	0),
(235,	'MG',	'Indian/Antananarivo',	0,	10800,	10800,	0),
(236,	'MH',	'Pacific/Majuro',	0,	43200,	43200,	0),
(237,	'MH',	'Pacific/Kwajalein',	0,	43200,	43200,	0),
(238,	'MK',	'Europe/Skopje',	1,	3600,	7200,	0),
(239,	'ML',	'Africa/Bamako',	0,	0,	0,	0),
(240,	'MM',	'Asia/Yangon',	0,	23400,	23400,	0),
(241,	'MN',	'Asia/Ulaanbaatar',	1,	28800,	32400,	0),
(242,	'MN',	'Asia/Hovd',	1,	25200,	28800,	0),
(243,	'MN',	'Asia/Choibalsan',	1,	28800,	32400,	0),
(244,	'MO',	'Asia/Macau',	0,	28800,	32400,	0),
(245,	'MP',	'Pacific/Saipan',	0,	36000,	36000,	0),
(246,	'MQ',	'America/Martinique',	0,	-14400,	-10800,	0),
(247,	'MR',	'Africa/Nouakchott',	0,	0,	0,	0),
(248,	'MS',	'America/Montserrat',	0,	-14400,	-14400,	0),
(249,	'MT',	'Europe/Malta',	1,	3600,	7200,	0),
(250,	'MU',	'Indian/Mauritius',	0,	14400,	18000,	0),
(251,	'MV',	'Indian/Maldives',	0,	18000,	18000,	0),
(252,	'MW',	'Africa/Blantyre',	0,	7200,	7200,	0),
(253,	'MX',	'America/Mexico_City',	1,	-21600,	-18000,	0),
(254,	'MX',	'America/Cancun',	1,	-18000,	-18000,	0),
(255,	'MX',	'America/Merida',	1,	-21600,	-18000,	0),
(256,	'MX',	'America/Monterrey',	1,	-21600,	-18000,	0),
(257,	'MX',	'America/Matamoros',	1,	-21600,	-18000,	0),
(258,	'MX',	'America/Mazatlan',	1,	-25200,	-21600,	0),
(259,	'MX',	'America/Chihuahua',	1,	-25200,	-21600,	0),
(260,	'MX',	'America/Ojinaga',	1,	-25200,	-21600,	0),
(261,	'MX',	'America/Hermosillo',	0,	-25200,	-21600,	0),
(262,	'MX',	'America/Tijuana',	1,	-28800,	-25200,	0),
(263,	'MX',	'America/Bahia_Banderas',	1,	-21600,	-18000,	0),
(264,	'MY',	'Asia/Kuala_Lumpur',	0,	28800,	26400,	0),
(265,	'MY',	'Asia/Kuching',	0,	28800,	30000,	0),
(266,	'MZ',	'Africa/Maputo',	0,	7200,	7200,	0),
(267,	'NA',	'Africa/Windhoek',	1,	3600,	7200,	1),
(268,	'NC',	'Pacific/Noumea',	0,	39600,	43200,	0),
(269,	'NE',	'Africa/Niamey',	0,	3600,	3600,	0),
(270,	'NF',	'Pacific/Norfolk',	0,	39600,	45000,	0),
(271,	'NG',	'Africa/Lagos',	0,	3600,	3600,	0),
(272,	'NI',	'America/Managua',	0,	-21600,	-18000,	0),
(273,	'NL',	'Europe/Amsterdam',	1,	3600,	7200,	0),
(274,	'NO',	'Europe/Oslo',	1,	3600,	7200,	0),
(275,	'NP',	'Asia/Kathmandu',	0,	20700,	20700,	0),
(276,	'NR',	'Pacific/Nauru',	0,	43200,	43200,	0),
(277,	'NU',	'Pacific/Niue',	0,	-39600,	-39600,	0),
(278,	'NZ',	'Pacific/Auckland',	1,	43200,	46800,	1),
(279,	'NZ',	'Pacific/Chatham',	1,	45900,	49500,	1),
(280,	'OM',	'Asia/Muscat',	0,	14400,	14400,	0),
(281,	'PA',	'America/Panama',	0,	-18000,	-18000,	0),
(282,	'PE',	'America/Lima',	0,	-18000,	-14400,	0),
(283,	'PF',	'Pacific/Tahiti',	0,	-36000,	-36000,	0),
(284,	'PF',	'Pacific/Marquesas',	0,	-34200,	-34200,	0),
(285,	'PF',	'Pacific/Gambier',	0,	-32400,	-32400,	0),
(286,	'PG',	'Pacific/Port_Moresby',	0,	36000,	36000,	0),
(287,	'PG',	'Pacific/Bougainville',	0,	39600,	39600,	0),
(288,	'PH',	'Asia/Manila',	0,	28800,	32400,	0),
(289,	'PK',	'Asia/Karachi',	0,	18000,	21600,	0),
(290,	'PL',	'Europe/Warsaw',	1,	3600,	7200,	0),
(291,	'PM',	'America/Miquelon',	1,	-10800,	-7200,	0),
(292,	'PN',	'Pacific/Pitcairn',	0,	-28800,	-28800,	0),
(293,	'PR',	'America/Puerto_Rico',	0,	-14400,	-10800,	0),
(294,	'PS',	'Asia/Gaza',	1,	7200,	10800,	0),
(295,	'PS',	'Asia/Hebron',	1,	7200,	10800,	0),
(296,	'PT',	'Europe/Lisbon',	1,	0,	3600,	0),
(297,	'PT',	'Atlantic/Madeira',	1,	0,	3600,	0),
(298,	'PT',	'Atlantic/Azores',	1,	-3600,	0,	0),
(299,	'PW',	'Pacific/Palau',	0,	32400,	32400,	0),
(300,	'PY',	'America/Asuncion',	1,	-14400,	-10800,	1),
(301,	'QA',	'Asia/Qatar',	0,	10800,	10800,	0),
(302,	'RE',	'Indian/Reunion',	0,	14400,	14400,	0),
(303,	'RO',	'Europe/Bucharest',	1,	7200,	10800,	0),
(304,	'RS',	'Europe/Belgrade',	1,	3600,	7200,	0),
(305,	'RU',	'Europe/Kaliningrad',	0,	7200,	10800,	0),
(306,	'RU',	'Europe/Moscow',	0,	10800,	14400,	0),
(307,	'RU',	'Europe/Simferopol',	1,	10800,	10800,	0),
(308,	'RU',	'Europe/Volgograd',	0,	10800,	14400,	0),
(309,	'RU',	'Europe/Kirov',	0,	10800,	14400,	0),
(310,	'RU',	'Europe/Astrakhan',	0,	14400,	14400,	0),
(311,	'RU',	'Europe/Samara',	0,	14400,	18000,	0),
(312,	'RU',	'Europe/Ulyanovsk',	0,	14400,	14400,	0),
(313,	'RU',	'Asia/Yekaterinburg',	0,	18000,	21600,	0),
(314,	'RU',	'Asia/Omsk',	0,	21600,	25200,	0),
(315,	'RU',	'Asia/Novosibirsk',	0,	25200,	25200,	0),
(316,	'RU',	'Asia/Barnaul',	0,	25200,	25200,	0),
(317,	'RU',	'Asia/Tomsk',	0,	25200,	25200,	0),
(318,	'RU',	'Asia/Novokuznetsk',	0,	25200,	28800,	0),
(319,	'RU',	'Asia/Krasnoyarsk',	0,	25200,	28800,	0),
(320,	'RU',	'Asia/Irkutsk',	0,	28800,	32400,	0),
(321,	'RU',	'Asia/Chita',	0,	32400,	36000,	0),
(322,	'RU',	'Asia/Yakutsk',	0,	32400,	36000,	0),
(323,	'RU',	'Asia/Khandyga',	0,	32400,	39600,	0),
(324,	'RU',	'Asia/Vladivostok',	0,	36000,	39600,	0),
(325,	'RU',	'Asia/Ust-Nera',	0,	36000,	43200,	0),
(326,	'RU',	'Asia/Magadan',	0,	39600,	43200,	0),
(327,	'RU',	'Asia/Sakhalin',	0,	39600,	39600,	0),
(328,	'RU',	'Asia/Srednekolymsk',	0,	39600,	43200,	0),
(329,	'RU',	'Asia/Kamchatka',	0,	43200,	46800,	0),
(330,	'RU',	'Asia/Anadyr',	0,	43200,	46800,	0),
(331,	'RW',	'Africa/Kigali',	0,	7200,	7200,	0),
(332,	'SA',	'Asia/Riyadh',	0,	10800,	10800,	0),
(333,	'SB',	'Pacific/Guadalcanal',	0,	39600,	39600,	0),
(334,	'SC',	'Indian/Mahe',	0,	14400,	14400,	0),
(335,	'SD',	'Africa/Khartoum',	0,	10800,	10800,	0),
(336,	'SE',	'Europe/Stockholm',	1,	3600,	7200,	0),
(337,	'SG',	'Asia/Singapore',	0,	28800,	26400,	0),
(338,	'SH',	'Atlantic/St_Helena',	0,	0,	0,	0),
(339,	'SI',	'Europe/Ljubljana',	1,	3600,	7200,	0),
(340,	'SJ',	'Arctic/Longyearbyen',	1,	3600,	7200,	0),
(341,	'SK',	'Europe/Bratislava',	1,	3600,	7200,	0),
(342,	'SL',	'Africa/Freetown',	0,	0,	0,	0),
(343,	'SM',	'Europe/San_Marino',	1,	3600,	7200,	0),
(344,	'SN',	'Africa/Dakar',	0,	0,	0,	0),
(345,	'SO',	'Africa/Mogadishu',	0,	10800,	10800,	0),
(346,	'SR',	'America/Paramaribo',	0,	-10800,	-10800,	0),
(347,	'SS',	'Africa/Juba',	0,	10800,	10800,	0),
(348,	'ST',	'Africa/Sao_Tome',	0,	0,	0,	0),
(349,	'SV',	'America/El_Salvador',	0,	-21600,	-18000,	0),
(350,	'SX',	'America/Lower_Princes',	0,	-14400,	-14400,	0),
(351,	'SY',	'Asia/Damascus',	1,	7200,	10800,	0),
(352,	'SZ',	'Africa/Mbabane',	0,	7200,	10800,	0),
(353,	'TC',	'America/Grand_Turk',	1,	-14400,	-14400,	0),
(354,	'TD',	'Africa/Ndjamena',	0,	3600,	7200,	0),
(355,	'TF',	'Indian/Kerguelen',	0,	18000,	18000,	0),
(356,	'TG',	'Africa/Lome',	0,	0,	0,	0),
(357,	'TH',	'Asia/Bangkok',	0,	25200,	25200,	0),
(358,	'TJ',	'Asia/Dushanbe',	0,	18000,	25200,	0),
(359,	'TK',	'Pacific/Fakaofo',	0,	46800,	46800,	0),
(360,	'TL',	'Asia/Dili',	0,	32400,	32400,	0),
(361,	'TM',	'Asia/Ashgabat',	0,	18000,	21600,	0),
(362,	'TN',	'Africa/Tunis',	0,	3600,	7200,	0),
(363,	'TO',	'Pacific/Tongatapu',	0,	46800,	50400,	0),
(364,	'TR',	'Europe/Istanbul',	1,	10800,	10800,	0),
(365,	'TT',	'America/Port_of_Spain',	0,	-14400,	-14400,	0),
(366,	'TV',	'Pacific/Funafuti',	0,	43200,	43200,	0),
(367,	'TW',	'Asia/Taipei',	0,	28800,	32400,	0),
(368,	'TZ',	'Africa/Dar_es_Salaam',	0,	10800,	10800,	0),
(369,	'UA',	'Europe/Kiev',	1,	7200,	10800,	0),
(370,	'UA',	'Europe/Uzhgorod',	1,	7200,	10800,	0),
(371,	'UA',	'Europe/Zaporozhye',	1,	7200,	10800,	0),
(372,	'UG',	'Africa/Kampala',	0,	10800,	10800,	0),
(373,	'UM',	'Pacific/Johnston',	0,	-36000,	-34200,	0),
(374,	'UM',	'Pacific/Midway',	0,	-39600,	-39600,	0),
(375,	'UM',	'Pacific/Wake',	0,	43200,	43200,	0),
(376,	'US',	'America/New_York',	1,	-18000,	-14400,	0),
(377,	'US',	'America/Detroit',	1,	-18000,	-14400,	0),
(378,	'US',	'America/Kentucky/Louisville',	1,	-18000,	-14400,	0),
(379,	'US',	'America/Kentucky/Monticello',	1,	-18000,	-14400,	0),
(380,	'US',	'America/Indiana/Indianapolis',	1,	-18000,	-14400,	0),
(381,	'US',	'America/Indiana/Vincennes',	1,	-18000,	-14400,	0),
(382,	'US',	'America/Indiana/Winamac',	1,	-18000,	-14400,	0),
(383,	'US',	'America/Indiana/Marengo',	1,	-18000,	-14400,	0),
(384,	'US',	'America/Indiana/Petersburg',	1,	-18000,	-14400,	0),
(385,	'US',	'America/Indiana/Vevay',	1,	-18000,	-14400,	0),
(386,	'US',	'America/Chicago',	1,	-21600,	-18000,	0),
(387,	'US',	'America/Indiana/Tell_City',	1,	-21600,	-18000,	0),
(388,	'US',	'America/Indiana/Knox',	1,	-21600,	-18000,	0),
(389,	'US',	'America/Menominee',	1,	-21600,	-18000,	0),
(390,	'US',	'America/North_Dakota/Center',	1,	-21600,	-18000,	0),
(391,	'US',	'America/North_Dakota/New_Salem',	1,	-21600,	-18000,	0),
(392,	'US',	'America/North_Dakota/Beulah',	1,	-21600,	-18000,	0),
(393,	'US',	'America/Denver',	1,	-25200,	-21600,	0),
(394,	'US',	'America/Boise',	1,	-25200,	-21600,	0),
(395,	'US',	'America/Phoenix',	0,	-25200,	-21600,	0),
(396,	'US',	'America/Los_Angeles',	1,	-28800,	-25200,	0),
(397,	'US',	'America/Anchorage',	1,	-32400,	-28800,	0),
(398,	'US',	'America/Juneau',	1,	-32400,	-28800,	0),
(399,	'US',	'America/Sitka',	1,	-32400,	-28800,	0),
(400,	'US',	'America/Metlakatla',	1,	-32400,	-28800,	0),
(401,	'US',	'America/Yakutat',	1,	-32400,	-28800,	0),
(402,	'US',	'America/Nome',	1,	-32400,	-28800,	0),
(403,	'US',	'America/Adak',	1,	-36000,	-32400,	0),
(404,	'US',	'Pacific/Honolulu',	0,	-36000,	-34200,	0),
(405,	'UY',	'America/Montevideo',	1,	-10800,	-7200,	0),
(406,	'UZ',	'Asia/Samarkand',	0,	18000,	21600,	0),
(407,	'UZ',	'Asia/Tashkent',	0,	18000,	25200,	0),
(408,	'VA',	'Europe/Vatican',	1,	3600,	7200,	0),
(409,	'VC',	'America/St_Vincent',	0,	-14400,	-14400,	0),
(410,	'VE',	'America/Caracas',	0,	-14400,	-14400,	0),
(411,	'VG',	'America/Tortola',	0,	-14400,	-14400,	0),
(412,	'VI',	'America/St_Thomas',	0,	-14400,	-14400,	0),
(413,	'VN',	'Asia/Ho_Chi_Minh',	0,	25200,	25200,	0),
(414,	'VU',	'Pacific/Efate',	0,	39600,	43200,	0),
(415,	'WF',	'Pacific/Wallis',	0,	43200,	43200,	0),
(416,	'WS',	'Pacific/Apia',	1,	46800,	50400,	1),
(417,	'YE',	'Asia/Aden',	0,	10800,	10800,	0),
(418,	'YT',	'Indian/Mayotte',	0,	10800,	10800,	0),
(419,	'ZA',	'Africa/Johannesburg',	0,	7200,	10800,	0),
(420,	'ZM',	'Africa/Lusaka',	0,	7200,	7200,	0),
(421,	'ZW',	'Africa/Harare',	0,	7200,	7200,	0);

-- option Minimum number of characters for dimension search
INSERT INTO `<?php echo $table_prefix ?>config_options` (`category_name`, `name`, `value`, `config_handler_class`, `is_system`, `option_order`, `dev_comment`, `options`)
VALUES ('general', 'minimum_characters_dimension_search', '3', 'IntegerConfigHandler', '0', '0', 'Minimum number of characters for dimension search', '');
