info = {
    "name": "ml",
    "date_order": "DMY",
    "january": [
        "ജനു",
        "ജനുവരി"
    ],
    "february": [
        "ഫെബ്രു",
        "ഫെബ്രുവരി"
    ],
    "march": [
        "മാർ",
        "മാർച്ച്"
    ],
    "april": [
        "ഏപ്രി",
        "ഏപ്രിൽ"
    ],
    "may": [
        "മേയ്"
    ],
    "june": [
        "ജൂൺ"
    ],
    "july": [
        "ജൂലൈ"
    ],
    "august": [
        "ഓഗ",
        "ഓഗസ്റ്റ്"
    ],
    "september": [
        "സെപ്റ്റം",
        "സെപ്റ്റംബർ"
    ],
    "october": [
        "ഒക്ടോ",
        "ഒക്‌ടോബർ"
    ],
    "november": [
        "നവം",
        "നവംബർ"
    ],
    "december": [
        "ഡിസം",
        "ഡിസംബർ"
    ],
    "monday": [
        "തിങ്കളാഴ്‌ച",
        "തിങ്കൾ"
    ],
    "tuesday": [
        "ചൊവ്വ",
        "ചൊവ്വാഴ്ച",
        "ചൊവ്വാഴ്‌ച"
    ],
    "wednesday": [
        "ബുധനാഴ്‌ച",
        "ബുധൻ"
    ],
    "thursday": [
        "വ്യാഴം",
        "വ്യാഴാഴ്‌ച"
    ],
    "friday": [
        "വെള്ളി",
        "വെള്ളിയാഴ്‌ച"
    ],
    "saturday": [
        "ശനി",
        "ശനിയാഴ്‌ച"
    ],
    "sunday": [
        "ഞായറാഴ്‌ച",
        "ഞായർ"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "വ",
        "വർഷം"
    ],
    "month": [
        "മാ",
        "മാസം"
    ],
    "week": [
        "ആ",
        "ആഴ്ച"
    ],
    "day": [
        "ദിവസം"
    ],
    "hour": [
        "മ",
        "മണിക്കൂർ"
    ],
    "minute": [
        "മി",
        "മിനിറ്റ്"
    ],
    "second": [
        "സെ",
        "സെക്കൻഡ്"
    ],
    "relative-type": {
        "0 day ago": [
            "ഇന്ന്"
        ],
        "0 hour ago": [
            "ഈ മണിക്കൂറിൽ"
        ],
        "0 minute ago": [
            "ഈ മിനിറ്റിൽ"
        ],
        "0 month ago": [
            "ഈ മാസം"
        ],
        "0 second ago": [
            "ഇപ്പോൾ"
        ],
        "0 week ago": [
            "ഈ ആഴ്ച"
        ],
        "0 year ago": [
            "ഈ വർ‌ഷം"
        ],
        "1 day ago": [
            "ഇന്നലെ"
        ],
        "1 month ago": [
            "കഴിഞ്ഞ മാസം"
        ],
        "1 week ago": [
            "കഴിഞ്ഞ ആഴ്‌ച"
        ],
        "1 year ago": [
            "കഴിഞ്ഞ വർഷം"
        ],
        "in 1 day": [
            "നാളെ"
        ],
        "in 1 month": [
            "അടുത്ത മാസം"
        ],
        "in 1 week": [
            "അടുത്ത ആഴ്ച"
        ],
        "in 1 year": [
            "അടുത്തവർഷം"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+[.,]?\\d*) ദിവസം മുമ്പ്"
        ],
        "\\1 hour ago": [
            "(\\d+[.,]?\\d*) മണിക്കൂർ മുമ്പ്"
        ],
        "\\1 minute ago": [
            "(\\d+[.,]?\\d*) മിനിറ്റ് മുമ്പ്"
        ],
        "\\1 month ago": [
            "(\\d+[.,]?\\d*) മാസം മുമ്പ്"
        ],
        "\\1 second ago": [
            "(\\d+[.,]?\\d*) സെക്കൻഡ് മുമ്പ്"
        ],
        "\\1 week ago": [
            "(\\d+[.,]?\\d*) ആഴ്ച മുമ്പ്"
        ],
        "\\1 year ago": [
            "(\\d+[.,]?\\d*) വർഷം മുമ്പ്"
        ],
        "in \\1 day": [
            "(\\d+[.,]?\\d*) ദിവസത്തിൽ"
        ],
        "in \\1 hour": [
            "(\\d+[.,]?\\d*) മണിക്കൂറിൽ"
        ],
        "in \\1 minute": [
            "(\\d+[.,]?\\d*) മിനിറ്റിൽ"
        ],
        "in \\1 month": [
            "(\\d+[.,]?\\d*) മാസത്തിൽ"
        ],
        "in \\1 second": [
            "(\\d+[.,]?\\d*) സെക്കൻഡിൽ"
        ],
        "in \\1 week": [
            "(\\d+[.,]?\\d*) ആഴ്ചയിൽ"
        ],
        "in \\1 year": [
            "(\\d+[.,]?\\d*) വർഷത്തിൽ"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
