from multiqc import report
from multiqc.modules.umitools import MultiqcModule


def test_parse_name(tmp_path):
    f1 = tmp_path / "stdout.log"
    f1.write_text("""\
# output generated by extract -I INPUT.fastq.gz -S OUTPUT.fastq.gz
# stdin    : <_io.TextIOWrapper name='INPUT.fastq.gz' encoding='ascii'>
# stdout   : <_io.TextIOWrapper name='OUTPUT.fastq.gz' encoding='ascii'>
2024-06-05 19:57:52,145 INFO Input Reads: 50000
""")

    f2 = tmp_path / "stdin.log"
    f2.write_text("""\
# output generated by extract -I INPUT.fastq.gz
# stdin    : <_io.TextIOWrapper name='INPUT.fastq.gz' encoding='ascii'>
# stdout   : <_io.TextIOWrapper name='<stdout>' encoding='ascii'>
2024-06-05 19:57:52,145 INFO Input Reads: 50000
""")

    f3 = tmp_path / "filename.log"
    f3.write_text("""\
# output generated by extract
# stdin    : <_io.TextIOWrapper name='<stdin>' encoding='ascii'>
# stdout   : <_io.TextIOWrapper name='<stdout>' encoding='ascii'>
2024-06-05 19:57:52,145 INFO Input Reads: 50000
""")

    report.analysis_files = [f1, f2, f3]
    report.search_files(["umitools"])
    m = MultiqcModule()
    assert len(m.saved_raw_data) > 0
    print(m.saved_raw_data)
    assert list(m.saved_raw_data["multiqc_umitools_extract"].keys())[0] == "OUTPUT"
    assert list(m.saved_raw_data["multiqc_umitools_extract"].keys())[1] == "INPUT"
    assert list(m.saved_raw_data["multiqc_umitools_extract"].keys())[2] == "filename"
