/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;

public class ICC_ProfileRGB
extends ICC_Profile {
    private static final long serialVersionUID = 8505067385152579334L;
    public static final int REDCOMPONENT = 0;
    public static final int GREENCOMPONENT = 1;
    public static final int BLUECOMPONENT = 2;
    private transient float[][] matrix = this.createMatrix();
    private transient float[] gamma;
    private transient float[] whitePoint = this.getXYZData(0x77747074);

    public float[] getMediaWhitePoint() {
        float[] wp = new float[]{this.whitePoint[0], this.whitePoint[1], this.whitePoint[2]};
        return wp;
    }

    public float[][] getMatrix() {
        float[][] mat = new float[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                mat[i][j] = this.matrix[i][j];
                ++j;
            }
            ++i;
        }
        return mat;
    }

    public float getGamma(int component) {
        short[] data;
        switch (component) {
            case 0: {
                data = this.getCurve(1918128707);
                break;
            }
            case 1: {
                data = this.getCurve(1733579331);
                break;
            }
            case 2: {
                data = this.getCurve(1649693251);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid component");
            }
        }
        if (data == null) {
            throw new IllegalArgumentException("Error reading TRC");
        }
        if (data.length != 1) {
            throw new ProfileDataException("Not a single-gamma TRC");
        }
        float gamma = (data[0] & 0xFF00) >> 8;
        double fraction = (double)(data[0] & 0xFF) / 256.0;
        return gamma += (float)fraction;
    }

    public short[] getTRC(int component) {
        short[] data;
        switch (component) {
            case 0: {
                data = this.getCurve(1918128707);
                break;
            }
            case 1: {
                data = this.getCurve(1733579331);
                break;
            }
            case 2: {
                data = this.getCurve(1649693251);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid component");
            }
        }
        if (data == null) {
            throw new IllegalArgumentException("Error reading TRC");
        }
        if (data.length <= 1) {
            throw new ProfileDataException("Gamma value, not a TRC table.");
        }
        return data;
    }

    private final float[][] createMatrix() throws IllegalArgumentException {
        float[][] mat = new float[3][3];
        float[] r = this.getXYZData(1918392666);
        float[] g = this.getXYZData(1733843290);
        float[] b = this.getXYZData(1649957210);
        if (r == null || g == null || b == null) {
            throw new IllegalArgumentException("Error reading colorant tags!");
        }
        int i = 0;
        while (i < 3) {
            mat[i][0] = r[i];
            mat[i][1] = g[i];
            mat[i][2] = b[i];
            ++i;
        }
        return mat;
    }

    ICC_ProfileRGB(int cspace) {
        super(cspace);
    }

    ICC_ProfileRGB(byte[] data) {
        super(data);
    }
}

