#Boa:Dialog:About
#TunaPie (c)2005-2009 James Stone.
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#
#Written using Boa-Constructor.
#http://boa-constructor.sourceforge.net/
#
#Version 0.2.54  23/10/08

import wx
from wx.lib.anchors import LayoutAnchors
import wx.lib.stattext

def create(parent):
    return About(parent)

[wxID_ABOUT, wxID_ABOUTBUTTON1, wxID_ABOUTGENSTATICTEXT1, 
 wxID_ABOUTGENSTATICTEXT2, wxID_ABOUTGENSTATICTEXT3, 
] = [wx.NewId() for _init_ctrls in range(5)]

class About(wx.Dialog):
    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Dialog.__init__(self, id=wxID_ABOUT, name='About', parent=prnt,
              pos=wx.Point(507, 387), size=wx.Size(438, 124),
              style=wx.DEFAULT_DIALOG_STYLE, title='About TunaPie')
        self.SetClientSize(wx.Size(438, 124))
        self.Show(True)
        self.SetBackgroundColour(wx.Colour(220, 218, 213))
        self.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.SetThemeEnabled(True)

        self.genStaticText1 = wx.lib.stattext.GenStaticText(ID=wxID_ABOUTGENSTATICTEXT1,
              label='TunaPie: A tuner for Shoutcast Radio and Internet TV.',
              name='genStaticText1', parent=self, pos=wx.Point(8, 16),
              size=wx.Size(258, 13), style=0)
        self.genStaticText1.SetFont(wx.Font(8, 77, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.genStaticText1.SetBackgroundColour(wx.Colour(220, 218, 213))
        self.genStaticText1.SetConstraints(LayoutAnchors(self.genStaticText1,
              True, True, True, True))
        self.genStaticText1.SetAutoLayout(True)
        self.genStaticText1.SetThemeEnabled(True)
        self.genStaticText1.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)

        self.genStaticText2 = wx.lib.stattext.GenStaticText(ID=wxID_ABOUTGENSTATICTEXT2,
              label=u'Version 2.1.17 (c) 2005-2009 James Stone jamesmstone@gmail.com',
              name='genStaticText2', parent=self, pos=wx.Point(10, 48),
              size=wx.Size(333, 12), style=0)
        self.genStaticText2.SetFont(wx.Font(7, 77, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.genStaticText2.SetBackgroundColour(wx.Colour(220, 218, 213))
        self.genStaticText2.SetConstraints(LayoutAnchors(self.genStaticText2,
              True, True, True, True))
        self.genStaticText2.SetAutoLayout(True)
        self.genStaticText2.SetThemeEnabled(True)
        self.genStaticText2.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)

        self.genStaticText3 = wx.lib.stattext.GenStaticText(ID=wxID_ABOUTGENSTATICTEXT3,
              label='Released under the GNU GPL', name='genStaticText3',
              parent=self, pos=wx.Point(8, 80), size=wx.Size(145, 13), style=0)
        self.genStaticText3.SetBackgroundColour(wx.Colour(220, 218, 213))
        self.genStaticText3.SetFont(wx.Font(8, 77, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.genStaticText3.SetConstraints(LayoutAnchors(self.genStaticText3,
              True, True, True, True))
        self.genStaticText3.SetAutoLayout(True)
        self.genStaticText3.SetThemeEnabled(True)
        self.genStaticText3.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)

        self.button1 = wx.Button(id=wxID_ABOUTBUTTON1, label='OK',
              name='button1', parent=self, pos=wx.Point(330, 88),
              size=wx.Size(80, 24), style=0)
        self.button1.SetBackgroundColour(wx.Colour(220, 218, 213))
        self.button1.SetFont(wx.Font(7, 77, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.button1.SetConstraints(LayoutAnchors(self.button1, True, True,
              True, True))
        self.button1.SetAutoLayout(True)
        self.button1.SetThemeEnabled(True)
        self.button1.Bind(wx.EVT_BUTTON, self.OnButton1Button,
              id=wxID_ABOUTBUTTON1)

    def __init__(self, parent):
        self._init_ctrls(parent)

    def setfontsize(self, newsize):
        size=int(newsize)
        self.genStaticText1.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.genStaticText2.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.genStaticText3.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.genStaticText3.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.button1.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        
    def OnButton1Button(self, event):
        self.Close()
