/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VATOMIC_CORE_U8_H
#define VATOMIC_CORE_U8_H
/*******************************************************************************
 * @file core_u8.h
 * @brief Atomic functions for vatomic8_t variables.
 *
 * This file declares and documents the core atomic functions operating on
 * vatomic8_t variables.
 *
 * Please do not include this file directly, instead use:
 * ```c
 * #include <vsync/atomic/core.h>
 * ```
 ******************************************************************************/
/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#ifndef VATOMIC_CORE_H
    #error "File included directly. Include <vsync/atomic/core.h> instead!"
#endif

/**
 * Initializes the atomic variable a with value v.
 *
 * The initialization is equivalent to an vatomic8_write().
 *
 * @param a atomic variable
 * @param v initial value
 * @memord seq_cst
 */
static inline void vatomic8_init(vatomic8_t *a, vuint8_t v);

/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_read(const vatomic8_t *a);
/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord acquire
 */
static inline vuint8_t vatomic8_read_acq(const vatomic8_t *a);
/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_read_rlx(const vatomic8_t *a);

/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord seq_cst
 */
static inline void vatomic8_write(vatomic8_t *a, vuint8_t v);
/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord release
 */
static inline void vatomic8_write_rel(vatomic8_t *a, vuint8_t v);
/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord relaxed
 */
static inline void vatomic8_write_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_xchg(vatomic8_t *a, vuint8_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord acquire
 */
static inline vuint8_t vatomic8_xchg_acq(vatomic8_t *a, vuint8_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord release
 */
static inline vuint8_t vatomic8_xchg_rel(vatomic8_t *a, vuint8_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_xchg_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint8_t vatomic8_cmpxchg(vatomic8_t *a, vuint8_t e, vuint8_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint8_t vatomic8_cmpxchg_acq(vatomic8_t *a, vuint8_t e,
                                            vuint8_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint8_t vatomic8_cmpxchg_rel(vatomic8_t *a, vuint8_t e,
                                            vuint8_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint8_t vatomic8_cmpxchg_rlx(vatomic8_t *a, vuint8_t e,
                                            vuint8_t v);

/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_get_max(vatomic8_t *a, vuint8_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord acquire
 */
static inline vuint8_t vatomic8_get_max_acq(vatomic8_t *a, vuint8_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord release
 */
static inline vuint8_t vatomic8_get_max_rel(vatomic8_t *a, vuint8_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_get_max_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_max_get(vatomic8_t *a, vuint8_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord acquire
 */
static inline vuint8_t vatomic8_max_get_acq(vatomic8_t *a, vuint8_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord release
 */
static inline vuint8_t vatomic8_max_get_rel(vatomic8_t *a, vuint8_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_max_get_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord seq_cst
 */
static inline void vatomic8_max(vatomic8_t *a, vuint8_t v);
/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord release
 */
static inline void vatomic8_max_rel(vatomic8_t *a, vuint8_t v);
/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord relaxed
 */
static inline void vatomic8_max_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_get_and(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vuint8_t vatomic8_get_and_acq(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vuint8_t vatomic8_get_and_rel(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_get_and_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_and_get(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vuint8_t vatomic8_and_get_acq(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vuint8_t vatomic8_and_get_rel(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_and_get_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomic8_and(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomic8_and_rel(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomic8_and_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_get_or(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vuint8_t vatomic8_get_or_acq(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vuint8_t vatomic8_get_or_rel(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_get_or_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_or_get(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vuint8_t vatomic8_or_get_acq(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vuint8_t vatomic8_or_get_rel(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_or_get_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomic8_or(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomic8_or_rel(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomic8_or_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_get_xor(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vuint8_t vatomic8_get_xor_acq(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vuint8_t vatomic8_get_xor_rel(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_get_xor_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_xor_get(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vuint8_t vatomic8_xor_get_acq(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vuint8_t vatomic8_xor_get_rel(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_xor_get_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomic8_xor(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomic8_xor_rel(vatomic8_t *a, vuint8_t v);
/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomic8_xor_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_get_add(vatomic8_t *a, vuint8_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord acquire
 */
static inline vuint8_t vatomic8_get_add_acq(vatomic8_t *a, vuint8_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord release
 */
static inline vuint8_t vatomic8_get_add_rel(vatomic8_t *a, vuint8_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_get_add_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_add_get(vatomic8_t *a, vuint8_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord acquire
 */
static inline vuint8_t vatomic8_add_get_acq(vatomic8_t *a, vuint8_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord release
 */
static inline vuint8_t vatomic8_add_get_rel(vatomic8_t *a, vuint8_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_add_get_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord seq_cst
 */
static inline void vatomic8_add(vatomic8_t *a, vuint8_t v);
/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord release
 */
static inline void vatomic8_add_rel(vatomic8_t *a, vuint8_t v);
/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord relaxed
 */
static inline void vatomic8_add_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_get_inc(vatomic8_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord acquire
 */
static inline vuint8_t vatomic8_get_inc_acq(vatomic8_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord release
 */
static inline vuint8_t vatomic8_get_inc_rel(vatomic8_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_get_inc_rlx(vatomic8_t *a);

/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_inc_get(vatomic8_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord acquire
 */
static inline vuint8_t vatomic8_inc_get_acq(vatomic8_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord release
 */
static inline vuint8_t vatomic8_inc_get_rel(vatomic8_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_inc_get_rlx(vatomic8_t *a);

/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord seq_cst
 */
static inline void vatomic8_inc(vatomic8_t *a);
/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord release
 */
static inline void vatomic8_inc_rel(vatomic8_t *a);
/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord relaxed
 */
static inline void vatomic8_inc_rlx(vatomic8_t *a);

/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_get_sub(vatomic8_t *a, vuint8_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord acquire
 */
static inline vuint8_t vatomic8_get_sub_acq(vatomic8_t *a, vuint8_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord release
 */
static inline vuint8_t vatomic8_get_sub_rel(vatomic8_t *a, vuint8_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_get_sub_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_sub_get(vatomic8_t *a, vuint8_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord acquire
 */
static inline vuint8_t vatomic8_sub_get_acq(vatomic8_t *a, vuint8_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord release
 */
static inline vuint8_t vatomic8_sub_get_rel(vatomic8_t *a, vuint8_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_sub_get_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord seq_cst
 */
static inline void vatomic8_sub(vatomic8_t *a, vuint8_t v);
/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord release
 */
static inline void vatomic8_sub_rel(vatomic8_t *a, vuint8_t v);
/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord relaxed
 */
static inline void vatomic8_sub_rlx(vatomic8_t *a, vuint8_t v);

/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_get_dec(vatomic8_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord acquire
 */
static inline vuint8_t vatomic8_get_dec_acq(vatomic8_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord release
 */
static inline vuint8_t vatomic8_get_dec_rel(vatomic8_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_get_dec_rlx(vatomic8_t *a);

/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord seq_cst
 */
static inline vuint8_t vatomic8_dec_get(vatomic8_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord acquire
 */
static inline vuint8_t vatomic8_dec_get_acq(vatomic8_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord release
 */
static inline vuint8_t vatomic8_dec_get_rel(vatomic8_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord relaxed
 */
static inline vuint8_t vatomic8_dec_get_rlx(vatomic8_t *a);

/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord seq_cst
 */
static inline void vatomic8_dec(vatomic8_t *a);
/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord release
 */
static inline void vatomic8_dec_rel(vatomic8_t *a);
/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord relaxed
 */
static inline void vatomic8_dec_rlx(vatomic8_t *a);

#endif
