/* Scanner for "C" assignment statements... sort of. */
/* Compile: reflex --bison-locations --bison-bridge --header-file reflexexample8.l */
/* Compile: bison -d -y flexexample8.y */
/* Example taken from Flex documentation A.2 */
/* Bison bridge passes yylval to yylex (which limits yylval's scope to the rule actions) */
/* Note: yylval is no longer a pointer with reflex */

%top{
#include "y.tab.h"  /* Generated by bison. */
}

%option bison-locations bison-bridge noyywrap

%%

\d+           { yylval.num = atoi(text());   return NUMBER; }
\w+           { yylval.str = strdup(text()); return STRING; }
"="|";"       { return text()[0]; }
.|\n          {}

%%
