#ifndef SYS_DEPS__H__
#define SYS_DEPS__H__

#define _GNU_SOURCE 1
#include <sys/types.h>
typedef unsigned char uint8;
typedef unsigned short uint16;
/* sysdep: +hasattribute */
/* sysdep: +daylight */
#define HASDAYLIGHT 1
extern int daylight;
/* sysdep: +hasdeprecated */
#define __DEPRECATED__ __attribute__((__deprecated__))
/* sysdep: +ulong32 */
typedef unsigned long uint32;
/* sysdep: -ulong64 */
#undef HAS_ULONG64
typedef unsigned long long uint64;
/* sysdep: endian=msb */
#undef ENDIAN_LSB
#define ENDIAN_MSB 1
#ifndef DIRENTRY_H
#define DIRENTRY_H

/* sysdep: -direct */
/* sysdep: +dirent */
#include <dirent.h>
#define direntry struct dirent

#endif
/* sysdep: +dirent_ino */
#define HASDIRENTINO 1

/* sysdep: +dirent_type */
#define HASDIRENTTYPE 1

/* sysdep: +hasdl */
#define HASDL 1
/* sysdep: +hasipv6 */
#define HASIPV6 1
#ifndef FORK_H
#define FORK_H

/* sysdep: +vfork */
extern pid_t fork();
extern pid_t vfork();

#endif
/* sysdep: -getpeereid */
extern int getpeereid(int s, uid_t* u, gid_t* g);
/* sysdep: +hasflock */
#define HASFLOCK 1

/* sysdep: -struct ucred */
/* sysdep: -linux_sendfile */
/* sysdep: +sigaction */
#define HASSIGACTION 1
/* sysdep: +sigprocmask */
#define HASSIGPROCMASK 1
/* sysdep: -hasspnam */

/* sysdep: -hasuserpw */

/* sysdep: +waitpid */
#define HASWAITPID 1
/* sysdep: +haszlib */
#define HASZLIB 1
/* sysdep: +poll */
#define IOPOLL_POLL

#include <poll.h>

typedef struct pollfd iopoll_fd;
#define IOPOLL_READ POLLIN
#define IOPOLL_WRITE POLLOUT
#define iopoll poll

extern int iopoll_restart(iopoll_fd* fds, unsigned nfds, unsigned long timeout);
#ifndef SELECT_H
#define SELECT_H

/* sysdep: +sysselect */

#include <sys/time.h>
#include <sys/select.h>
extern int select();

#endif
/* sysdep: +setenv */
#define HASSETENV 1
#include <stdlib.h>
/* sysdep: +timespec */
#define HASTIMESPEC 1
/* sysdep: +clock_gettime */
#define HASCLOCKGETTIME 1
/* sysdep: +unsetenv */
#define HASUNSETENV 1
/* sysdep: -unaligned */
#undef HAS_UNALIGNED_ACCESSES
/* sysdep: +hasmkfifo */
#define HASMKFIFO 1
/* sysdep: -hasnamedpipebug */

/* sysdep: +hasinline */
#define HASINLINE
/* sysdep: +hasnoreturn */
#define __NORETURN__ __attribute__((__noreturn__))

#endif
