/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class KeyFactory {
    private static final String KEY_FACTORY = "KeyFactory";
    private KeyFactorySpi keyFacSpi;
    private Provider provider;
    private String algorithm;

    public static KeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        while (n < providerArray.length) {
            try {
                return KeyFactory.getInstance(string, providerArray[n]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++n;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static KeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return KeyFactory.getInstance(string, provider);
    }

    public static KeyFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("Illegal provider");
        }
        try {
            return new KeyFactory((KeyFactorySpi)Engine.getInstance(KEY_FACTORY, string, provider), provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchAlgorithmException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePublic(keySpec);
    }

    public final PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePrivate(keySpec);
    }

    public final KeySpec getKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGetKeySpec(key, clazz);
    }

    public final Key translateKey(Key key) throws InvalidKeyException {
        return this.keyFacSpi.engineTranslateKey(key);
    }

    protected KeyFactory(KeyFactorySpi keyFactorySpi, Provider provider, String string) {
        this.keyFacSpi = keyFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }
}

