/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RepaintManager {
    private static WeakHashMap currentRepaintManagers;
    private static Rectangle rectCache;
    HashMap dirtyComponents = new HashMap();
    private transient Comparator comparator;
    private RepaintWorker repaintWorker;
    private ArrayList invalidComponents = new ArrayList();
    private boolean doubleBufferingEnabled = true;
    private WeakHashMap offscreenBuffers;
    private boolean repaintUnderway = false;
    private HashMap commitRequests;
    private Dimension doubleBufferMaximumSize;

    public static RepaintManager currentManager(Component component) {
        ThreadGroup threadGroup;
        RepaintManager repaintManager;
        if (currentRepaintManagers == null) {
            currentRepaintManagers = new WeakHashMap();
        }
        if ((repaintManager = (RepaintManager)currentRepaintManagers.get(threadGroup = Thread.currentThread().getThreadGroup())) == null) {
            repaintManager = new RepaintManager();
            currentRepaintManagers.put(threadGroup, repaintManager);
        }
        return repaintManager;
    }

    public static RepaintManager currentManager(JComponent jComponent) {
        return RepaintManager.currentManager((Component)jComponent);
    }

    public static void setCurrentManager(RepaintManager repaintManager) {
        if (currentRepaintManagers == null) {
            currentRepaintManagers = new WeakHashMap();
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        currentRepaintManagers.put(threadGroup, repaintManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addInvalidComponent(JComponent jComponent) {
        block6: {
            Container container = jComponent;
            while (!(container == null || container instanceof JComponent && ((JComponent)container).isValidateRoot())) {
                container = container.getParent();
            }
            if (container != null && container instanceof JComponent && ((JComponent)container).isValidateRoot()) {
                jComponent = (JComponent)container;
            }
            if (this.invalidComponents.contains(jComponent)) {
                return;
            }
            ArrayList arrayList = this.invalidComponents;
            synchronized (arrayList) {
                this.invalidComponents.add(jComponent);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                if (this.repaintWorker.isLive()) break block6;
                this.repaintWorker.setLive(true);
            }
            SwingUtilities.invokeLater(this.repaintWorker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeInvalidComponent(JComponent jComponent) {
        ArrayList arrayList = this.invalidComponents;
        synchronized (arrayList) {
            this.invalidComponents.remove(jComponent);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0 || !jComponent.isShowing()) {
            return;
        }
        jComponent.computeVisibleRect(rectCache);
        SwingUtilities.computeIntersection(n, n2, n3, n4, rectCache);
        if (!rectCache.isEmpty()) {
            if (this.dirtyComponents.containsKey(jComponent)) {
                SwingUtilities.computeUnion(RepaintManager.rectCache.x, RepaintManager.rectCache.y, RepaintManager.rectCache.width, RepaintManager.rectCache.height, (Rectangle)this.dirtyComponents.get(jComponent));
            } else {
                HashMap hashMap = this.dirtyComponents;
                synchronized (hashMap) {
                    this.dirtyComponents.put(jComponent, rectCache.getBounds());
                }
            }
            if (!this.repaintWorker.isLive()) {
                this.repaintWorker.setLive(true);
                SwingUtilities.invokeLater(this.repaintWorker);
            }
        }
    }

    public Rectangle getDirtyRegion(JComponent jComponent) {
        Rectangle rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        return rectangle;
    }

    public void markCompletelyDirty(JComponent jComponent) {
        Rectangle rectangle = jComponent.getBounds();
        this.addDirtyRegion(jComponent, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        jComponent.isCompletelyDirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void markCompletelyClean(JComponent jComponent) {
        HashMap hashMap = this.dirtyComponents;
        synchronized (hashMap) {
            this.dirtyComponents.remove(jComponent);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            jComponent.isCompletelyDirty = false;
            return;
        }
    }

    public boolean isCompletelyDirty(JComponent jComponent) {
        if (!this.dirtyComponents.containsKey(jComponent)) {
            return false;
        }
        return jComponent.isCompletelyDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void validateInvalidComponents() {
        while (this.invalidComponents.size() > 0) {
            ArrayList arrayList = this.invalidComponents;
            // MONITORENTER : arrayList
            {
                Component component = (Component)this.invalidComponents.remove(0);
                // MONITOREXIT : arrayList
                if (!component.isVisible() || !component.isShowing()) continue;
                component.validate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintDirtyRegions() {
        if (this.dirtyComponents.size() == 0) {
            return;
        }
        HashMap hashMap = this.dirtyComponents;
        synchronized (hashMap) {
            ArrayList arrayList = new ArrayList(this.dirtyComponents.size());
            arrayList.addAll(this.dirtyComponents.keySet());
            if (this.comparator == null) {
                this.comparator = new ComponentComparator();
            }
            Collections.sort(arrayList, this.comparator);
            this.repaintUnderway = true;
            Iterator iterator = arrayList.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.repaintUnderway = false;
                    this.commitRemainingBuffers();
                    return;
                }
                JComponent jComponent = (JComponent)iterator.next();
                Rectangle rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
                if (rectangle == null || rectangle.isEmpty()) continue;
                jComponent.paintImmediately(rectangle);
                this.dirtyComponents.remove(jComponent);
            }
        }
    }

    public Image getOffscreenBuffer(Component component, int n, int n2) {
        Component component2 = SwingUtilities.getRoot(component);
        Image image = (Image)this.offscreenBuffers.get(component2);
        if (image == null || image.getWidth(null) < n || image.getHeight(null) < n2) {
            int n3 = Math.max(n, component2.getWidth());
            n3 = Math.min(this.doubleBufferMaximumSize.width, n3);
            int n4 = Math.max(n2, component2.getHeight());
            n4 = Math.min(this.doubleBufferMaximumSize.height, n4);
            image = component.createImage(n3, n4);
            this.offscreenBuffers.put(component2, image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void commitBuffer(Component component, Rectangle rectangle) {
        HashMap hashMap = this.dirtyComponents;
        synchronized (hashMap) {
            block7: {
                block6: {
                    if (this.repaintUnderway) break block6;
                    Graphics graphics = component.getGraphics();
                    Image image = (Image)this.offscreenBuffers.get(component);
                    Rectangle rectangle2 = graphics.getClipBounds();
                    if (rectangle2 != null) {
                        rectangle = SwingUtilities.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
                    }
                    int n = rectangle.x;
                    int n2 = rectangle.y;
                    int n3 = rectangle.x + rectangle.width;
                    int n4 = rectangle.y + rectangle.height;
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    int n5 = image.getWidth(component);
                    int n6 = image.getHeight(component);
                    n = Math.min(n5, n);
                    n2 = Math.min(n6, n2);
                    n3 = Math.min(n5, n3);
                    n4 = Math.min(n6, n4);
                    graphics.drawImage(image, n, n2, n3, n4, n, n2, n3, n4, component);
                    graphics.dispose();
                    break block7;
                }
                if (this.commitRequests.containsKey(component)) {
                    SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (Rectangle)this.commitRequests.get(component));
                } else {
                    this.commitRequests.put(component, rectangle);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void commitRemainingBuffers() {
        HashMap hashMap = this.dirtyComponents;
        synchronized (hashMap) {
            Set set = this.commitRequests.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Component component = (Component)entry.getKey();
                Rectangle rectangle = (Rectangle)entry.getValue();
                this.commitBuffer(component, rectangle);
                iterator.remove();
            }
            return;
        }
    }

    public Image getVolatileOffscreenBuffer(Component component, int n, int n2) {
        int n3 = this.doubleBufferMaximumSize.width;
        int n4 = this.doubleBufferMaximumSize.height;
        return component.createVolatileImage(Math.min(n3, n), Math.min(n4, n2));
    }

    public Dimension getDoubleBufferMaximumSize() {
        return this.doubleBufferMaximumSize;
    }

    public void setDoubleBufferMaximumSize(Dimension dimension) {
        this.doubleBufferMaximumSize = dimension;
    }

    public void setDoubleBufferingEnabled(boolean bl) {
        this.doubleBufferingEnabled = bl;
    }

    public boolean isDoubleBufferingEnabled() {
        return this.doubleBufferingEnabled;
    }

    public String toString() {
        return "RepaintManager";
    }

    public RepaintManager() {
        this.repaintWorker = new RepaintWorker();
        this.doubleBufferMaximumSize = new Dimension(2000, 2000);
        this.offscreenBuffers = new WeakHashMap();
        this.commitRequests = new HashMap();
    }

    static {
        rectCache = new Rectangle();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RepaintWorker
    implements Runnable {
        boolean live = false;

        public synchronized void setLive(boolean bl) {
            this.live = bl;
        }

        public synchronized boolean isLive() {
            return this.live;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                RepaintManager repaintManager = (RepaintManager)currentRepaintManagers.get(threadGroup);
                repaintManager.validateInvalidComponents();
                repaintManager.paintDirtyRegions();
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.setLive(false);
                throw throwable;
            }
            {
                Object var2_5 = null;
                this.setLive(false);
                return;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ComponentComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof JComponent && object2 instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                Rectangle rectangle = (Rectangle)RepaintManager.this.dirtyComponents.get(jComponent);
                JComponent jComponent2 = (JComponent)object2;
                Rectangle rectangle2 = (Rectangle)RepaintManager.this.dirtyComponents.get(jComponent2);
                return rectangle2.width * rectangle2.height - rectangle.width * rectangle.height;
            }
            throw new ClassCastException("This comparator can only be used with JComponents");
        }

        private ComponentComparator() {
        }
    }
}

