/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class MetalSeparatorUI
extends BasicSeparatorUI {
    private static MetalSeparatorUI instance = null;

    public static ComponentUI createUI(JComponent jComponent) {
        if (instance == null) {
            instance = new MetalSeparatorUI();
        }
        return instance;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = new Rectangle();
        SwingUtilities.calculateInnerArea(jComponent, rectangle);
        Color color = graphics.getColor();
        Color color2 = UIManager.getColor("Separator.foreground");
        Color color3 = UIManager.getColor("Separator.background");
        if (!(jComponent instanceof JSeparator)) {
            return;
        }
        JSeparator jSeparator = (JSeparator)jComponent;
        if (jSeparator.getOrientation() == 0) {
            int n = rectangle.height / 2;
            graphics.setColor(color2);
            graphics.drawLine(rectangle.x, rectangle.y + n - 1, rectangle.x + rectangle.width, rectangle.y + n - 1);
            graphics.setColor(color3);
            graphics.fillRect(rectangle.x, rectangle.y + n, rectangle.x + rectangle.width, rectangle.y + n);
        } else {
            int n = rectangle.height / 2 + rectangle.y;
            graphics.setColor(color2);
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
            graphics.setColor(color3);
            graphics.fillRect(rectangle.x + n, rectangle.y + rectangle.height, rectangle.x + n, rectangle.y + rectangle.height);
        }
        graphics.setColor(color);
    }
}

