/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class StringContent
implements AbstractDocument.Content,
Serializable {
    private static final long serialVersionUID = 4755994433709540381L;
    char[] content;
    private int count;
    private Vector positions;

    protected final Vector getPositionsInRange(Vector vector, int n, int n2) {
        Vector vector2 = new Vector();
        Iterator iterator = this.positions.iterator();
        while (iterator.hasNext()) {
            Position position = (Position)iterator.next();
            if (n > position.getOffset() || position.getOffset() > n + n2) continue;
            vector2.add(position);
        }
        return vector2;
    }

    public final Position createPosition(int n) throws BadLocationException {
        if (n < this.count || n > this.count) {
            this.checkLocation(n, 0);
        }
        StickyPosition stickyPosition = new StickyPosition(n);
        this.positions.add(stickyPosition);
        return stickyPosition;
    }

    public final int length() {
        return this.count;
    }

    public final UndoableEdit insertString(int n, String string) throws BadLocationException {
        Object object;
        this.checkLocation(n, 0);
        if (n == this.count) {
            throw new BadLocationException("Invalid location", 1);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[this.content.length + cArray.length];
        this.count += cArray.length;
        if (n > 0) {
            System.arraycopy(this.content, 0, cArray2, 0, n);
        }
        System.arraycopy(cArray, 0, cArray2, n, cArray.length);
        System.arraycopy(this.content, n, cArray2, n + cArray.length, cArray2.length - n - cArray.length);
        if (this.content.length < cArray2.length) {
            this.content = new char[cArray2.length];
        }
        System.arraycopy(cArray2, 0, this.content, 0, cArray2.length);
        Vector vector = this.getPositionsInRange(this.positions, n, cArray2.length - n);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (StickyPosition)iterator.next();
            ((StickyPosition)object).setOffset(((StickyPosition)object).getOffset() + string.length());
        }
        object = new InsertUndo(n, cArray.length);
        return object;
    }

    public final UndoableEdit remove(int n, int n2) throws BadLocationException {
        this.checkLocation(n, n2 + 1);
        char[] cArray = new char[this.content.length - n2];
        this.count -= n2;
        RemoveUndo removeUndo = new RemoveUndo(n, new String(this.content, n, n2));
        System.arraycopy(this.content, 0, cArray, 0, n);
        System.arraycopy(this.content, n + n2, cArray, n, this.content.length - n - n2);
        this.content = new char[cArray.length];
        System.arraycopy(cArray, 0, this.content, 0, this.content.length);
        Vector vector = this.getPositionsInRange(this.positions, n, this.content.length + n2 - n);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            StickyPosition stickyPosition = (StickyPosition)iterator.next();
            int n3 = stickyPosition.getOffset() - n2;
            stickyPosition.setOffset(n3);
            if (n3 >= 0) continue;
            this.positions.remove(stickyPosition);
        }
        return removeUndo;
    }

    public final String getString(int n, int n2) throws BadLocationException {
        this.checkLocation(n, n2);
        return new String(this.content, n, n2);
    }

    public final void getChars(int n, int n2, Segment segment) throws BadLocationException {
        this.checkLocation(n, n2);
        segment.array = this.content;
        segment.offset = n;
        segment.count = n2;
    }

    protected final void updateUndoPositions(Vector vector) {
    }

    final void checkLocation(int n, int n2) throws BadLocationException {
        if (n < 0) {
            throw new BadLocationException("Invalid location", 1);
        }
        if (n > this.count) {
            throw new BadLocationException("Invalid location", this.count);
        }
        if (n + n2 > this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
    }

    private final /* synthetic */ void this() {
        this.positions = new Vector();
    }

    public StringContent() {
        this(1);
    }

    public StringContent(int n) {
        this.this();
        if (n < 1) {
            n = 1;
        }
        this.content = new char[n];
        this.content[0] = 10;
        this.count = 1;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class StickyPosition
    implements Position {
        private int offset;

        void setOffset(int n) {
            this.offset = this.offset >= 0 ? n : -1;
        }

        public int getOffset() {
            int n = 0;
            if (this.offset >= 0) {
                n = this.offset;
            }
            return n;
        }

        private final /* synthetic */ void this() {
            this.offset = -1;
        }

        public StickyPosition(int n) {
            this.this();
            this.offset = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class InsertUndo
    extends AbstractUndoableEdit {
        private int start;
        private int length;
        private String redoContent;

        public void undo() {
            super.undo();
            try {
                StringContent.this.checkLocation(this.start, this.length);
                this.redoContent = new String(StringContent.this.content, this.start, this.length);
                StringContent.this.remove(this.start, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() {
            super.redo();
            try {
                StringContent.this.insertString(this.start, this.redoContent);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }

        public InsertUndo(int n, int n2) {
            this.start = n;
            this.length = n2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RemoveUndo
    extends AbstractUndoableEdit {
        private int start;
        private String undoString;

        public void undo() {
            super.undo();
            try {
                StringContent.this.insertString(this.start, this.undoString);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() {
            super.redo();
            try {
                int n = this.undoString.length();
                StringContent.this.remove(this.start, n);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }

        public RemoveUndo(int n, String string) {
            this.start = n;
            this.undoString = string;
        }
    }
}

