/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.RMIClassLoaderSpi;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

public class RMIClassLoaderImpl
extends RMIClassLoaderSpi {
    private static RMIClassLoaderImpl instance = null;
    private static Map cacheLoaders = new Hashtable(89);
    private static Map cacheAnnotations = new Hashtable(89);
    private static MyClassLoader defaultClassLoader;
    private static String defaultAnnotation;
    private static URL defaultCodebase;

    public static RMIClassLoaderSpi getInstance() {
        if (instance == null) {
            instance = new RMIClassLoaderImpl();
        }
        return instance;
    }

    public Class loadClass(String codeBase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        ClassLoader loader = defaultLoader == null ? Thread.currentThread().getContextClassLoader() : defaultLoader;
        try {
            return Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException e) {
            loader = codeBase.length() == 0 ? defaultClassLoader : this.getClassLoader(codeBase);
            if (loader == null) {
                throw new ClassNotFoundException("Could not find class (" + name + ") at codebase (" + codeBase + ')');
            }
            return Class.forName(name, false, loader);
        }
    }

    public Class loadProxyClass(String codeBase, String[] interfaces, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        return null;
    }

    public ClassLoader getClassLoader(String codebase) throws MalformedURLException {
        CacheKey loaderKey = new CacheKey(codebase, Thread.currentThread().getContextClassLoader());
        ClassLoader loader = (ClassLoader)cacheLoaders.get(loaderKey);
        if (loader == null) {
            StringTokenizer tok = new StringTokenizer(codebase, " ");
            ArrayList urls = new ArrayList();
            while (tok.hasMoreTokens()) {
                urls.add(new URL(tok.nextToken()));
            }
            loader = new MyClassLoader((URL[])urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader(), codebase);
            cacheLoaders.put(loaderKey, loader);
        }
        return loader;
    }

    public String getClassAnnotation(Class cl) {
        ClassLoader loader = cl.getClassLoader();
        if (loader == null || loader == ClassLoader.getSystemClassLoader()) {
            return System.getProperty("java.rmi.server.codebase");
        }
        if (loader instanceof MyClassLoader) {
            return ((MyClassLoader)loader).getClassAnnotation();
        }
        String s = (String)cacheAnnotations.get(loader);
        if (s != null) {
            return s;
        }
        if (loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            if (urls.length == 0) {
                return null;
            }
            StringBuffer annotation = new StringBuffer(64 * urls.length);
            int i = 0;
            while (i < urls.length) {
                annotation.append(urls[i].toExternalForm());
                annotation.append(' ');
                ++i;
            }
            s = annotation.toString();
            cacheAnnotations.put(loader, s);
            return s;
        }
        return System.getProperty("java.rmi.server.codebase");
    }

    private RMIClassLoaderImpl() {
    }

    static {
        defaultAnnotation = System.getProperty("java.rmi.server.defaultAnnotation");
        try {
            if (defaultAnnotation != null) {
                defaultCodebase = new URL(defaultAnnotation);
            }
        }
        catch (Exception _) {
            defaultCodebase = null;
        }
        if (defaultCodebase != null) {
            defaultClassLoader = new MyClassLoader(new URL[]{defaultCodebase}, null, defaultAnnotation);
            cacheLoaders.put(new CacheKey(defaultAnnotation, Thread.currentThread().getContextClassLoader()), defaultClassLoader);
        }
    }

    private static class CacheKey {
        private String mCodeBase;
        private ClassLoader mContextClassLoader;

        public boolean equals(Object theOther) {
            if (theOther instanceof CacheKey) {
                CacheKey key = (CacheKey)theOther;
                boolean bl = false;
                if (this.equals(this.mCodeBase, key.mCodeBase) && this.equals(this.mContextClassLoader, key.mContextClassLoader)) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        private final boolean equals(Object theOne, Object theOther) {
            boolean bl;
            if (theOne != null) {
                bl = theOne.equals(theOther);
            } else {
                bl = false;
                if (theOther == null) {
                    bl = true;
                }
            }
            return bl;
        }

        public int hashCode() {
            int n = 0;
            if (this.mCodeBase != null) {
                n = this.mCodeBase.hashCode();
            }
            return n ^ (this.mContextClassLoader != null ? this.mContextClassLoader.hashCode() : -1);
        }

        public String toString() {
            return "[" + this.mCodeBase + ',' + this.mContextClassLoader + ']';
        }

        public CacheKey(String theCodebase, ClassLoader theContextClassLoader) {
            this.mCodeBase = theCodebase;
            this.mContextClassLoader = theContextClassLoader;
        }
    }

    private static class MyClassLoader
    extends URLClassLoader {
        private final String annotation;

        public static String urlToAnnotation(URL[] urls) {
            if (urls.length == 0) {
                return null;
            }
            StringBuffer annotation = new StringBuffer(64 * urls.length);
            int i = 0;
            while (i < urls.length) {
                annotation.append(urls[i].toExternalForm());
                annotation.append(' ');
                ++i;
            }
            return annotation.toString();
        }

        public final String getClassAnnotation() {
            return this.annotation;
        }

        MyClassLoader(URL[] urls, ClassLoader parent, String annotation) {
            super(urls, parent);
            this.annotation = annotation;
        }

        private MyClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.annotation = MyClassLoader.urlToAnnotation(urls);
        }
    }
}

