/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DomDocumentBuilder
extends DocumentBuilder {
    final DOMImplementation impl;
    final DOMImplementationLS ls;
    final LSParser parser;

    public boolean isNamespaceAware() {
        DOMConfiguration config = this.parser.getDomConfig();
        return (Boolean)config.getParameter("namespaces");
    }

    public boolean isValidating() {
        DOMConfiguration config = this.parser.getDomConfig();
        return (Boolean)config.getParameter("validating");
    }

    public boolean isXIncludeAware() {
        DOMConfiguration config = this.parser.getDomConfig();
        return (Boolean)config.getParameter("xinclude-aware");
    }

    public void setEntityResolver(EntityResolver resolver) {
        DOMConfiguration config = this.parser.getDomConfig();
        config.setParameter("entity-resolver", resolver);
    }

    public void setErrorHandler(ErrorHandler handler) {
        DOMConfiguration config = this.parser.getDomConfig();
        config.setParameter("error-handler", handler);
    }

    public DOMImplementation getDOMImplementation() {
        return this.impl;
    }

    public Document newDocument() {
        return this.impl.createDocument(null, null, null);
    }

    public Document parse(InputStream in) throws SAXException, IOException {
        LSInput input = this.ls.createLSInput();
        input.setByteStream(in);
        return this.parser.parse(input);
    }

    public Document parse(InputStream in, String systemId) throws SAXException, IOException {
        LSInput input = this.ls.createLSInput();
        input.setByteStream(in);
        input.setSystemId(systemId);
        return this.parser.parse(input);
    }

    public Document parse(String systemId) throws SAXException, IOException {
        return this.parser.parseURI(systemId);
    }

    public Document parse(InputSource is) throws SAXException, IOException {
        LSInput input = this.ls.createLSInput();
        String systemId = is.getSystemId();
        InputStream in = is.getByteStream();
        if (in != null) {
            input.setByteStream(in);
        } else {
            Reader reader = is.getCharacterStream();
            if (reader != null) {
                input.setCharacterStream(reader);
            } else {
                URL url = new URL(systemId);
                input.setByteStream(url.openStream());
            }
        }
        input.setPublicId(is.getPublicId());
        input.setSystemId(systemId);
        input.setEncoding(is.getEncoding());
        return this.parser.parse(input);
    }

    DomDocumentBuilder(DOMImplementation impl, DOMImplementationLS ls, LSParser parser) {
        this.impl = impl;
        this.ls = ls;
        this.parser = parser;
    }
}

