;;Example of a ViDAL (ViSta Data Analysis Language) script file.
;;Load this file with the Load-Edit command.

;;Univariate Analysis examples


(when *guidemap* (send *guidemap* :close))  
(show-workmap)

;;Single sample, known population variance
(load-data (strcat *examples-data-dir-name* "p30-97.lsp"))
(univariate-analysis :variable "MathSAT" :mu 460  :sigma 100 :direction 1)
(report-model)
(visualize-model)
(display-window "Visualization for single sample univariate analysis." 
                :size '(300 100) 
                :title "Single Sample")

;Two independent samples
(load-data (strcat *examples-data-dir-name* "univar" *separator* 
                   "independ" *separator* "reading.lsp"))
;(univariate-analysis :variable "DRP-Score" )
 (univariate-analysis :variable "DRP-Score" :class "Group")
(report-model)
(visualize-model)
(display-window "Visualization for two independent samples univariate analysis." 
                :size '(300 100) 
                :title "Single Sample")

;Single sample, unknown population variance
(load-data (strcat *examples-data-dir-name* "univar" *separator* 
                   "paired" *separator* "french.lsp"))
(univariate-analysis :variable "Difference" :direction 1)
(report-model)
(visualize-model)
(display-window "Visualization for single sample univariate analysis." 
                :size '(300 100) 
                :title "Single Sample")

;Two paired samples
(univariate-analysis :variable '("PostTest" "PreTest") :direction 1)
(report-model)
(visualize-model)
(display-window "Visualization for two paired samples univariate analysis." 
                :size '(300 100) 
                :title "Single Sample")

(vista-message "Example Finished")