/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.esd;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.lowlevel.esd.EsdRecordingStream;
import org.tritonus.sampled.mixer.esd.EsdUtils;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.mixer.TBaseDataLine;
import org.tritonus.share.sampled.mixer.TMixer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EsdTargetDataLine
extends TBaseDataLine
implements TargetDataLine {
    private EsdRecordingStream m_esdStream;
    private boolean m_bSwapBytes;
    private byte[] m_abSwapBuffer;
    private int m_nBytesPerSample;
    static /* synthetic */ Class class$javax$sound$sampled$TargetDataLine;

    protected void openImpl() {
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("EsdTargetDataLine.openImpl(): called.");
        }
        this.checkOpen();
        AudioFormat audioFormat = this.getFormat();
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        boolean bl = audioFormat.isBigEndian();
        this.m_bSwapBytes = false;
        if (audioFormat.getSampleSizeInBits() == 16 && bl) {
            this.m_bSwapBytes = true;
            bl = false;
        } else if (audioFormat.getSampleSizeInBits() == 8 && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            this.m_bSwapBytes = true;
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (this.m_bSwapBytes) {
            audioFormat = new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), bl);
            this.m_nBytesPerSample = audioFormat.getFrameSize() / audioFormat.getChannels();
        }
        int n = 0x1000 | EsdUtils.getEsdFormat(audioFormat);
        this.m_esdStream = new EsdRecordingStream();
        this.m_esdStream.open(n, (int)audioFormat.getSampleRate());
    }

    public int available() {
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) {
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("EsdTargetDataLine.read(): called.");
            TDebug.out("EsdTargetDataLine.read(): wanted length: " + n2);
        }
        int n3 = n;
        if (n2 > 0 && !this.isActive()) {
            this.start();
        }
        if (!this.isOpen() && TDebug.TraceTargetDataLine) {
            TDebug.out("EsdTargetDataLine.read(): stream closed");
        }
        int n4 = this.m_esdStream.read(byArray, n, n2);
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("EsdTargetDataLine.read(): read (bytes): " + n4);
        }
        if (this.m_bSwapBytes && n4 > 0) {
            TConversionTool.swapOrder16(byArray, n3, n4 / 2);
        }
        return n4;
    }

    public void closeImpl() {
        this.m_esdStream.close();
    }

    public void drain() {
    }

    public void flush() {
    }

    public long getPosition() {
        return 0L;
    }

    private final void setGain(float f) {
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public EsdTargetDataLine(TMixer tMixer, AudioFormat audioFormat, int n) throws LineUnavailableException {
        Class clazz = class$javax$sound$sampled$TargetDataLine;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$TargetDataLine = EsdTargetDataLine.class("[Ljavax.sound.sampled.TargetDataLine;", false);
        }
        super(tMixer, new DataLine.Info(clazz, audioFormat, n));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class EsdTargetDataLineGainControl
    extends FloatControl {
        public void setValue(float f) {
            if ((double)Math.abs((f = Math.max(Math.min(f, this.getMaximum()), this.getMinimum())) - this.getValue()) > 1.0E9) {
                super.setValue(f);
                EsdTargetDataLine.this.setGain(this.getValue());
            }
        }

        EsdTargetDataLineGainControl() {
            super(FloatControl.Type.VOLUME, -96.0f, 24.0f, 0.01f, 0, 0.0f, "dB", "-96.0", "", "+24.0");
        }
    }
}

