/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;
import lts.Alphabet;
import lts.CompactState;
import lts.EventState;

public class DrawMachine {
    public static int MAXDRAWSTATES = 64;
    static final int STATESIZE = 30;
    Font labelFont;
    Font nameFont;
    Font stateFont = new Font("SansSerif", 1, 18);
    protected boolean displayName = false;
    protected boolean newLabelFormat = true;
    protected boolean selectedMachine = false;
    int SEPARATION;
    int ARCINC;
    int topX = 0;
    int topY = 0;
    int zeroX;
    int zeroY;
    int heightAboveCenter;
    int nameWidth = 0;
    Dimension size;
    private int errorState = 0;
    private int lastselected = -3;
    private int selected = 0;
    private String lastaction;
    CompactState mach = null;
    JPanel parent;
    private int[] arrowX = new int[3];
    private int[] arrowY = new int[3];
    private static int arrowForward = 1;
    private static int arrowBackward = 2;
    private static int arrowDown = 3;
    String[][] labels;

    public DrawMachine(CompactState compactState, JPanel jPanel, Font font, Font font2, boolean bl, boolean bl2, int n, int n2) {
        this.mach = compactState;
        this.parent = jPanel;
        this.nameFont = font;
        this.labelFont = font2;
        this.displayName = bl;
        this.newLabelFormat = bl2;
        this.SEPARATION = n;
        this.ARCINC = n2;
        if (this.newLabelFormat) {
            this.initCompactLabels();
        }
        this.size = this.computeDimension(this.mach);
    }

    public void setDrawName(boolean bl) {
        this.displayName = bl;
        this.size = this.computeDimension(this.mach);
    }

    public void setNewLabelFormat(boolean bl) {
        this.newLabelFormat = bl;
        if (this.newLabelFormat) {
            this.initCompactLabels();
        }
        this.size = this.computeDimension(this.mach);
    }

    public void setFonts(Font font, Font font2) {
        this.nameFont = font;
        this.labelFont = font2;
        this.size = this.computeDimension(this.mach);
    }

    public void setStretch(boolean bl, int n, int n2) {
        if (bl) {
            this.SEPARATION = n;
            this.ARCINC = n2;
        } else {
            if (this.SEPARATION + n > 10) {
                this.SEPARATION += n;
            }
            if (this.ARCINC + n2 > 5) {
                this.ARCINC += n2;
            }
        }
        this.size = this.computeDimension(this.mach);
    }

    public void select(int n, int n2, String string) {
        this.lastselected = n;
        this.selected = n2;
        this.lastaction = string;
    }

    public void setPos(int n, int n2) {
        this.topX = n;
        this.topY = n2;
    }

    public boolean isSelected() {
        return this.selectedMachine;
    }

    public void setSelected(boolean bl) {
        this.selectedMachine = bl;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void getRect(Rectangle rectangle) {
        rectangle.x = this.topX;
        rectangle.y = this.topY;
        rectangle.width = this.size.width;
        rectangle.height = this.size.height;
    }

    public CompactState getMachine() {
        return this.mach;
    }

    protected Dimension computeDimension(CompactState compactState) {
        int n;
        int n2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n3 = 0;
        if (this.displayName) {
            object4 = this.parent.getGraphics();
            if (object4 != null) {
                ((Graphics)object4).setFont(this.nameFont);
                object3 = ((Graphics)object4).getFontMetrics();
                this.nameWidth = ((FontMetrics)object3).stringWidth(this.mach.name);
                n3 = ((FontMetrics)object3).getHeight();
            } else {
                this.nameWidth = this.SEPARATION;
            }
        } else {
            this.nameWidth = 0;
        }
        if (compactState.maxStates > MAXDRAWSTATES) {
            return new Dimension(220 + this.nameWidth, 50);
        }
        object4 = null;
        if (!this.newLabelFormat) {
            object3 = compactState.states[compactState.maxStates - 1];
            while (object3 != null) {
                object2 = object3;
                while (object2 != null) {
                    if (((EventState)object2).next == compactState.maxStates - 1) {
                        if (object4 == null) {
                            object4 = compactState.alphabet[((EventState)object2).event];
                        } else {
                            object = compactState.alphabet[((EventState)object2).event];
                            if (((String)object).length() > ((String)object4).length()) {
                                object4 = object;
                            }
                        }
                    }
                    object2 = ((EventState)object2).nondet;
                }
                object3 = ((EventState)object3).list;
            }
        } else {
            object4 = this.labels[compactState.maxStates][compactState.maxStates];
        }
        int n4 = 10;
        if (object4 != null) {
            object2 = this.parent.getGraphics();
            if (object2 != null) {
                ((Graphics)object2).setFont(this.labelFont);
                object = ((Graphics)object2).getFontMetrics();
                n4 = ((FontMetrics)object).stringWidth((String)object4);
                n4 += this.SEPARATION / 3;
            } else {
                n4 = this.SEPARATION;
            }
        }
        this.errorState = 0;
        int n5 = 0;
        while (n5 < compactState.maxStates) {
            if (EventState.hasState(compactState.states[n5], -1)) {
                this.errorState = 1;
            }
            ++n5;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < compactState.maxStates) {
            int[] nArray = new int[compactState.maxStates + 1];
            int n11 = 0;
            int n12 = 0;
            n2 = 0;
            n = 0;
            EventState eventState = compactState.states[n10];
            while (eventState != null) {
                EventState eventState2 = eventState;
                while (eventState2 != null) {
                    int n13 = eventState2.next + 1;
                    nArray[n13] = nArray[n13] + 1;
                    int n14 = eventState2.next - n10;
                    if (n14 > n6 || n14 == n6 && nArray[eventState2.next + 1] > n7) {
                        n6 = n14;
                        n11 = eventState2.next + 1;
                        n2 = 1;
                    }
                    if (n14 < n8 || n14 == n8 && nArray[eventState2.next + 1] > n9) {
                        n8 = n14;
                        n12 = eventState2.next + 1;
                        n = 1;
                    }
                    eventState2 = eventState2.nondet;
                }
                eventState = eventState.list;
            }
            if (n2 != 0) {
                int n15 = n7 = this.newLabelFormat ? 1 : nArray[n11];
            }
            if (n != 0) {
                n9 = this.newLabelFormat ? 1 : nArray[n12];
            }
            ++n10;
        }
        if (compactState.maxStates == 1) {
            n7 = 0;
        }
        int n16 = 10;
        Graphics graphics = this.parent.getGraphics();
        if (graphics != null) {
            graphics.setFont(this.labelFont);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n16 = fontMetrics.getHeight();
        }
        this.heightAboveCenter = n6 != 0 ? this.ARCINC * n6 / 2 : 15 + n3;
        this.heightAboveCenter = this.heightAboveCenter + n7 * n16 + 10;
        int n17 = n8 != 0 ? this.ARCINC * Math.abs(n8) / 2 : 15;
        n17 = n17 + n9 * n16 + 10;
        n2 = this.errorState == 0 ? 10 + this.nameWidth + 30 + n4 + (compactState.maxStates - 1) * this.SEPARATION : 40 + n4 + compactState.maxStates * this.SEPARATION;
        n = this.heightAboveCenter + n17;
        return new Dimension(n2, n);
    }

    public void fileDraw(Graphics graphics) {
        int n = this.topX;
        int n2 = this.topY;
        boolean bl = this.selectedMachine;
        this.topX = 0;
        this.topY = 0;
        this.selectedMachine = false;
        this.draw(graphics);
        this.topX = n;
        this.topY = n2;
        this.selectedMachine = bl;
    }

    public void draw(Graphics graphics) {
        CompactState compactState = this.mach;
        if (compactState == null) {
            return;
        }
        if (this.selectedMachine) {
            graphics.setColor(Color.white);
            graphics.fillRect(this.topX, this.topY, this.size.width, this.size.height);
        }
        int n = 0;
        if (this.displayName && this.errorState == 0) {
            n = this.nameWidth;
        }
        this.zeroX = this.topX + 10 + this.errorState * this.SEPARATION + n;
        this.zeroY = this.topY + this.heightAboveCenter - 15;
        if (compactState.maxStates > MAXDRAWSTATES) {
            graphics.setColor(Color.black);
            graphics.setFont(this.nameFont);
            graphics.drawString(compactState.name + " -- too many states: " + compactState.maxStates, this.topX, this.topY + 20);
        } else {
            Object object;
            Object object2;
            Object object3;
            graphics.setFont(this.nameFont);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = fontMetrics.stringWidth(compactState.name);
            graphics.setColor(Color.black);
            if (this.displayName) {
                graphics.drawString(compactState.name, this.zeroX - n2, this.zeroY - 5);
            }
            int n3 = 0;
            while (n3 < compactState.maxStates) {
                int[] nArray = new int[compactState.maxStates + 1];
                object3 = compactState.states[n3];
                while (object3 != null) {
                    object2 = object3;
                    object = compactState.alphabet[((EventState)object2).event];
                    while (object2 != null) {
                        int n4 = ((EventState)object2).next + 1;
                        nArray[n4] = nArray[n4] + 1;
                        this.drawTransition(graphics, n3, ((EventState)object2).next, (String)object, nArray[((EventState)object2).next + 1], n3 == this.lastselected && ((EventState)object2).next == this.selected, false);
                        object2 = ((EventState)object2).nondet;
                    }
                    object3 = ((EventState)object3).list;
                }
                ++n3;
            }
            int n5 = 0;
            while (n5 < compactState.maxStates) {
                object3 = new int[compactState.maxStates + 1];
                object2 = compactState.states[n5];
                while (object2 != null) {
                    object = object2;
                    String string = compactState.alphabet[((EventState)object).event];
                    while (object != null) {
                        Object object4 = object3;
                        int n6 = ((EventState)object).next + 1;
                        object4[n6] = object4[n6] + true;
                        if (!this.newLabelFormat) {
                            this.drawTransition(graphics, n5, ((EventState)object).next, string, (int)object3[((EventState)object).next + 1], n5 == this.lastselected && ((EventState)object).next == this.selected, true);
                        } else if (object3[((EventState)object).next + 1] == true) {
                            this.drawTransition(graphics, n5, ((EventState)object).next, this.labels[n5 + 1][((EventState)object).next + 1], (int)object3[((EventState)object).next + 1], n5 == this.lastselected && ((EventState)object).next == this.selected, true);
                        }
                        object = ((EventState)object).nondet;
                    }
                    object2 = ((EventState)object2).list;
                }
                ++n5;
            }
            int n7 = -this.errorState;
            while (n7 < compactState.maxStates) {
                this.drawState(graphics, n7, n7 == this.selected);
                ++n7;
            }
        }
        if (this.selectedMachine) {
            graphics.setColor(Color.gray);
            graphics.drawRect(this.topX, this.topY, this.size.width, this.size.height);
        }
    }

    private void drawState(Graphics graphics, int n, boolean bl) {
        int n2 = this.zeroX + n * this.SEPARATION;
        int n3 = this.zeroY;
        if (bl) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.cyan);
        }
        graphics.fillArc(n2, n3, 30, 30, 0, 360);
        graphics.setColor(Color.black);
        graphics.setFont(this.stateFont);
        graphics.drawArc(n2, n3, 30, 30, 0, 360);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = n == this.mach.endseq ? "E" : "" + n;
        int n4 = n2 + 15 - fontMetrics.stringWidth(string) / 2;
        int n5 = n3 + 15 + fontMetrics.getHeight() / 3;
        graphics.drawString(string, n4, n5);
    }

    private void drawTransition(Graphics graphics, int n, int n2, String string, int n3, boolean bl, boolean bl2) {
        int n4;
        if (bl) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.black);
        }
        int n5 = n2 <= n ? -1 : 1;
        int n6 = n2 < n ? n2 : n;
        int n7 = this.zeroX + n6 * this.SEPARATION + 15;
        int n8 = n2 != n ? this.SEPARATION * Math.abs(n - n2) : this.SEPARATION / 3;
        int n9 = n2 != n ? this.ARCINC * Math.abs(n - n2) : 25;
        int n10 = this.zeroY - (n9 - 30) / 2;
        if (n3 == 1 && !bl2) {
            if (n != n2) {
                graphics.drawArc(n7, n10, n8, n9, 0, 180 * n5);
                if (n5 > 0) {
                    this.drawArrow(graphics, n7 + n8 / 2, n10, arrowForward);
                } else {
                    this.drawArrow(graphics, n7 + n8 / 2, n10 + n9 - 1, arrowBackward);
                }
            } else {
                graphics.drawArc(n7, n10, n8, n9, 0, 360);
                this.drawArrow(graphics, n7 + n8, n10 + n9 / 2, arrowDown);
            }
        }
        if (!bl2) {
            return;
        }
        ++n3;
        graphics.setFont(this.labelFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n11 = fontMetrics.getMaxAscent() / 3;
        int n12 = n7 + n8 / 2 - fontMetrics.stringWidth(string) / 2;
        if (n2 == n) {
            n12 = n7 + n8 + 2;
        }
        int n13 = n4 = n5 > 0 ? n10 + n11 : n10 + n9 + n11;
        if (n2 == n) {
            n4 = n10 + n9 / 2 + n11;
        }
        if (n3 > 1) {
            n4 -= (n3 - 1) * fontMetrics.getHeight() * n5;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(n12, n4 - fontMetrics.getMaxAscent(), fontMetrics.stringWidth(string), fontMetrics.getHeight());
        if (bl && (this.lastaction != null && this.lastaction.equals(string) || this.newLabelFormat)) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.drawString(string, n12, n4);
    }

    private void drawArrow(Graphics graphics, int n, int n2, int n3) {
        if (n3 == arrowForward) {
            this.arrowX[0] = n - 5;
            this.arrowY[0] = n2 - 5;
            this.arrowX[1] = n + 5;
            this.arrowY[1] = n2;
            this.arrowX[2] = n - 5;
            this.arrowY[2] = n2 + 5;
        } else if (n3 == arrowBackward) {
            this.arrowX[0] = n + 5;
            this.arrowY[0] = n2 - 5;
            this.arrowX[1] = n - 5;
            this.arrowY[1] = n2;
            this.arrowX[2] = n + 5;
            this.arrowY[2] = n2 + 5;
        } else if (n3 == arrowDown) {
            this.arrowX[0] = n - 5;
            this.arrowY[0] = n2 - 5;
            this.arrowX[1] = n + 5;
            this.arrowY[1] = n2 - 5;
            this.arrowX[2] = n;
            this.arrowY[2] = n2 + 5;
        }
        graphics.fillPolygon(this.arrowX, this.arrowY, 3);
    }

    private void initCompactLabels() {
        if (this.mach == null) {
            return;
        }
        if (this.mach.maxStates > MAXDRAWSTATES) {
            return;
        }
        this.labels = new String[this.mach.maxStates + 1][this.mach.maxStates + 1];
        int n = 0;
        while (n < this.mach.maxStates) {
            EventState eventState = EventState.transpose(this.mach.states[n]);
            while (eventState != null) {
                String[] stringArray = EventState.eventsToNext(eventState, this.mach.alphabet);
                Alphabet alphabet = new Alphabet(stringArray);
                this.labels[n + 1][eventState.next + 1] = alphabet.toString();
                eventState = eventState.list;
            }
            ++n;
        }
    }
}

