require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SPU2VMX_H_)) {
    eval 'sub _SPU2VMX_H_ () {1;}' unless defined(&_SPU2VMX_H_);
    if(defined(&__cplusplus)) {
	unless(defined(&__SPU__)) {
	    require 'si2vmx.ph';
	    eval 'sub spu_add {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_a(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_add);
	    eval 'sub spu_add {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_ah(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_add);
	    eval 'sub spu_add {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_ah(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_add);
	    eval 'sub spu_add {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_ai(( &qword), ($b)))); });
	    }' unless defined(&spu_add);
	    eval 'sub spu_add {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_ai(( &qword)($a), $b))); });
	    }' unless defined(&spu_add);
	    eval 'sub spu_add {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_ahi(( &qword), ($b)))); });
	    }' unless defined(&spu_add);
	    eval 'sub spu_add {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_ahi(( &qword)($a), $b))); });
	    }' unless defined(&spu_add);
	    eval 'sub spu_add {
	        my($a,$b) = @_;
    		eval q({ (( &vec_float4)( &si_fa(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_add);
	    eval 'sub spu_add {
	        my($a,$b) = @_;
    		eval q({ (( &vec_double2)( &si_dfa(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_add);
	    eval 'sub spu_addx {
	        my($a,$b,$c) = @_;
    		eval q({ (( &vec_int4)( &si_addx(( &qword)($a), ( &qword)($b), ( &qword)($c)))); });
	    }' unless defined(&spu_addx);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &vec_char16)( &si_and(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_and(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_and(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_and(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_and(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &vec_float4)( &si_and(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &si_and(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &si_and(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &vec_double2)( &si_and(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uchar16)( &si_andbi(( &qword), ($b)))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &vec_char16)( &si_andbi(( &qword)($a), $b))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_andhi(( &qword), ($b)))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_andhi(( &qword)($a), $b))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_andi(( &qword), ($b)))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_and {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_andi(( &qword)($a), $b))); });
	    }' unless defined(&spu_and);
	    eval 'sub spu_andc {
	        my($_a, $_b) = @_;
    		eval q( &vec_andc($_a, $_b));
	    }' unless defined(&spu_andc);
	    eval 'sub spu_avg {
	        my($_a, $_b) = @_;
    		eval q( &vec_avg($_a, $_b));
	    }' unless defined(&spu_avg);
	    eval 'sub spu_bisled {
	        my($_func) = @_;
    		eval q();
	    }' unless defined(&spu_bisled);
	    eval 'sub spu_bisled_d {
	        my($_func) = @_;
    		eval q();
	    }' unless defined(&spu_bisled_d);
	    eval 'sub spu_bisled_e {
	        my($_func) = @_;
    		eval q();
	    }' unless defined(&spu_bisled_e);
	    eval 'sub spu_cmpabseq {
	        my($a,$b) = @_;
    		eval q({ (( &si_dfcmeq(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpabseq);
	    eval 'sub spu_cmpabsgt {
	        my($a,$b) = @_;
    		eval q({ (( &si_dfcmgt(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpabsgt);
	    eval 'sub spu_cmpeq {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uchar16)( &si_ceqb(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpeq);
	    eval 'sub spu_cmpeq {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_ceqh(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpeq);
	    eval 'sub spu_cmpeq {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_ceqh(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpeq);
	    eval 'sub spu_cmpeq {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_ceq(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpeq);
	    eval 'sub spu_cmpeq {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_ceq(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpeq);
	    eval 'sub spu_cmpeq {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_fceq(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpeq);
	    eval 'sub spu_cmpeq {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uchar16)( &si_ceqbi(( &qword), ($b)))); });
	    }' unless defined(&spu_cmpeq);
	    eval 'sub spu_cmpeq {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uchar16)( &si_ceqbi(( &qword)($a), $b))); });
	    }' unless defined(&spu_cmpeq);
	    eval 'sub spu_cmpeq {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_ceqhi(( &qword), ($b)))); });
	    }' unless defined(&spu_cmpeq);
	    eval 'sub spu_cmpeq {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_ceqhi(( &qword)($a), $b))); });
	    }' unless defined(&spu_cmpeq);
	    eval 'sub spu_cmpeq {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_ceqi(( &qword), ($b)))); });
	    }' unless defined(&spu_cmpeq);
	    eval 'sub spu_cmpeq {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_ceqi(( &qword)($a), $b))); });
	    }' unless defined(&spu_cmpeq);
	    eval 'sub spu_cmpeq {
	        my($a,$b) = @_;
    		eval q({ (( &si_dfceq(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpeq);
	    eval 'sub spu_cmpgt {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uchar16)( &si_cgtb(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpgt);
	    eval 'sub spu_cmpgt {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_clgth(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpgt);
	    eval 'sub spu_cmpgt {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_cgth(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpgt);
	    eval 'sub spu_cmpgt {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_clgt(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpgt);
	    eval 'sub spu_cmpgt {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_cgt(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpgt);
	    eval 'sub spu_cmpgt {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_fcgt(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpgt);
	    eval 'sub spu_cmpgt {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uchar16)( &si_clgtbi(( &qword)($a), $b))); });
	    }' unless defined(&spu_cmpgt);
	    eval 'sub spu_cmpgt {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uchar16)( &si_cgtbi(( &qword)($a), $b))); });
	    }' unless defined(&spu_cmpgt);
	    eval 'sub spu_cmpgt {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_clgthi(( &qword)($a), $b))); });
	    }' unless defined(&spu_cmpgt);
	    eval 'sub spu_cmpgt {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_cgthi(( &qword)($a), $b))); });
	    }' unless defined(&spu_cmpgt);
	    eval 'sub spu_cmpgt {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_clgti(( &qword)($a), $b))); });
	    }' unless defined(&spu_cmpgt);
	    eval 'sub spu_cmpgt {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_cgti(( &qword)($a), $b))); });
	    }' unless defined(&spu_cmpgt);
	    eval 'sub spu_cmpgt {
	        my($a,$b) = @_;
    		eval q({ (( &si_dfcgt(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_cmpgt);
	    eval 'sub spu_cntb {
	        my($a) = @_;
    		eval q({ (( &vec_uchar16)( &si_cntb(( &qword)($a)))); });
	    }' unless defined(&spu_cntb);
	    eval 'sub spu_cntlz {
	        my($a) = @_;
    		eval q({ (( &vec_uint4)( &si_clz(( &qword)($a)))); });
	    }' unless defined(&spu_cntlz);
	    eval 'sub spu_cntlz {
	        my($a) = @_;
    		eval q({ (( &vec_uint4)( &si_clz(( &qword)($a)))); });
	    }' unless defined(&spu_cntlz);
	    eval 'sub spu_convtf {
	        my($_a, $_b) = @_;
    		eval q(( &vec_ctf($_a, $_b)));
	    }' unless defined(&spu_convtf);
	    eval 'sub spu_convts {
	        my($_a, $_b) = @_;
    		eval q(( &vec_cts($_a, $_b)));
	    }' unless defined(&spu_convts);
	    eval 'sub spu_convtu {
	        my($_a, $_b) = @_;
    		eval q(( &vec_ctu($_a, $_b)));
	    }' unless defined(&spu_convtu);
	    eval 'sub spu_dsync () {
	        eval q();
	    }' unless defined(&spu_dsync);
	    eval 'sub spu_eqv {
	        my($a,$b) = @_;
    		eval q({ (( &vec_char16)( &si_eqv(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_eqv);
	    eval 'sub spu_eqv {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_eqv(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_eqv);
	    eval 'sub spu_eqv {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_eqv(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_eqv);
	    eval 'sub spu_eqv {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_eqv(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_eqv);
	    eval 'sub spu_eqv {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_eqv(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_eqv);
	    eval 'sub spu_eqv {
	        my($a,$b) = @_;
    		eval q({ (( &vec_float4)( &si_eqv(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_eqv);
	    eval 'sub spu_eqv {
	        my($a,$b) = @_;
    		eval q({ (( &si_eqv(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_eqv);
	    eval 'sub spu_eqv {
	        my($a,$b) = @_;
    		eval q({ (( &si_eqv(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_eqv);
	    eval 'sub spu_eqv {
	        my($a,$b) = @_;
    		eval q({ (( &vec_double2)( &si_eqv(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_eqv);
	    eval 'sub spu_extend {
	        my($a) = @_;
    		eval q({ (( &vec_int4)( &si_xshw(( &qword)($a)))); });
	    }' unless defined(&spu_extend);
	    eval 'sub spu_extend {
	        my($a) = @_;
    		eval q({ (( &si_xswd(( &qword)($a)))); });
	    }' unless defined(&spu_extend);
	    eval 'sub spu_extend {
	        my($a) = @_;
    		eval q({ (( &vec_double2)( &si_fesd(( &qword)($a)))); });
	    }' unless defined(&spu_extend);
	    eval 'sub spu_extract {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_char16  &v; my $c[16]; }  &in;  ($in->{v}) = $a; ( ($in->{c[$element & 15]})); });
	    }' unless defined(&spu_extract);
	    eval 'sub spu_extract {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_ushort8  &v; my $s[8]; }  &in;  ($in->{v}) = $a; ( ($in->{s[$element & 7]})); });
	    }' unless defined(&spu_extract);
	    eval 'sub spu_extract {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_short8  &v; my $s[8]; }  &in;  ($in->{v}) = $a; ( ($in->{s[$element & 7]})); });
	    }' unless defined(&spu_extract);
	    eval 'sub spu_extract {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_uint4  &v; my $i[4]; }  &in;  ($in->{v}) = $a; ( ($in->{i[$element & 3]})); });
	    }' unless defined(&spu_extract);
	    eval 'sub spu_extract {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_int4  &v; my $i[4]; }  &in;  ($in->{v}) = $a; ( ($in->{i[$element & 3]})); });
	    }' unless defined(&spu_extract);
	    eval 'sub spu_extract {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_float4  &v; \'float\'  $f[4]; }  &in;  ($in->{v}) = $a; ( ($in->{f[$element & 3]})); });
	    }' unless defined(&spu_extract);
	    eval 'sub spu_extract {
	        my($a,$element) = @_;
    		eval q({ \'union union\' { my $v; my $l[2]; }  &in;  ($in->{v}) = $a; ( ($in->{l[$element & 1]})); });
	    }' unless defined(&spu_extract);
	    eval 'sub spu_extract {
	        my($a,$element) = @_;
    		eval q({ \'union union\' { my $v; my $l[2]; }  &in;  ($in->{v}) = $a; ( ($in->{l[$element & 1]})); });
	    }' unless defined(&spu_extract);
	    eval 'sub spu_extract {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_double2  &v; \'double\'  $d[2]; }  &in;  ($in->{v}) = $a; ( ($in->{d[$element & 1]})); });
	    }' unless defined(&spu_extract);
	    eval 'sub spu_gather {
	        my($a) = @_;
    		eval q({ (( &vec_uint4)( &si_gbb(( &qword)($a)))); });
	    }' unless defined(&spu_gather);
	    eval 'sub spu_gather {
	        my($a) = @_;
    		eval q({ (( &vec_uint4)( &si_gbh(( &qword)($a)))); });
	    }' unless defined(&spu_gather);
	    eval 'sub spu_gather {
	        my($a) = @_;
    		eval q({ (( &vec_uint4)( &si_gbh(( &qword)($a)))); });
	    }' unless defined(&spu_gather);
	    eval 'sub spu_gather {
	        my($a) = @_;
    		eval q({ (( &vec_uint4)( &si_gb(( &qword)($a)))); });
	    }' unless defined(&spu_gather);
	    eval 'sub spu_gather {
	        my($a) = @_;
    		eval q({ (( &vec_uint4)( &si_gb(( &qword)($a)))); });
	    }' unless defined(&spu_gather);
	    eval 'sub spu_gather {
	        my($a) = @_;
    		eval q({ (( &vec_uint4)( &si_gb(( &qword)($a)))); });
	    }' unless defined(&spu_gather);
	    eval 'sub spu_genb {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_bg(( &qword)($b), ( &qword)($a)))); });
	    }' unless defined(&spu_genb);
	    eval 'sub spu_genbx {
	        my($a,$b,$c) = @_;
    		eval q({ (( &vec_int4)( &si_bgx(( &qword)($b), ( &qword)($a), ( &qword)($c)))); });
	    }' unless defined(&spu_genbx);
	    eval 'sub spu_genc {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_cg(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_genc);
	    eval 'sub spu_gencx {
	        my($a,$b,$c) = @_;
    		eval q({ (( &vec_int4)( &si_cgx(( &qword)($a), ( &qword)($b), ( &qword)($c)))); });
	    }' unless defined(&spu_gencx);
	    eval 'sub spu_hcmpeq {
	        my($_a, $_b) = @_;
    		eval q( &if ($_a == $_b) {  &SPU_HALT_ACTION; };);
	    }' unless defined(&spu_hcmpeq);
	    eval 'sub spu_hcmpgt {
	        my($_a, $_b) = @_;
    		eval q( &if ($_a > $_b) {  &SPU_HALT_ACTION; };);
	    }' unless defined(&spu_hcmpgt);
	    eval 'sub spu_idisable () {
	        eval q( &SPU_UNSUPPORTED_ACTION);
	    }' unless defined(&spu_idisable);
	    eval 'sub spu_ienable () {
	        eval q( &SPU_UNSUPPORTED_ACTION);
	    }' unless defined(&spu_ienable);
	    eval 'sub spu_insert {
	        my($a,$b,$element) = @_;
    		eval q({ (( &vec_char16) &spu_insert(($a), ( &vec_uchar16)($b), $element)); });
	    }' unless defined(&spu_insert);
	    eval 'sub spu_insert {
	        my($a,$b,$element) = @_;
    		eval q({ \'union union\' {  &vec_ushort8  &v; my $s[8]; }  &in;  ($in->{v}) = $b;  ($in->{s[$element & 7]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_insert);
	    eval 'sub spu_insert {
	        my($a,$b,$element) = @_;
    		eval q({ (( &vec_short8) &spu_insert(($a), ( &vec_ushort8)($b), $element)); });
	    }' unless defined(&spu_insert);
	    eval 'sub spu_insert {
	        my($a,$b,$element) = @_;
    		eval q({ \'union union\' {  &vec_uint4  &v; my $i[4]; }  &in;  ($in->{v}) = $b;  ($in->{i[$element & 3]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_insert);
	    eval 'sub spu_insert {
	        my($a,$b,$element) = @_;
    		eval q({ (( &vec_int4) &spu_insert(($a), ( &vec_uint4)($b), $element)); });
	    }' unless defined(&spu_insert);
	    eval 'sub spu_insert {
	        my($a,$b,$element) = @_;
    		eval q({ \'union union\' {  &vec_float4  &v; \'float\'  $f[4]; }  &in;  ($in->{v}) = $b;  ($in->{f[$element & 3]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_insert);
	    eval 'sub spu_insert {
	        my($a,$b,$element) = @_;
    		eval q({ \'union union\' { my $v; my $l[2]; }  &in;  ($in->{v}) = $b;  ($in->{l[$element & 1]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_insert);
	    eval 'sub spu_insert {
	        my($a,$b,$element) = @_;
    		eval q({ ( &spu_insert(, ($b), $element)); });
	    }' unless defined(&spu_insert);
	    eval 'sub spu_insert {
	        my($a,$b,$element) = @_;
    		eval q({ \'union union\' {  &vec_double2  &v; \'double\'  $d[2]; }  &in;  ($in->{v}) = $b;  ($in->{d[$element & 1]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_insert);
	    eval 'sub spu_madd {
	        my($a,$b,$c) = @_;
    		eval q({ (( &vec_float4)( &si_fma(( &qword)($a), ( &qword)($b), ( &qword)($c)))); });
	    }' unless defined(&spu_madd);
	    eval 'sub spu_madd {
	        my($a,$b,$c) = @_;
    		eval q({ (( &vec_double2)( &si_dfma(( &qword)($a), ( &qword)($b), ( &qword)($c)))); });
	    }' unless defined(&spu_madd);
	    eval 'sub spu_maskb {
	        my($_a) = @_;
    		eval q(( &vec_uchar16)( &si_fsmb( &si_from_int(($_a)))));
	    }' unless defined(&spu_maskb);
	    eval 'sub spu_maskh {
	        my($_a) = @_;
    		eval q(( &vec_ushort8)( &si_fsmh( &si_from_int(($_a)))));
	    }' unless defined(&spu_maskh);
	    eval 'sub spu_maskw {
	        my($_a) = @_;
    		eval q(( &vec_uint4)( &si_fsm( &si_from_int(($_a)))));
	    }' unless defined(&spu_maskw);
	    eval 'sub spu_mfcdma32 {
	        my($_ls, $_ea, $_size, $_tagid, $_cmd) = @_;
    		eval q();
	    }' unless defined(&spu_mfcdma32);
	    eval 'sub spu_mfcdma64 {
	        my($_ls, $_eahi, $_ealow,  $_size, $_tagid, $_cmd) = @_;
    		eval q();
	    }' unless defined(&spu_mfcdma64);
	    eval 'sub spu_mfcstat {
	        my($_type) = @_;
    		eval q(0xffffffff);
	    }' unless defined(&spu_mfcstat);
	    eval 'sub spu_mffpscr () {
	        eval q(( &vec_uint4)( &si_fscrrd()));
	    }' unless defined(&spu_mffpscr);
	    eval 'sub spu_mfspr {
	        my($_reg) = @_;
    		eval q( &si_to_uint( &si_mfspr($_reg)));
	    }' unless defined(&spu_mfspr);
	    eval 'sub spu_mhhadd {
	        my($a,$b,$c) = @_;
    		eval q({ (( &vec_uint4)( &si_mpyhhau(( &qword)($a), ( &qword)($b), ( &qword)($c)))); });
	    }' unless defined(&spu_mhhadd);
	    eval 'sub spu_msub {
	        my($a,$b,$c) = @_;
    		eval q({ (( &vec_double2)( &si_dfms(( &qword)($a), ( &qword)($b), ( &qword)($c)))); });
	    }' unless defined(&spu_msub);
	    eval 'sub spu_mtfpscr {
	        my($_a) = @_;
    		eval q();
	    }' unless defined(&spu_mtfpscr);
	    eval 'sub spu_mtspr {
	        my($_reg, $_a) = @_;
    		eval q();
	    }' unless defined(&spu_mtspr);
	    eval 'sub spu_mul {
	        my($a,$b) = @_;
    		eval q({ (( &vec_double2)( &si_dfm(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_mul);
	    eval 'sub spu_mule {
	        my($_a, $_b) = @_;
    		eval q( &vec_mule($_a, $_b));
	    }' unless defined(&spu_mule);
	    eval 'sub spu_mulo {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_mpyu(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_mulo);
	    eval 'sub spu_mulo {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_mpyi(( &qword)($a), $b))); });
	    }' unless defined(&spu_mulo);
	    eval 'sub spu_mulo {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_mpyui(( &qword)($a), $b))); });
	    }' unless defined(&spu_mulo);
	    eval 'sub spu_nand {
	        my($a,$b) = @_;
    		eval q({ (( &vec_char16)( &si_nand(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_nand);
	    eval 'sub spu_nand {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_nand(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_nand);
	    eval 'sub spu_nand {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_nand(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_nand);
	    eval 'sub spu_nand {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_nand(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_nand);
	    eval 'sub spu_nand {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_nand(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_nand);
	    eval 'sub spu_nand {
	        my($a,$b) = @_;
    		eval q({ (( &vec_float4)( &si_nand(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_nand);
	    eval 'sub spu_nand {
	        my($a,$b) = @_;
    		eval q({ (( &si_nand(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_nand);
	    eval 'sub spu_nand {
	        my($a,$b) = @_;
    		eval q({ (( &si_nand(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_nand);
	    eval 'sub spu_nand {
	        my($a,$b) = @_;
    		eval q({ (( &vec_double2)( &si_nand(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_nand);
	    eval 'sub spu_nmsub {
	        my($a,$b,$c) = @_;
    		eval q({ (( &vec_double2)( &si_dfnms(( &qword)($a), ( &qword)($b), ( &qword)($c)))); });
	    }' unless defined(&spu_nmsub);
	    eval 'sub spu_nor {
	        my($_a, $_b) = @_;
    		eval q( &vec_nor($_a, $_b));
	    }' unless defined(&spu_nor);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &vec_char16)( &si_or(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_or(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_or(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_or(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_or(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &vec_float4)( &si_or(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &si_or(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &si_or(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &vec_double2)( &si_or(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uchar16)( &si_orbi(( &qword)($a), $b))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &vec_char16)( &si_orbi(( &qword), ($b)))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_orhi(( &qword)($a), $b))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_orhi(( &qword), ($b)))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_ori(( &qword)($a), $b))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_or {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_ori(( &qword), ($b)))); });
	    }' unless defined(&spu_or);
	    eval 'sub spu_orc {
	        my($_a, $_b) = @_;
    		eval q( &vec_or($_a,  &vec_nor($_b, $_b)));
	    }' unless defined(&spu_orc);
	    eval 'sub spu_orx {
	        my($a) = @_;
    		eval q({ (( &vec_int4)( &si_orx(( &qword)($a)))); });
	    }' unless defined(&spu_orx);
	    eval 'sub spu_promote {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_char16  &v; my $c[16]; }  &in;  ($in->{c[$element & 15]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_promote);
	    eval 'sub spu_promote {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_ushort8  &v; my $s[8]; }  &in;  ($in->{s[$element & 7]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_promote);
	    eval 'sub spu_promote {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_short8  &v; my $s[8]; }  &in;  ($in->{s[$element & 7]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_promote);
	    eval 'sub spu_promote {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_uint4  &v; my $i[4]; }  &in;  ($in->{i[$element & 3]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_promote);
	    eval 'sub spu_promote {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_int4  &v; my $i[4]; }  &in;  ($in->{i[$element & 3]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_promote);
	    eval 'sub spu_promote {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_float4  &v; \'float\'  $f[4]; }  &in;  ($in->{f[$element & 3]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_promote);
	    eval 'sub spu_promote {
	        my($a,$element) = @_;
    		eval q({ \'union union\' { my $v; my $l[2]; }  &in;  ($in->{l[$element & 1]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_promote);
	    eval 'sub spu_promote {
	        my($a,$element) = @_;
    		eval q({ \'union union\' { my $v; my $l[2]; }  &in;  ($in->{l[$element & 1]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_promote);
	    eval 'sub spu_promote {
	        my($a,$element) = @_;
    		eval q({ \'union union\' {  &vec_double2  &v; \'double\'  $d[2]; }  &in;  ($in->{d[$element & 1]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_promote);
	    eval 'sub spu_re {
	        my($_a) = @_;
    		eval q( &vec_re($_a));
	    }' unless defined(&spu_re);
	    eval 'sub spu_readch {
	        my($_channel) = @_;
    		eval q(0);
	    }' unless defined(&spu_readch);
	    eval 'sub spu_readchcnt {
	        my($_channel) = @_;
    		eval q(0);
	    }' unless defined(&spu_readchcnt);
	    eval 'sub spu_readchqw {
	        my($_channel) = @_;
    		eval q( &__extension__ ({  &vec_uint4  &result = { 0, 0, 0, 0};  &result; }));
	    }' unless defined(&spu_readchqw);
	    eval 'sub spu_rl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_roth(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_rl);
	    eval 'sub spu_rl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_rot(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_rl);
	    eval 'sub spu_rl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_rot(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_rl);
	    eval 'sub spu_rl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_rothi(( &qword)($a), $b))); });
	    }' unless defined(&spu_rl);
	    eval 'sub spu_rl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_rothi(( &qword)($a), $b))); });
	    }' unless defined(&spu_rl);
	    eval 'sub spu_rl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_roti(( &qword)($a), $b))); });
	    }' unless defined(&spu_rl);
	    eval 'sub spu_rl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_roti(( &qword)($a), $b))); });
	    }' unless defined(&spu_rl);
	    eval 'sub spu_rlmask {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_rothm(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_rlmask);
	    eval 'sub spu_rlmask {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_rotm(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_rlmask);
	    eval 'sub spu_rlmask {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_rotm(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_rlmask);
	    eval 'sub spu_rlmask {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_rothmi(( &qword)($a), $b))); });
	    }' unless defined(&spu_rlmask);
	    eval 'sub spu_rlmask {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_rothmi(( &qword)($a), $b))); });
	    }' unless defined(&spu_rlmask);
	    eval 'sub spu_rlmask {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_rotmi(( &qword)($a), $b))); });
	    }' unless defined(&spu_rlmask);
	    eval 'sub spu_rlmask {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_rotmi(( &qword)($a), $b))); });
	    }' unless defined(&spu_rlmask);
	    eval 'sub spu_rlmaska {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_rotmah(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_rlmaska);
	    eval 'sub spu_rlmaska {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_rotma(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_rlmaska);
	    eval 'sub spu_rlmaska {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_rotma(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_rlmaska);
	    eval 'sub spu_rlmaska {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_rotmahi(( &qword)($a), $b))); });
	    }' unless defined(&spu_rlmaska);
	    eval 'sub spu_rlmaska {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_rotmahi(( &qword)($a), $b))); });
	    }' unless defined(&spu_rlmaska);
	    eval 'sub spu_rlmaska {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_rotmai(( &qword)($a), $b))); });
	    }' unless defined(&spu_rlmaska);
	    eval 'sub spu_rlmaska {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_rotmai(( &qword)($a), $b))); });
	    }' unless defined(&spu_rlmaska);
	    eval 'sub spu_rlmaskqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_char16)( &si_rotqmbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqw);
	    eval 'sub spu_rlmaskqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_ushort8)( &si_rotqmbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqw);
	    eval 'sub spu_rlmaskqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_short8)( &si_rotqmbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqw);
	    eval 'sub spu_rlmaskqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_uint4)( &si_rotqmbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqw);
	    eval 'sub spu_rlmaskqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_int4)( &si_rotqmbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqw);
	    eval 'sub spu_rlmaskqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_float4)( &si_rotqmbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqw);
	    eval 'sub spu_rlmaskqw {
	        my($a,$count) = @_;
    		eval q({ (( &si_rotqmbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqw);
	    eval 'sub spu_rlmaskqw {
	        my($a,$count) = @_;
    		eval q({ (( &si_rotqmbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqw);
	    eval 'sub spu_rlmaskqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_double2)( &si_rotqmbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqw);
	    eval 'sub spu_rlmaskqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_char16)( &si_rotqmby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbyte);
	    eval 'sub spu_rlmaskqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_ushort8)( &si_rotqmby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbyte);
	    eval 'sub spu_rlmaskqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_short8)( &si_rotqmby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbyte);
	    eval 'sub spu_rlmaskqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_uint4)( &si_rotqmby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbyte);
	    eval 'sub spu_rlmaskqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_int4)( &si_rotqmby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbyte);
	    eval 'sub spu_rlmaskqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_float4)( &si_rotqmby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbyte);
	    eval 'sub spu_rlmaskqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &si_rotqmby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbyte);
	    eval 'sub spu_rlmaskqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &si_rotqmby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbyte);
	    eval 'sub spu_rlmaskqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_double2)( &si_rotqmby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbyte);
	    eval 'sub spu_rlmaskqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_char16)( &si_rotqmbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbytebc);
	    eval 'sub spu_rlmaskqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_ushort8)( &si_rotqmbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbytebc);
	    eval 'sub spu_rlmaskqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_short8)( &si_rotqmbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbytebc);
	    eval 'sub spu_rlmaskqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_uint4)( &si_rotqmbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbytebc);
	    eval 'sub spu_rlmaskqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_int4)( &si_rotqmbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbytebc);
	    eval 'sub spu_rlmaskqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_float4)( &si_rotqmbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbytebc);
	    eval 'sub spu_rlmaskqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &si_rotqmbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbytebc);
	    eval 'sub spu_rlmaskqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &si_rotqmbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbytebc);
	    eval 'sub spu_rlmaskqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_double2)( &si_rotqmbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlmaskqwbytebc);
	    eval 'sub spu_rlqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_char16)( &si_rotqby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbyte);
	    eval 'sub spu_rlqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_ushort8)( &si_rotqby(( &qword)($a),  &si_from_int($count)))); } );
	    }' unless defined(&spu_rlqwbyte);
	    eval 'sub spu_rlqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_short8)( &si_rotqby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbyte);
	    eval 'sub spu_rlqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_uint4)( &si_rotqby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbyte);
	    eval 'sub spu_rlqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_int4)( &si_rotqby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbyte);
	    eval 'sub spu_rlqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_float4)( &si_rotqby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbyte);
	    eval 'sub spu_rlqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &si_rotqby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbyte);
	    eval 'sub spu_rlqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &si_rotqby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbyte);
	    eval 'sub spu_rlqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_double2)( &si_rotqby(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbyte);
	    eval 'sub spu_rlqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_char16)( &si_rotqbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbytebc);
	    eval 'sub spu_rlqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_ushort8)( &si_rotqbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbytebc);
	    eval 'sub spu_rlqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_short8)( &si_rotqbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbytebc);
	    eval 'sub spu_rlqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_uint4)( &si_rotqbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbytebc);
	    eval 'sub spu_rlqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_int4)( &si_rotqbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbytebc);
	    eval 'sub spu_rlqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_float4)( &si_rotqbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbytebc);
	    eval 'sub spu_rlqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &si_rotqbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbytebc);
	    eval 'sub spu_rlqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &si_rotqbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbytebc);
	    eval 'sub spu_rlqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_double2)( &si_rotqbybi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqwbytebc);
	    eval 'sub spu_rlqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_char16)( &si_rotqbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqw);
	    eval 'sub spu_rlqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_ushort8)( &si_rotqbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqw);
	    eval 'sub spu_rlqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_short8)( &si_rotqbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqw);
	    eval 'sub spu_rlqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_uint4)( &si_rotqbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqw);
	    eval 'sub spu_rlqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_int4)( &si_rotqbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqw);
	    eval 'sub spu_rlqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_float4)( &si_rotqbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqw);
	    eval 'sub spu_rlqw {
	        my($a,$count) = @_;
    		eval q({ (( &si_rotqbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqw);
	    eval 'sub spu_rlqw {
	        my($a,$count) = @_;
    		eval q({ (( &si_rotqbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqw);
	    eval 'sub spu_rlqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_double2)( &si_rotqbi(( &qword)($a),  &si_from_int($count)))); });
	    }' unless defined(&spu_rlqw);
	    eval 'sub spu_rsqrte {
	        my($_a) = @_;
    		eval q( &vec_rsqrte($_a));
	    }' unless defined(&spu_rsqrte);
	    eval 'sub spu_sel {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_char16)( &si_selb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_sel);
	    eval 'sub spu_sel {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_ushort8)( &si_selb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_sel);
	    eval 'sub spu_sel {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_short8)( &si_selb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_sel);
	    eval 'sub spu_sel {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_uint4)( &si_selb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_sel);
	    eval 'sub spu_sel {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_int4)( &si_selb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_sel);
	    eval 'sub spu_sel {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_float4)( &si_selb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_sel);
	    eval 'sub spu_sel {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &si_selb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_sel);
	    eval 'sub spu_sel {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &si_selb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_sel);
	    eval 'sub spu_sel {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_double2)( &si_selb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_sel);
	    eval 'sub spu_shuffle {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_char16)( &si_shufb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_shuffle);
	    eval 'sub spu_shuffle {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_ushort8)( &si_shufb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_shuffle);
	    eval 'sub spu_shuffle {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_short8)( &si_shufb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_shuffle);
	    eval 'sub spu_shuffle {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_uint4)( &si_shufb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_shuffle);
	    eval 'sub spu_shuffle {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_int4)( &si_shufb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_shuffle);
	    eval 'sub spu_shuffle {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_float4)( &si_shufb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_shuffle);
	    eval 'sub spu_shuffle {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &si_shufb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_shuffle);
	    eval 'sub spu_shuffle {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &si_shufb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_shuffle);
	    eval 'sub spu_shuffle {
	        my($a,$b,$pattern) = @_;
    		eval q({ (( &vec_double2)( &si_shufb(( &qword)($a), ( &qword)($b), ( &qword)($pattern)))); });
	    }' unless defined(&spu_shuffle);
	    eval 'sub spu_sl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_shlh(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_sl);
	    eval 'sub spu_sl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_shl(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_sl);
	    eval 'sub spu_sl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_shl(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_sl);
	    eval 'sub spu_sl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_shlhi(( &qword)($a), $b))); });
	    }' unless defined(&spu_sl);
	    eval 'sub spu_sl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_shlhi(( &qword)($a), $b))); });
	    }' unless defined(&spu_sl);
	    eval 'sub spu_sl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_shli(( &qword)($a), $b))); });
	    }' unless defined(&spu_sl);
	    eval 'sub spu_sl {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_shli(( &qword)($a), $b))); });
	    }' unless defined(&spu_sl);
	    eval 'sub spu_slqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_char16)( &si_shlqbi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqw);
	    eval 'sub spu_slqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_ushort8)( &si_shlqbi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqw);
	    eval 'sub spu_slqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_short8)( &si_shlqbi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqw);
	    eval 'sub spu_slqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_uint4)( &si_shlqbi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqw);
	    eval 'sub spu_slqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_int4)( &si_shlqbi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqw);
	    eval 'sub spu_slqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_float4)( &si_shlqbi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqw);
	    eval 'sub spu_slqw {
	        my($a,$count) = @_;
    		eval q({ (( &si_shlqbi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqw);
	    eval 'sub spu_slqw {
	        my($a,$count) = @_;
    		eval q({ (( &si_shlqbi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqw);
	    eval 'sub spu_slqw {
	        my($a,$count) = @_;
    		eval q({ (( &vec_double2)( &si_shlqbi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqw);
	    eval 'sub spu_slqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_char16)( &si_shlqby(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbyte);
	    eval 'sub spu_slqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_ushort8)( &si_shlqby(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbyte);
	    eval 'sub spu_slqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_short8)( &si_shlqby(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbyte);
	    eval 'sub spu_slqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_uint4)( &si_shlqby(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbyte);
	    eval 'sub spu_slqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_int4)( &si_shlqby(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbyte);
	    eval 'sub spu_slqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_float4)( &si_shlqby(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbyte);
	    eval 'sub spu_slqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &si_shlqby(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbyte);
	    eval 'sub spu_slqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &si_shlqby(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbyte);
	    eval 'sub spu_slqwbyte {
	        my($a,$count) = @_;
    		eval q({ (( &vec_double2)( &si_shlqby(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbyte);
	    eval 'sub spu_slqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_char16)( &si_shlqbybi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbytebc);
	    eval 'sub spu_slqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_ushort8)( &si_shlqbybi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbytebc);
	    eval 'sub spu_slqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_short8)( &si_shlqbybi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbytebc);
	    eval 'sub spu_slqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_uint4)( &si_shlqbybi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbytebc);
	    eval 'sub spu_slqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_int4)( &si_shlqbybi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbytebc);
	    eval 'sub spu_slqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_float4)( &si_shlqbybi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbytebc);
	    eval 'sub spu_slqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &si_shlqbybi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbytebc);
	    eval 'sub spu_slqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &si_shlqbybi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbytebc);
	    eval 'sub spu_slqwbytebc {
	        my($a,$count) = @_;
    		eval q({ (( &vec_double2)( &si_shlqbybi(( &qword)($a),  &si_from_uint($count)))); });
	    }' unless defined(&spu_slqwbytebc);
	    eval 'sub spu_splats {
	        my($a) = @_;
    		eval q({ (( &vec_char16) &spu_splats(($a))); });
	    }' unless defined(&spu_splats);
	    eval 'sub spu_splats {
	        my($a) = @_;
    		eval q({ \'union union\' {  &vec_ushort8  &v; my $s[8]; }  &in;  ($in->{s[0]}) = $a; ( &vec_splat( ($in->{v}), 0)); });
	    }' unless defined(&spu_splats);
	    eval 'sub spu_splats {
	        my($a) = @_;
    		eval q({ (( &vec_short8) &spu_splats(($a))); });
	    }' unless defined(&spu_splats);
	    eval 'sub spu_splats {
	        my($a) = @_;
    		eval q({ \'union union\' {  &vec_uint4  &v; my $i[4]; }  &in;  ($in->{i[0]}) = $a; ( &vec_splat( ($in->{v}), 0)); });
	    }' unless defined(&spu_splats);
	    eval 'sub spu_splats {
	        my($a) = @_;
    		eval q({ (( &vec_int4) &spu_splats(($a))); });
	    }' unless defined(&spu_splats);
	    eval 'sub spu_splats {
	        my($a) = @_;
    		eval q({ \'union union\' {  &vec_float4  &v; \'float\'  $f[4]; }  &in;  ($in->{f[0]}) = $a; ( &vec_splat( ($in->{v}), 0)); });
	    }' unless defined(&spu_splats);
	    eval 'sub spu_splats {
	        my($a) = @_;
    		eval q({ \'union union\' { my $v; my $l[2]; }  &in;  ($in->{l[0]}) = $a;  ($in->{l[1]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_splats);
	    eval 'sub spu_splats {
	        my($a) = @_;
    		eval q({ ( &spu_splats(($a))); });
	    }' unless defined(&spu_splats);
	    eval 'sub spu_splats {
	        my($a) = @_;
    		eval q({ \'union union\' {  &vec_double2  &v; \'double\'  $d[2]; }  &in;  ($in->{d[0]}) = $a;  ($in->{d[1]}) = $a; ( ($in->{v})); });
	    }' unless defined(&spu_splats);
	    eval 'sub spu_stop {
	        my($_type) = @_;
    		eval q( &si_stop($_type));
	    }' unless defined(&spu_stop);
	    eval 'sub spu_sub {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_sfh(( &qword)($b), ( &qword)($a)))); });
	    }' unless defined(&spu_sub);
	    eval 'sub spu_sub {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_sf(( &qword)($b), ( &qword)($a)))); });
	    }' unless defined(&spu_sub);
	    eval 'sub spu_sub {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_sf(( &qword)($b), ( &qword)($a)))); });
	    }' unless defined(&spu_sub);
	    eval 'sub spu_sub {
	        my($a,$b) = @_;
    		eval q({ (( &vec_float4)( &si_fs(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_sub);
	    eval 'sub spu_sub {
	        my($a,$b) = @_;
    		eval q({ (( &vec_double2)( &si_dfs(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_sub);
	    eval 'sub spu_sub {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_sfi(( &qword)$b, $a))); });
	    }' unless defined(&spu_sub);
	    eval 'sub spu_sub {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_sfi(( &qword)$b, $a))); });
	    }' unless defined(&spu_sub);
	    eval 'sub spu_sub {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_sfhi(( &qword)$b, $a))); });
	    }' unless defined(&spu_sub);
	    eval 'sub spu_sub {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_sfhi(( &qword)$b, $a))); });
	    }' unless defined(&spu_sub);
	    eval 'sub spu_subx {
	        my($a,$b,$c) = @_;
    		eval q({ (( &vec_int4)( &si_sfx(( &qword)($b), ( &qword)($a), ( &qword)($c)))); });
	    }' unless defined(&spu_subx);
	    eval 'sub spu_sync () {
	        eval q();
	    }' unless defined(&spu_sync);
	    eval 'sub spu_sync_c () {
	        eval q();
	    }' unless defined(&spu_sync_c);
	    eval 'sub spu_writech {
	        my($_channel, $_a) = @_;
    		eval q();
	    }' unless defined(&spu_writech);
	    eval 'sub spu_writechqw {
	        my($_channel, $_a) = @_;
    		eval q();
	    }' unless defined(&spu_writechqw);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &vec_char16)( &si_xor(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_xor(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_xor(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_xor(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_xor(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &vec_float4)( &si_xor(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &si_xor(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &si_xor(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &vec_double2)( &si_xor(( &qword)($a), ( &qword)($b)))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uchar16)( &si_xorbi(( &qword)($a), $b))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &vec_char16)( &si_xorbi(( &qword), ($b)))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &vec_ushort8)( &si_xorhi(( &qword)($a), $b))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &vec_short8)( &si_xorhi(( &qword), ($b)))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &vec_uint4)( &si_xori(( &qword)($a), $b))); });
	    }' unless defined(&spu_xor);
	    eval 'sub spu_xor {
	        my($a,$b) = @_;
    		eval q({ (( &vec_int4)( &si_xori(( &qword), ($b)))); });
	    }' unless defined(&spu_xor);
	}
    }
}
1;
