/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.proxy;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.parosproxy.paros.core.proxy.CacheProcessingItem;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.core.proxy.ProxyThreadSSL;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpInputStream;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpOutputStream;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.HttpUtil;

class ProxyThread
implements Runnable {
    private static final int TIME_OUT = 60000;
    private static final String CONNECT_HTTP_200 = "HTTP/1.1 200 Connection established\r\nProxy-connection: Keep-alive\r\n\r\n";
    private static Log log = LogFactory.getLog(class$org$parosproxy$paros$core$proxy$ProxyThread == null ? (class$org$parosproxy$paros$core$proxy$ProxyThread = ProxyThread.class$("org.parosproxy.paros.core.proxy.ProxyThread")) : class$org$parosproxy$paros$core$proxy$ProxyThread);
    protected ProxyServer parentServer = null;
    protected ProxyParam proxyParam = null;
    protected ConnectionParam connectionParam = null;
    protected Thread thread = null;
    protected Socket inSocket = null;
    protected Socket outSocket = null;
    protected HttpInputStream httpIn = null;
    protected HttpOutputStream httpOut = null;
    protected ProxyThread originProcess = this;
    private HttpSender httpSender = null;
    private Object semaphore = this;
    private static Object semaphoreSingleton = new Object();
    private static Vector proxyThreadList = new Vector();
    private static final Pattern remove_gzip1 = Pattern.compile("(gzip|deflate|compress|x-gzip|x-compress)[^,]*,?\\s*", 2);
    private static final Pattern remove_gzip2 = Pattern.compile("[,]\\z", 2);
    static /* synthetic */ Class class$org$parosproxy$paros$core$proxy$ProxyThread;

    ProxyThread(ProxyServer proxyServer, Socket socket) {
        this.inSocket = socket;
        try {
            this.inSocket.setTcpNoDelay(true);
            this.inSocket.setSoTimeout(60000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.setPriority(4);
        this.parentServer = proxyServer;
        this.proxyParam = this.parentServer.getProxyParam();
        this.connectionParam = this.parentServer.getConnectionParam();
    }

    public void start() {
        this.thread.start();
    }

    private void beginSSL() throws IOException {
        boolean bl = true;
        HttpRequestHeader httpRequestHeader = null;
        this.inSocket = HttpSender.getSSLConnector().createTunnelServerSocket(this.inSocket);
        this.httpIn = new HttpInputStream(this.inSocket);
        this.httpOut = new HttpOutputStream(this.inSocket.getOutputStream());
        httpRequestHeader = this.httpIn.readRequestHeader(bl);
        this.processHttp(httpRequestHeader, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        proxyThreadList.add(this.thread);
        boolean bl = this instanceof ProxyThreadSSL;
        HttpRequestHeader httpRequestHeader = null;
        try {
            this.httpIn = new HttpInputStream(this.inSocket);
            this.httpOut = new HttpOutputStream(this.inSocket.getOutputStream());
            httpRequestHeader = this.httpIn.readRequestHeader(bl);
            if (httpRequestHeader.getMethod().equalsIgnoreCase("CONNECT")) {
                this.httpOut.write(CONNECT_HTTP_200);
                this.httpOut.flush();
                this.beginSSL();
            } else {
                this.processHttp(httpRequestHeader, bl);
            }
        }
        catch (IOException iOException) {
            log.warn(iOException.getMessage());
        }
        finally {
            proxyThreadList.remove(this.thread);
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processHttp(HttpRequestHeader httpRequestHeader, boolean bl) throws IOException {
        HttpBody httpBody = null;
        boolean bl2 = true;
        HttpMessage httpMessage = null;
        if (this.isRecursive(httpRequestHeader)) {
            throw new IOException("Recursive request to proxy itself stopped.");
        }
        this.inSocket.setSoTimeout(2500);
        do {
            if (bl2) {
                bl2 = false;
            } else {
                try {
                    httpRequestHeader = this.httpIn.readRequestHeader(bl);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    return;
                }
            }
            httpMessage = new HttpMessage();
            httpMessage.setRequestHeader(httpRequestHeader);
            if (httpMessage.getRequestHeader().getContentLength() > 0) {
                httpBody = this.httpIn.readBody(httpRequestHeader);
                httpMessage.setRequestBody(httpBody);
            }
            this.modifyHeader(httpMessage);
            if (this.isProcessCache(httpMessage)) continue;
            this.semaphore = this.parentServer.isSerialize() ? semaphoreSingleton : this;
            Object object = this.semaphore;
            synchronized (object) {
                this.notifyListenerRequestSend(httpMessage);
                this.getHttpSender().sendAndReceive(httpMessage);
                this.notifyListenerResponseReceive(httpMessage);
                this.httpOut.write(httpMessage.getResponseHeader());
                this.httpOut.flush();
                if (httpMessage.getResponseBody().length() > 0) {
                    this.httpOut.write(httpMessage.getResponseBody().getBytes());
                    this.httpOut.flush();
                }
            }
        } while (!this.isConnectionClose(httpMessage) && !this.inSocket.isClosed());
    }

    private boolean isConnectionClose(HttpMessage httpMessage) {
        if (httpMessage == null || httpMessage.getResponseHeader().isEmpty()) {
            return true;
        }
        if (httpMessage.getRequestHeader().isConnectionClose()) {
            return true;
        }
        if (httpMessage.getResponseHeader().isConnectionClose()) {
            return true;
        }
        return httpMessage.getResponseHeader().getContentLength() == -1 && httpMessage.getResponseBody().length() > 0;
    }

    protected void disconnect() {
        try {
            if (this.httpIn != null) {
                this.httpIn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.httpOut != null) {
                this.httpOut.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        HttpUtil.closeSocket(this.inSocket);
        if (this.httpSender != null) {
            this.httpSender.shutdown();
        }
    }

    private void notifyListenerRequestSend(HttpMessage httpMessage) {
        ProxyListener proxyListener = null;
        List list = this.parentServer.getListenerList();
        for (int i = 0; i < list.size(); ++i) {
            proxyListener = (ProxyListener)list.get(i);
            try {
                proxyListener.onHttpRequestSend(httpMessage);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void notifyListenerResponseReceive(HttpMessage httpMessage) {
        ProxyListener proxyListener = null;
        List list = this.parentServer.getListenerList();
        for (int i = 0; i < list.size(); ++i) {
            proxyListener = (ProxyListener)list.get(i);
            try {
                proxyListener.onHttpResponseReceive(httpMessage);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isRecursive(HttpRequestHeader httpRequestHeader) {
        boolean bl = false;
        try {
            URI uRI = httpRequestHeader.getURI();
            if (uRI.getHost().equals(this.proxyParam.getProxyIp()) && uRI.getPort() == this.proxyParam.getProxyPort()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private void modifyHeader(HttpMessage httpMessage) {
        String string = httpMessage.getRequestHeader().getHeader("Accept-Encoding");
        if (string == null) {
            return;
        }
        string = remove_gzip1.matcher(string).replaceAll("");
        if ((string = remove_gzip2.matcher(string).replaceAll("")).length() == 0) {
            string = null;
        }
        httpMessage.getRequestHeader().setHeader("Accept-Encoding", string);
    }

    protected HttpSender getHttpSender() {
        if (this.httpSender == null) {
            this.httpSender = new HttpSender(this.connectionParam, true);
        }
        return this.httpSender;
    }

    static boolean isAnyProxyThreadRunning() {
        return !proxyThreadList.isEmpty();
    }

    protected boolean isProcessCache(HttpMessage httpMessage) throws IOException {
        if (!this.parentServer.isEnableCacheProcessing()) {
            return false;
        }
        if (this.parentServer.getCacheProcessingList().isEmpty()) {
            return false;
        }
        CacheProcessingItem cacheProcessingItem = (CacheProcessingItem)this.parentServer.getCacheProcessingList().get(0);
        if (httpMessage.equals(cacheProcessingItem.message)) {
            HttpMessage httpMessage2 = cacheProcessingItem.message.cloneAll();
            httpMessage.setResponseHeader(httpMessage2.getResponseHeader());
            httpMessage.setResponseBody(httpMessage2.getResponseBody());
            this.httpOut.write(httpMessage.getResponseHeader());
            this.httpOut.flush();
            if (httpMessage.getResponseBody().length() > 0) {
                this.httpOut.write(httpMessage.getResponseBody().getBytes());
                this.httpOut.flush();
            }
            return true;
        }
        try {
            RecordHistory recordHistory = Model.getSingleton().getDb().getTableHistory().getHistoryCache(cacheProcessingItem.reference, httpMessage);
            if (recordHistory == null) {
                return false;
            }
            httpMessage.setResponseHeader(recordHistory.getHttpMessage().getResponseHeader());
            httpMessage.setResponseBody(recordHistory.getHttpMessage().getResponseBody());
            this.httpOut.write(httpMessage.getResponseHeader());
            this.httpOut.flush();
            if (httpMessage.getResponseBody().length() > 0) {
                this.httpOut.write(httpMessage.getResponseBody().getBytes());
                this.httpOut.flush();
            }
            return true;
        }
        catch (Exception exception) {
            return true;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

