/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.util.regex.Pattern;
import org.parosproxy.paros.core.scanner.AbstractAppParamPlugin;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;

public class TestParameterTamper
extends AbstractAppParamPlugin {
    private static String[] PARAM_LIST = new String[]{"", "", "@", "+", AbstractPlugin.getURLDecode("%00"), "|"};
    private static Pattern patternErrorJava1 = Pattern.compile("javax\\.servlet\\.\\S+", 10);
    private static Pattern patternErrorJava2 = Pattern.compile("invoke.+exception|exception.+invoke", 10);
    private static Pattern patternErrorVBScript = Pattern.compile("Microsoft(\\s+|&nbsp)*VBScript(\\s+|&nbsp)+error", 10);
    private static Pattern patternErrorODBC1 = Pattern.compile("Microsoft OLE DB Provider for ODBC Drivers.*error", 10);
    private static Pattern patternErrorODBC2 = Pattern.compile("ODBC.*Drivers.*error", 10);
    private static Pattern patternErrorJet = Pattern.compile("Microsoft JET Database Engine.*error", 10);
    private static Pattern patternErrorPHP = Pattern.compile(" on line <b>", 10);
    private static Pattern patternErrorTomcat = Pattern.compile("(Apache Tomcat).*(^Caused by:|HTTP Status 500 - Internal Server Error)", 10);

    public int getId() {
        return 40010;
    }

    public String getName() {
        return "Parameter tampering";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        String string = "Certain parameter caused error page or Java stacktrace to be displayed.  This indicated lack of exception handling and potential areas for further exploit.";
        return string;
    }

    public int getCategory() {
        return 4;
    }

    public String getSolution() {
        return "Identify the cause of the error and fix it.  Do not trust client side input and enforece tight check in the server side.  Besides, catch the exception properly.  Use a generic 500 error page for internal server error.";
    }

    public String getReference() {
        return "";
    }

    public void init() {
    }

    public void scan(HttpMessage httpMessage, String string, String string2) {
        String string3 = null;
        HttpMessage httpMessage2 = this.getNewMsg();
        try {
            this.sendAndReceive(httpMessage2);
        }
        catch (Exception exception) {
            return;
        }
        if (httpMessage2.getResponseHeader().getStatusCode() != 200) {
            return;
        }
        for (int i = 0; i < PARAM_LIST.length; ++i) {
            httpMessage = this.getNewMsg();
            string3 = i == 0 ? this.setParameter(httpMessage, null, null) : this.setParameter(httpMessage, string, PARAM_LIST[i]);
            try {
                this.sendAndReceive(httpMessage);
                if (!this.checkResult(httpMessage, string3, httpMessage2.getResponseBody().toString())) continue;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean checkResult(HttpMessage httpMessage, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (httpMessage.getResponseHeader().getStatusCode() != 200 && !HttpStatusCode.isServerError(httpMessage.getResponseHeader().getStatusCode())) {
            return false;
        }
        if (httpMessage.getResponseBody().toString().equals(string2)) {
            return false;
        }
        if (this.matchBodyPattern(httpMessage, patternErrorJava1, stringBuffer) && this.matchBodyPattern(httpMessage, patternErrorJava2, null)) {
            this.bingo(2, 1, null, string == null || string.length() == 0 ? "nil" : string, stringBuffer.toString(), httpMessage);
            return true;
        }
        if (this.matchBodyPattern(httpMessage, patternErrorVBScript, stringBuffer) || this.matchBodyPattern(httpMessage, patternErrorODBC1, stringBuffer) || this.matchBodyPattern(httpMessage, patternErrorODBC2, stringBuffer) || this.matchBodyPattern(httpMessage, patternErrorJet, stringBuffer) || this.matchBodyPattern(httpMessage, patternErrorTomcat, stringBuffer) || this.matchBodyPattern(httpMessage, patternErrorPHP, stringBuffer)) {
            this.bingo(2, 0, "", string == null || string.length() == 0 ? "nil" : string, stringBuffer.toString(), httpMessage);
            return true;
        }
        return false;
    }
}

