/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.parosproxy.paros.extension.filter.FilterAdaptor;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpResponseHeader;

public class FilterDetectSetCookie
extends FilterAdaptor {
    private static final String DELIM = "\t";
    private static final String CRLF = "\r\n";
    private Pattern pattern = Pattern.compile("^ *Set-[Cc]ookie *: *([^\\r\\n]*)\\r\\n", 10);
    private Matcher matcher = null;
    private Vector result = null;

    public int getId() {
        return 110;
    }

    public String getName() {
        return "Detect and alert 'Set-cookie' attempt in HTTP response for modification.";
    }

    public void init() {
    }

    public void onHttpRequestSend(HttpMessage httpMessage) {
    }

    public void onHttpResponseReceive(HttpMessage httpMessage) {
        HttpResponseHeader httpResponseHeader = httpMessage.getResponseHeader();
        if (httpResponseHeader == null || httpResponseHeader.isEmpty()) {
            return;
        }
        if (httpResponseHeader.getHeader("Set-cookie") != null) {
            String string = httpResponseHeader.toString();
            this.matcher = this.pattern.matcher(string);
            this.result = new Vector();
            while (this.matcher.find()) {
                String string2 = this.matcher.group(1);
                if (string2 == null) continue;
                this.getView().getMainFrame().toFront();
                String string3 = JOptionPane.showInputDialog(this.getView().getMainFrame(), "Accept the following cookie (Ok=Accept, Cancel=Reject)?", string2);
                if (string3 != null && !string3.equals("")) {
                    httpResponseHeader.setHeader("Set-cookie", null);
                    this.result.add(string3);
                    continue;
                }
                if (string3 != null) continue;
                httpResponseHeader.setHeader("Set-cookie", null);
            }
            if (this.result.size() > 0) {
                string = this.matcher.replaceAll("");
                for (int i = 0; i < this.result.size(); ++i) {
                    string = string + "Set-Cookie: " + this.result.get(i).toString() + CRLF;
                }
                try {
                    httpResponseHeader.setMessage(string);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
            this.result.clear();
        }
    }
}

