/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.parosproxy.paros.extension.filter.FilterAdaptor;
import org.parosproxy.paros.network.HttpMessage;

public class FilterLogRequestResponse
extends FilterAdaptor {
    private static final String logFile = "filter/message.txt";
    private static final String delim = "====================================";
    private static final String CRLF = "\r\n";
    private File outFile = new File("filter/message.txt");
    private BufferedWriter writer = null;
    private long lastWriteTime = System.currentTimeMillis();
    private int counter = 1;

    public int getId() {
        return 40;
    }

    public String getName() {
        return "Log request and response into file (filter/message.txt)";
    }

    public void onHttpRequestSend(HttpMessage httpMessage) {
    }

    public void onHttpResponseReceive(HttpMessage httpMessage) {
        if (!httpMessage.getRequestHeader().isText() || httpMessage.getRequestHeader().isImage() || httpMessage.getResponseHeader().isImage()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(httpMessage.getRequestHeader().toString());
        stringBuffer.append(httpMessage.getRequestBody().toString() + CRLF);
        if (!httpMessage.getResponseHeader().isEmpty()) {
            stringBuffer.append(httpMessage.getResponseHeader().toString());
            stringBuffer.append(httpMessage.getResponseBody().toString() + CRLF);
        }
        this.writeLogFile(stringBuffer.toString());
    }

    private synchronized void writeLogFile(String string) {
        try {
            if (this.getWriter() != null) {
                this.getWriter().write("===== " + this.counter + " " + delim + CRLF);
                this.getWriter().write(string + CRLF);
                ++this.counter;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void timer() {
        if (this.writer != null && System.currentTimeMillis() > this.lastWriteTime + 5000L) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private synchronized BufferedWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new BufferedWriter(new FileWriter(this.outFile, true));
        }
        return this.writer;
    }
}

