/*
 * Copyright (C) 1997-2004, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmvmap.h,v 1.3 2004/01/17 04:06:42 wes Exp $
 * Version: $Name: OpenRM-1-5-2-RC3 $
 * $Revision: 1.3 $
 * $Log: rmvmap.h,v $
 * Revision 1.3  2004/01/17 04:06:42  wes
 * Updated Copyright line for 2004.
 *
 * Revision 1.2  2003/02/02 02:07:14  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.5  2002/04/30 19:42:33  wes
 * Updated copyright dates.
 *
 * Revision 1.4  2001/03/31 17:13:59  wes
 * v1.4.0-alpha-2 checkin
 *
 * Revision 1.3  2000/04/20 17:41:46  wes
 * Minor CVS tag changes.
 *
 * Revision 1.2  2000/04/20 16:30:24  wes
 * Added copyright info.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

#ifndef _rmvmap_h
#define _rmvmap_h

#ifdef __cplusplus
extern "C" {
#endif
    
/* rmvmap.c:  visualization map routines [17] */
RM_EXPORT_API  RMvisMap *rmVismapNew (int size);
RM_EXPORT_API  RMvisMap *rmVismapDup (const RMvisMap *toDuplicate);
RM_EXPORT_API  RMenum    rmVismapDelete (RMvisMap *toDelete);
RM_EXPORT_API  RMenum    rmVismapSetColor3D (RMvisMap *toModify, int indx, const RMcolor3D *newColor);
RM_EXPORT_API  RMenum    rmVismapGetColor3D (const RMvisMap *toQuery, int indx, RMcolor3D *retColor);
RM_EXPORT_API  RMenum    rmVismapSetColor4D (RMvisMap *toModify, int indx,const RMcolor4D *newColor);
RM_EXPORT_API  RMenum    rmVismapGetColor4D (const RMvisMap *toQuery, int indx, RMcolor4D *retColor);
RM_EXPORT_API  RMenum    rmVismapSetTfMin (RMvisMap *toModify, float newTFMin);
RM_EXPORT_API  float     rmVismapGetTfMin (const RMvisMap *toQuery);
RM_EXPORT_API  RMenum    rmVismapSetTfMax (RMvisMap *toModify, float newTFMax);
RM_EXPORT_API  float     rmVismapGetTfMax (const RMvisMap *toQuery);
RM_EXPORT_API  int       rmVismapIndexFromData (const RMvisMap *map, float val);
RM_EXPORT_API  RMenum    rmVismapSetSize (RMvisMap *toModify, int newSize);
RM_EXPORT_API  int       rmVismapGetSize (const RMvisMap *toQuery);
RM_EXPORT_API  RMenum    rmVismapSetAlpha (RMvisMap *toModify, int indx, float newAlpha);
RM_EXPORT_API  float     rmVismapGetAlpha (const RMvisMap *toQuery, int indx);
RM_EXPORT_API  RMvisMap *rmDefaultVismap (void);

#ifdef __cplusplus
}
#endif

#endif /* _rmvmap_h */
/* EOF */
