/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.utils;

import com.gentlyweb.utils.StringUtils;
import com.gentlyweb.utils.Timing;
import java.util.Date;

public class TimeDuration {
    public static final String DEFAULT_FORMAT_SPEC = "DDDd HHh mmm sss SSSms";
    private static final String DDD = "DDD";
    private static final String SSS = "SSS";
    private static final String ss = "ss";
    private static final String HH = "HH";
    private static final String mm = "mm";
    private static final int milli = 1;
    private static final int sec = 1000;
    private static final int min = 60000;
    private static final int hour = 3600000;
    private static final int day = 86400000;
    private int days = 0;
    private int hours = 0;
    private int mins = 0;
    private int secs = 0;
    private int millis = 0;

    public TimeDuration(int days, int hours, int mins, int secs) {
        this.days = days;
        this.hours = hours;
        this.mins = mins;
        this.secs = secs;
        this.sanitize();
    }

    public TimeDuration(Date from, Date to) {
        long f = 0L;
        long t = 0L;
        if (from != null) {
            f = from.getTime();
        }
        if (to != null) {
            t = to.getTime();
        }
        this.init(t - f);
    }

    public TimeDuration(Date d) {
        this.init(d.getTime());
    }

    public void init(long millis) {
        this.days = (int)(millis / 86400000L);
        long rem = millis - (long)(this.days * 86400000);
        this.hours = (int)(rem / 3600000L);
        this.mins = (int)((rem -= (long)(this.hours * 3600000)) / 60000L);
        this.secs = (int)((rem -= (long)(this.mins * 60000)) / 1000L);
        this.millis = (int)(rem - (long)(this.secs * 1000));
        this.sanitize();
    }

    public TimeDuration(long millis) {
        this.init(millis);
    }

    public TimeDuration(TimeDuration t) {
        this.init(t);
    }

    public TimeDuration(int days, int hours, int mins, int secs, int millis) {
        this.days = days;
        this.hours = hours;
        this.mins = mins;
        this.secs = secs;
        this.millis = millis;
        this.sanitize();
    }

    private void sanitize() {
        if (this.days < 0) {
            this.days = 0;
        }
        if (this.hours < 0) {
            this.hours = 0;
        }
        if (this.hours > 23) {
            this.hours = 23;
        }
        if (this.mins < 0) {
            this.mins = 0;
        }
        if (this.mins > 59) {
            this.mins = 59;
        }
        if (this.secs < 0) {
            this.secs = 0;
        }
        if (this.secs > 59) {
            this.secs = 59;
        }
        if (this.millis < 0) {
            this.millis = 0;
        }
        if (this.millis > 999) {
            this.millis = 999;
        }
    }

    public void init(TimeDuration t) {
        this.days = t.getDays();
        this.hours = t.getHours();
        this.mins = t.getMins();
        this.secs = t.getSecs();
        this.millis = t.getMillis();
        this.sanitize();
    }

    public void subtract(TimeDuration t) {
        TimeDuration tt = new TimeDuration(t.rollUpToMillis() - this.rollUpToMillis());
        this.init(tt);
    }

    public void add(TimeDuration t) {
        TimeDuration tt = new TimeDuration(t.rollUpToMillis() + this.rollUpToMillis());
        this.init(tt);
    }

    public static TimeDuration getInstance(TimeDuration t) {
        return new TimeDuration(t);
    }

    public static TimeDuration getInstance(Timing t) {
        return new TimeDuration(t.getDuration());
    }

    public static TimeDuration getInstance(Date d) {
        return TimeDuration.getInstance(d.getTime());
    }

    public static TimeDuration getInstance(long millis) {
        return new TimeDuration(millis);
    }

    public Date getAsDate() {
        return new Date(this.rollUpToMillis());
    }

    public long rollUpToMillis() {
        return (long)this.days * 86400000L + (long)(this.hours * 3600000) + (long)(this.mins * 60000) + (long)(this.secs * 1000) + (long)(this.millis * 1);
    }

    public void setMillis(int m) {
        this.millis = m;
        this.sanitize();
    }

    public int getMillis() {
        return this.millis;
    }

    public void setSecs(int s) {
        this.secs = s;
        this.sanitize();
    }

    public int getSecs() {
        return this.secs;
    }

    public void setMins(int m) {
        this.mins = m;
        this.sanitize();
    }

    public int getMins() {
        return this.mins;
    }

    public void setHours(int h) {
        this.hours = h;
        this.sanitize();
    }

    public int getHours() {
        return this.hours;
    }

    public void setDays(int d) {
        this.days = d;
    }

    public int getDays() {
        return this.days;
    }

    public String format() {
        return this.format(DEFAULT_FORMAT_SPEC);
    }

    public String format(String spec) {
        String s = spec;
        if (spec.indexOf(DDD) != -1) {
            s = StringUtils.replaceString(s, DDD, String.valueOf(this.days));
        }
        if (spec.indexOf(SSS) != -1) {
            s = StringUtils.replaceString(s, SSS, String.valueOf(this.millis));
        }
        if (spec.indexOf(ss) != -1) {
            s = StringUtils.replaceString(s, ss, String.valueOf(this.secs));
        }
        if (spec.indexOf(HH) != -1) {
            s = StringUtils.replaceString(s, HH, String.valueOf(this.hours));
        }
        if (spec.indexOf(mm) != -1) {
            s = StringUtils.replaceString(s, mm, String.valueOf(this.mins));
        }
        return s;
    }
}

