### Copyright (C) 1995-2000 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

### This file is based on dialog.tcl from the standard Tk4.0 distribution.
proc tk_dialog {w title text bitmap default args} {
  global tkPriv

  # 1. Create the top-level window and divide it into top
  # and bottom parts.

  catch {destroy $w}
  toplevel $w -class Dialog
  wm title $w $title
  wm iconname $w Dialog
  wm protocol $w WM_DELETE_WINDOW { }
  wm transient $w [winfo toplevel [winfo parent $w]]
  frame $w.top -relief raised -bd 1
  pack $w.top -side top -fill both
  frame $w.bot -relief raised -bd 1
  pack $w.bot -side bottom -fill both

  # 2. Fill the top part with bitmap and message.

  label $w.msg -wraplength 3i -justify left -text $text \
      -font -Adobe-Times-Medium-R-Normal--*-180-*-*-*-*-*-*
  pack $w.msg -in $w.top -side right -expand 1 -fill both -padx 3m -pady 3m
  if {$bitmap != ""} {
    label $w.bitmap -bitmap $bitmap
    pack $w.bitmap -in $w.top -side left -padx 3m -pady 3m
  }

  # 3. Create a row of buttons at the bottom of the dialog.

  set i 0
  foreach but $args {
    button $w.button$i -text $but -command "set tkPriv(button) $i"
    if {$i == $default} {
      frame $w.default -relief sunken -bd 1
      raise $w.button$i $w.default
      pack $w.default -in $w.bot -side left -expand 1 -padx 3m -pady 2m
      pack $w.button$i -in $w.default -padx 2m -pady 2m
      bind $w <Return> "$w.button$i flash; set tkPriv(button) $i"
    } else {
      pack $w.button$i -in $w.bot -side left -expand 1 \
	  -padx 3m -pady 2m
    }
    incr i
  }

  # 4. Withdraw the window, then update all the geometry information
  # so we know how big it wants to be, then center the window in the
  # display and de-iconify it.

  wm withdraw $w
  update idletasks
  set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	     - [winfo vrootx [winfo parent $w]]]
  set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	     - [winfo vrooty [winfo parent $w]]]
  wm geom $w +$x+$y
  wm deiconify $w

  # 5. Set a grab and claim the focus too.

  set oldFocus [focus]
  set count 0
  pushGrab local $w
  tkwait visibility $w
  if {$default >= 0} {
    focus $w.button$default
  } else {
    focus $w
  }

  # 6. Wait for the user to respond, then restore the focus and
  # return the index of the selected button.  Restore the focus
  # before deleting the window, since otherwise the window manager
  # may take the focus away so we can't redirect it.

  tkwait variable tkPriv(button)
  catch {focus $oldFocus}
  catch "destroy $w"
  popGrab
  return $tkPriv(button)
}
